package org.gcube.common.storagehub.model.storages;

import java.io.InputStream;

import org.gcube.common.storagehub.model.items.AbstractFileItem;
import org.gcube.common.storagehub.model.items.nodes.Content;

public interface StorageBackend {
	
	String getName();
	
	String onCopy(AbstractFileItem item);
	
	String onMove(AbstractFileItem item);
	
	void onDelete(Content id);
	
	MetaInfo upload(InputStream stream, String relativePath, String name);
	
	InputStream download(Content item);
	
	@Deprecated
	String getTotalSizeStored();
	@Deprecated
	String getTotalItemsCount();
	
}
