/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.storagehub.client.proxies;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.gxrest.request.GXWebTargetAdapterRequest;
import org.gcube.common.gxrest.response.inbound.GXInboundResponse;
import org.gcube.common.storagehub.client.proxies.DefaultManagerClient;
import org.gcube.common.storagehub.client.proxies.MessageManagerClient;
import org.gcube.common.storagehub.model.exceptions.BackendGenericError;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.exceptions.UserNotAuthorizedException;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.common.storagehub.model.messages.Message;
import org.gcube.common.storagehub.model.service.ItemList;
import org.gcube.common.storagehub.model.types.MessageList;

public class DefaultMessageManager
extends DefaultManagerClient
implements MessageManagerClient {
    public DefaultMessageManager(ProxyDelegate<GXWebTargetAdapterRequest> delegate) {
        super(delegate);
    }

    @Override
    public Message get(final String id) throws StorageHubException {
        Call<GXWebTargetAdapterRequest, Message> call = new Call<GXWebTargetAdapterRequest, Message>(){

            public Message call(GXWebTargetAdapterRequest manager) throws Exception {
                Objects.requireNonNull(id, "id cannot be null");
                GXWebTargetAdapterRequest myManager = manager.path(id);
                GXInboundResponse response = myManager.get();
                if (response.isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    throw new BackendGenericError("HTTP error code is " + response.getHTTPCode());
                }
                Message item = (Message)response.getSource().readEntity(Message.class);
                return item;
            }
        };
        try {
            return (Message)this.delegate.make((Call)call);
        }
        catch (StorageHubException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public List<Message> getReceivedMessages(int reduceBody) throws StorageHubException {
        return this.getMessages("inbox", reduceBody);
    }

    @Override
    public List<Message> getSentMessages(int reduceBody) throws StorageHubException {
        return this.getMessages("sent", reduceBody);
    }

    @Override
    public List<Message> getReceivedMessages() throws StorageHubException {
        return this.getMessages("inbox", -1);
    }

    @Override
    public List<Message> getSentMessages() throws StorageHubException {
        return this.getMessages("sent", -1);
    }

    @Override
    public void setRead(String id, Boolean value) throws StorageHubException {
        this.setBooleanProp("hl:read", value, id);
    }

    @Override
    public void setOpened(String id, Boolean value) throws StorageHubException {
        this.setBooleanProp("hl:open", value, id);
    }

    private void setBooleanProp(final String prop, final Boolean bool, final String id) throws StorageHubException {
        Call<GXWebTargetAdapterRequest, Void> call = new Call<GXWebTargetAdapterRequest, Void>(){

            public Void call(GXWebTargetAdapterRequest manager) throws Exception {
                GXWebTargetAdapterRequest myManager = manager.path(id).path(prop);
                GXInboundResponse response = myManager.put(Entity.json((Object)bool));
                if (response.isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    throw new BackendGenericError("HTTP error code is " + response.getHTTPCode());
                }
                return null;
            }
        };
        try {
            this.delegate.make((Call)call);
        }
        catch (StorageHubException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public String sendMessage(final List<String> recipients, final String subject, final String body, final List<String> attachments) throws StorageHubException {
        Call<GXWebTargetAdapterRequest, String> call = new Call<GXWebTargetAdapterRequest, String>(){

            public String call(GXWebTargetAdapterRequest manager) throws Exception {
                GXInboundResponse response;
                Objects.requireNonNull(recipients, "recipients cannot be null");
                Objects.requireNonNull(subject, "subject cannot be null");
                Objects.requireNonNull(body, "body cannot be null");
                GXWebTargetAdapterRequest myManager = manager.path("send");
                MultivaluedHashMap formData = new MultivaluedHashMap();
                recipients.forEach(arg_0 -> 3.lambda$call$0((MultivaluedMap)formData, arg_0));
                formData.add((Object)"subject", (Object)subject);
                formData.add((Object)"body", (Object)body);
                if (attachments != null) {
                    attachments.forEach(arg_0 -> 3.lambda$call$1((MultivaluedMap)formData, arg_0));
                }
                if ((response = myManager.post(Entity.entity((Object)formData, (String)"application/x-www-form-urlencoded"))).isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    throw new BackendGenericError("HTTP error code is " + response.getHTTPCode());
                }
                return (String)response.getSource().readEntity(String.class);
            }

            private static /* synthetic */ void lambda$call$1(MultivaluedMap formData, String a) {
                formData.add((Object)"attachments[]", (Object)a);
            }

            private static /* synthetic */ void lambda$call$0(MultivaluedMap formData, String r) {
                formData.add((Object)"to[]", (Object)r);
            }
        };
        try {
            return (String)this.delegate.make((Call)call);
        }
        catch (StorageHubException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public void delete(final String id) throws StorageHubException {
        Call<GXWebTargetAdapterRequest, Void> call = new Call<GXWebTargetAdapterRequest, Void>(){

            public Void call(GXWebTargetAdapterRequest manager) throws Exception {
                Objects.requireNonNull(id, "id cannot be null");
                GXWebTargetAdapterRequest myManager = manager.path(id);
                GXInboundResponse response = myManager.delete();
                if (response.isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    throw new BackendGenericError("HTTP error code is " + response.getHTTPCode());
                }
                return null;
            }
        };
        try {
            this.delegate.make((Call)call);
        }
        catch (StorageHubException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public List<? extends Item> getAttachments(final String messageId) throws StorageHubException {
        Call<GXWebTargetAdapterRequest, ItemList> call = new Call<GXWebTargetAdapterRequest, ItemList>(){

            public ItemList call(GXWebTargetAdapterRequest manager) throws Exception {
                GXWebTargetAdapterRequest myManager = manager.path(messageId).path("attachments");
                GXInboundResponse response = myManager.get();
                if (response.isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    if (response.getHTTPCode() == 403) {
                        throw new UserNotAuthorizedException("the call to this method is not allowed for the user");
                    }
                    throw new BackendGenericError();
                }
                return (ItemList)response.getSource().readEntity(ItemList.class);
            }
        };
        try {
            return ((ItemList)this.delegate.make((Call)call)).getItemlist();
        }
        catch (StorageHubException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    private List<Message> getMessages(final String path, final int reduceBody) throws StorageHubException {
        Call<GXWebTargetAdapterRequest, List<Message>> call = new Call<GXWebTargetAdapterRequest, List<Message>>(){

            public List<Message> call(GXWebTargetAdapterRequest manager) throws Exception {
                GXInboundResponse response;
                GXWebTargetAdapterRequest myManager = manager.path(path);
                if (reduceBody > 0) {
                    myManager.queryParams(Collections.singletonMap("reduceBody", new Object[]{reduceBody}));
                }
                if ((response = myManager.get()).isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    if (response.getHTTPCode() == 403) {
                        throw new UserNotAuthorizedException("the call to this method is not allowed for the user");
                    }
                    throw new BackendGenericError();
                }
                return ((MessageList)response.getSource().readEntity(MessageList.class)).getMessages();
            }
        };
        try {
            return (List)this.delegate.make((Call)call);
        }
        catch (StorageHubException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }
}

