/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.storagehub.client.proxies;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MultivaluedHashMap;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.gxrest.request.GXWebTargetAdapterRequest;
import org.gcube.common.gxrest.response.inbound.GXInboundResponse;
import org.gcube.common.storagehub.client.proxies.WorkspaceManagerClient;
import org.gcube.common.storagehub.model.exceptions.BackendGenericError;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.expressions.OrderField;
import org.gcube.common.storagehub.model.expressions.SearchableItem;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.common.storagehub.model.query.Query;
import org.gcube.common.storagehub.model.service.ItemList;
import org.gcube.common.storagehub.model.service.ItemWrapper;

public class DefaultWorkspaceManager
implements WorkspaceManagerClient {
    private final ProxyDelegate<GXWebTargetAdapterRequest> delegate;

    public DefaultWorkspaceManager(ProxyDelegate<GXWebTargetAdapterRequest> config) {
        this.delegate = config;
    }

    @Override
    public <T extends Item> T getWorkspace(final String ... excludeNodes) {
        Call call = new Call<GXWebTargetAdapterRequest, ItemWrapper<T>>(){

            public ItemWrapper<T> call(GXWebTargetAdapterRequest manager) throws Exception {
                GXInboundResponse response;
                GXWebTargetAdapterRequest myManager = manager;
                HashMap<String, String[]> params = new HashMap<String, String[]>();
                if (excludeNodes != null && excludeNodes.length > 0) {
                    params.put("exclude", excludeNodes);
                }
                if ((response = myManager.queryParams(params).get()).isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    throw new BackendGenericError("HTTP error code is " + response.getHTTPCode());
                }
                return (ItemWrapper)response.getSource().readEntity(ItemWrapper.class);
            }
        };
        try {
            ItemWrapper result = (ItemWrapper)this.delegate.make(call);
            return (T)result.getItem();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<? extends Item> getVreFolders(final String ... excludeNodes) {
        Call<GXWebTargetAdapterRequest, ItemList> call = new Call<GXWebTargetAdapterRequest, ItemList>(){

            public ItemList call(GXWebTargetAdapterRequest manager) throws Exception {
                GXInboundResponse response;
                GXWebTargetAdapterRequest myManager = manager.path("vrefolders");
                HashMap<String, String[]> params = new HashMap<String, String[]>();
                if (excludeNodes != null && excludeNodes.length > 0) {
                    params.put("exclude", excludeNodes);
                }
                if ((response = myManager.queryParams(params).get()).isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    throw new BackendGenericError("HTTP error code is " + response.getHTTPCode());
                }
                return (ItemList)response.getSource().readEntity(ItemList.class);
            }
        };
        try {
            ItemList result = (ItemList)this.delegate.make((Call)call);
            return result.getItemlist();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<? extends Item> getVreFolders(final int start, final int limit, final String ... excludeNodes) {
        Call<GXWebTargetAdapterRequest, ItemList> call = new Call<GXWebTargetAdapterRequest, ItemList>(){

            public ItemList call(GXWebTargetAdapterRequest manager) throws Exception {
                GXWebTargetAdapterRequest myManager = manager.path("vrefolders").path("paged");
                HashMap<String, Object[]> params = new HashMap<String, Object[]>();
                if (excludeNodes != null && excludeNodes.length > 0) {
                    params.put("exclude", excludeNodes);
                }
                params.put("start", new Object[]{start});
                params.put("limit", new Object[]{limit});
                GXInboundResponse response = myManager.queryParams(params).get();
                if (response.isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    throw new BackendGenericError("HTTP error code is " + response.getHTTPCode());
                }
                return (ItemList)response.getSource().readEntity(ItemList.class);
            }
        };
        try {
            ItemList result = (ItemList)this.delegate.make((Call)call);
            return result.getItemlist();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T extends Item> T getVreFolder(final String ... excludeNodes) {
        Call call = new Call<GXWebTargetAdapterRequest, ItemWrapper<T>>(){

            public ItemWrapper<T> call(GXWebTargetAdapterRequest manager) throws Exception {
                GXInboundResponse response;
                GXWebTargetAdapterRequest myManager = manager.path("vrefolder");
                HashMap<String, String[]> params = new HashMap<String, String[]>();
                if (excludeNodes != null && excludeNodes.length > 0) {
                    params.put("exclude", excludeNodes);
                }
                if ((response = myManager.queryParams(params).get()).isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    throw new BackendGenericError("HTTP error code is " + response.getHTTPCode());
                }
                return (ItemWrapper)response.getSource().readEntity(ItemWrapper.class);
            }
        };
        try {
            ItemWrapper result = (ItemWrapper)this.delegate.make(call);
            return (T)result.getItem();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<? extends Item> getRecentModifiedFilePerVre() {
        Call<GXWebTargetAdapterRequest, ItemList> call = new Call<GXWebTargetAdapterRequest, ItemList>(){

            public ItemList call(GXWebTargetAdapterRequest manager) throws Exception {
                GXWebTargetAdapterRequest myManager = manager.path("vrefolder").path("recents");
                GXInboundResponse response = myManager.get();
                if (response.isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    throw new BackendGenericError("HTTP error code is " + response.getHTTPCode());
                }
                return (ItemList)response.getSource().readEntity(ItemList.class);
            }
        };
        try {
            ItemList result = (ItemList)this.delegate.make((Call)call);
            return result.getItemlist();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T extends Item> T getTrashFolder(final String ... excludeNodes) {
        Call call = new Call<GXWebTargetAdapterRequest, ItemWrapper<T>>(){

            public ItemWrapper<T> call(GXWebTargetAdapterRequest manager) throws Exception {
                GXInboundResponse response;
                GXWebTargetAdapterRequest myManager = manager.path("trash");
                HashMap<String, String[]> params = new HashMap<String, String[]>();
                if (excludeNodes != null && excludeNodes.length > 0) {
                    params.put("exclude", excludeNodes);
                }
                if ((response = myManager.queryParams(params).get()).isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    throw new BackendGenericError("HTTP error code is " + response.getHTTPCode());
                }
                return (ItemWrapper)response.getSource().readEntity(ItemWrapper.class);
            }
        };
        try {
            ItemWrapper result = (ItemWrapper)this.delegate.make(call);
            return (T)result.getItem();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void emptyTrash() throws StorageHubException, BackendGenericError {
        Call<GXWebTargetAdapterRequest, Void> call = new Call<GXWebTargetAdapterRequest, Void>(){

            public Void call(GXWebTargetAdapterRequest manager) throws Exception {
                GXWebTargetAdapterRequest myManager = manager.path("trash").path("empty");
                GXInboundResponse response = myManager.delete();
                if (response.isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    throw new BackendGenericError("HTTP error code is " + response.getHTTPCode());
                }
                return null;
            }
        };
        try {
            this.delegate.make((Call)call);
        }
        catch (StorageHubException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String restoreFromTrash(final String trashedItemid, final String destinationFolderId) throws StorageHubException, BackendGenericError {
        Call<GXWebTargetAdapterRequest, String> call = new Call<GXWebTargetAdapterRequest, String>(){

            public String call(GXWebTargetAdapterRequest manager) throws Exception {
                GXInboundResponse response;
                Objects.nonNull(trashedItemid);
                GXWebTargetAdapterRequest myManager = manager.path("trash").path("restore");
                MultivaluedHashMap formData = new MultivaluedHashMap();
                formData.add((Object)"trashedItemId", (Object)trashedItemid);
                if (destinationFolderId != null) {
                    formData.add((Object)"destinationId", (Object)destinationFolderId);
                }
                if ((response = myManager.put(Entity.entity((Object)formData, (String)"application/x-www-form-urlencoded"))).isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    throw new BackendGenericError("HTTP error code is " + response.getHTTPCode());
                }
                return (String)response.getSource().readEntity(String.class);
            }
        };
        try {
            return (String)this.delegate.make((Call)call);
        }
        catch (StorageHubException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<? extends Item> search(final Query<SearchableItem<?>> query, final String ... excludeNodes) {
        Call<GXWebTargetAdapterRequest, ItemList> call = new Call<GXWebTargetAdapterRequest, ItemList>(){

            public ItemList call(GXWebTargetAdapterRequest manager) throws Exception {
                GXWebTargetAdapterRequest myManager = manager.path("query");
                HashMap<String, Object[]> params = new HashMap<String, Object[]>();
                if (excludeNodes != null && excludeNodes.length > 0) {
                    params.put("exclude", excludeNodes);
                }
                if (query.getOrderFields() != null && query.getOrderFields().size() > 0) {
                    ArrayList<String> orders = new ArrayList<String>();
                    for (OrderField field : query.getOrderFields()) {
                        orders.add(String.format("[%s]%s", field.getField().getName(), field.getMode().toString()));
                    }
                    params.put("o", orders.toArray(new Object[orders.size()]));
                }
                params.put("n", new Object[]{query.getSearchableItem().getNodeValue()});
                if (query.getLimit() != -1) {
                    params.put("l", new Object[]{query.getLimit()});
                }
                if (query.getOffset() != -1) {
                    params.put("f", new Object[]{query.getOffset()});
                }
                ObjectMapper mapper = new ObjectMapper();
                String serializedJson = mapper.writeValueAsString((Object)query.getExpression());
                params.put("e", new Object[]{URLEncoder.encode(serializedJson)});
                GXInboundResponse response = myManager.queryParams(params).get();
                if (response.isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    throw new BackendGenericError("HTTP error code is " + response.getHTTPCode());
                }
                return (ItemList)response.getSource().readEntity(ItemList.class);
            }
        };
        try {
            ItemList result = (ItemList)this.delegate.make((Call)call);
            return result.getItemlist();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long getTotalItemCount() {
        Call<GXWebTargetAdapterRequest, String> call = new Call<GXWebTargetAdapterRequest, String>(){

            public String call(GXWebTargetAdapterRequest manager) throws Exception {
                GXWebTargetAdapterRequest myManager = manager.path("count");
                GXInboundResponse response = myManager.get();
                if (response.isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    throw new BackendGenericError("HTTP error code is " + response.getHTTPCode());
                }
                return (String)response.getSource().readEntity(String.class);
            }
        };
        try {
            return Long.parseLong((String)this.delegate.make((Call)call));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long getTotalVolume() {
        Call<GXWebTargetAdapterRequest, String> call = new Call<GXWebTargetAdapterRequest, String>(){

            public String call(GXWebTargetAdapterRequest manager) throws Exception {
                GXWebTargetAdapterRequest myManager = manager.path("size");
                GXInboundResponse response = myManager.get();
                if (response.isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    throw new BackendGenericError("HTTP error code is " + response.getHTTPCode());
                }
                return (String)response.getSource().readEntity(String.class);
            }
        };
        try {
            return Long.parseLong((String)this.delegate.make((Call)call));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

