package org.gcube.common.storagehub.client.proxies;

import java.util.List;

import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;

import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.gxrest.request.GXWebTargetAdapterRequest;
import org.gcube.common.gxrest.response.inbound.GXInboundResponse;
import org.gcube.common.storagehub.model.exceptions.BackendGenericError;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;

public class DefaultUserManager implements UserManagerClient {

	private final ProxyDelegate<GXWebTargetAdapterRequest> delegate;
	
	public DefaultUserManager(ProxyDelegate<GXWebTargetAdapterRequest> delegate) {
		this.delegate = delegate;
	}

	@Override
	public void addUser(String userId) throws StorageHubException {
		Call<GXWebTargetAdapterRequest, Void> call = new Call<GXWebTargetAdapterRequest, Void>() {
			@Override
			public Void call(GXWebTargetAdapterRequest manager) throws Exception {
				GXWebTargetAdapterRequest myManager = manager;

				MultivaluedMap<String, Object> formData = new MultivaluedHashMap<String, Object>();
				formData.add("user", userId);
				formData.add("password", userId+"pwd");
				
				GXInboundResponse response = myManager.post(Entity.entity(formData, MediaType.APPLICATION_FORM_URLENCODED));

				if (response.isErrorResponse()) {
					if (response.hasException()) 
						throw response.getException();
					else 
						throw new BackendGenericError();
				}

				return null;
			}
		};
		try {
			delegate.make(call);
			return;
		}catch(Exception e) {
			throw new RuntimeException(e);
		}
	}

	@Override
	public void removeUser(String userId) throws StorageHubException {
		Call<GXWebTargetAdapterRequest, Void> call = new Call<GXWebTargetAdapterRequest, Void>() {
			@Override
			public Void call(GXWebTargetAdapterRequest manager) throws Exception {
				GXWebTargetAdapterRequest myManager = manager;

				GXInboundResponse response = myManager.path(userId).delete();

				if (response.isErrorResponse()) {
					if (response.hasException()) 
						throw response.getException();
					else 
						throw new BackendGenericError();
				}

				return null;
			}
		};
		try {
			delegate.make(call);
			return;
		}catch(Exception e) {
			throw new RuntimeException(e);
		}
	}

	@Override
	public List<String> getUsers() throws StorageHubException {
		Call<GXWebTargetAdapterRequest, List<String>> call = new Call<GXWebTargetAdapterRequest,  List<String>>() {
			@Override
			public  List<String> call(GXWebTargetAdapterRequest manager) throws Exception {
				GXWebTargetAdapterRequest myManager = manager;

				GXInboundResponse response = myManager.get();
				
				if (response.isErrorResponse()) {
					if (response.hasException()) 
						throw response.getException();
					else 
						throw new BackendGenericError();
				}

				return response.getSource().readEntity(List.class);
			}
		};
		try {
			List<String> users = delegate.make(call);
			return users;
		}catch(Exception e) {
			throw new RuntimeException(e);
		}
	}
	
}
