package org.gcube.common.storagehub.client.dsl;

import org.gcube.common.storagehub.client.proxies.GroupManagerClient;
import org.gcube.common.storagehub.client.proxies.WorkspaceManagerClient;
import org.gcube.common.storagehub.model.Excludes;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.items.Item;

public class VREFolderManager {

	private WorkspaceManagerClient wsClient;
	private GroupManagerClient groupClient;
	
	public VREFolderManager(WorkspaceManagerClient wsClient, GroupManagerClient groupClient) {
		super();
		this.wsClient = wsClient;
		this.groupClient = groupClient;
	}

	public void removeUser(String userId) throws StorageHubException{
		groupClient.removeUserFromGroup(userId, getVreFolder().getTitle());
	}
	
	public void addUser(String userId) throws StorageHubException{
		groupClient.addUserToGroup(userId, getVreFolder().getTitle());
	}
	
	public void getUsers() throws StorageHubException{
		getVreFolder();
		groupClient.getUsersOfGroup(getVreFolder().getTitle());
	}
	
	private Item getVreFolder() {
		return wsClient.getVreFolder(Excludes.ALL.toArray(new String[0]));
	}
}
