/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.storagehub.client.dsl;

import org.gcube.common.storagehub.client.dsl.FolderContainer;
import org.gcube.common.storagehub.client.dsl.GenericItemContainer;
import org.gcube.common.storagehub.client.dsl.ListResolver;
import org.gcube.common.storagehub.client.dsl.OpenResolver;
import org.gcube.common.storagehub.client.plugins.AbstractPlugin;
import org.gcube.common.storagehub.client.proxies.ItemManagerClient;
import org.gcube.common.storagehub.client.proxies.WorkspaceManagerClient;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.items.FolderItem;
import org.gcube.common.storagehub.model.items.Item;

public class StorageHubClient {
    private WorkspaceManagerClient wsClient = (WorkspaceManagerClient)AbstractPlugin.workspace().build();
    private ItemManagerClient itemclient = (ItemManagerClient)AbstractPlugin.item().build();

    public FolderContainer getWSRoot() {
        return new FolderContainer(this.itemclient, (FolderItem)this.wsClient.getWorkspace(new String[0]));
    }

    public OpenResolver open(String id) throws StorageHubException {
        Item item = this.itemclient.get(id, new String[0]);
        return new OpenResolver(item, this.itemclient);
    }

    public FolderContainer openVREFolder() {
        return new FolderContainer(this.itemclient, (FolderItem)this.wsClient.getVreFolder(new String[0]));
    }

    public ListResolver getVREFolders() {
        return new ListResolver((onlyType, includeHidden, excludes) -> this.wsClient.getVreFolders(excludes), this.itemclient);
    }

    public FolderContainer openTrash() {
        return new FolderContainer(this.itemclient, (FolderItem)this.wsClient.getTrashFolder(new String[0]));
    }

    public void emptyTrash() {
        this.wsClient.emptyTrash();
    }

    public double getTotalVolume() {
        return this.wsClient.getTotalVolume();
    }

    public long getTotalItemCount() {
        return this.wsClient.getTotalItemCount();
    }

    public GenericItemContainer restoreThrashItem(String itemId) {
        return new GenericItemContainer(this.itemclient, this.wsClient.restoreFromTrash(itemId));
    }
}

