/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.storagehub.client.proxies;

import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Set;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.storagehub.client.StreamDescriptor;
import org.gcube.common.storagehub.client.proxies.ItemManagerClient;
import org.gcube.common.storagehub.model.acls.ACL;
import org.gcube.common.storagehub.model.acls.AccessType;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.common.storagehub.model.service.ItemList;
import org.gcube.common.storagehub.model.service.ItemWrapper;
import org.gcube.common.storagehub.model.types.ACLList;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.MultiPartFeature;

public class DefaultItemManager
implements ItemManagerClient {
    private final ProxyDelegate<WebTarget> delegate;

    public DefaultItemManager(ProxyDelegate<WebTarget> config) {
        this.delegate = config;
    }

    @Override
    public List<? extends Item> getChildren(final String id, final String ... excludeNodes) {
        Call<WebTarget, ItemList> call = new Call<WebTarget, ItemList>(){

            public ItemList call(WebTarget manager) throws Exception {
                WebTarget myManager = manager.path(id).path("children");
                if (excludeNodes != null && excludeNodes.length > 0) {
                    myManager = myManager.queryParam("exclude", (Object[])excludeNodes);
                }
                Invocation.Builder builder = myManager.request(new String[]{"application/json"});
                ItemList response = (ItemList)builder.get(ItemList.class);
                return response;
            }
        };
        try {
            ItemList result = (ItemList)this.delegate.make((Call)call);
            return result.getItemlist();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public StreamDescriptor download(final String id, final String ... excludeNodes) {
        Call<WebTarget, StreamDescriptor> call = new Call<WebTarget, StreamDescriptor>(){

            public StreamDescriptor call(WebTarget manager) throws Exception {
                WebTarget myManager = manager.path(id).path("download");
                if (excludeNodes != null && excludeNodes.length > 0) {
                    myManager = myManager.queryParam("exclude", (Object[])excludeNodes);
                }
                Invocation.Builder builder = myManager.request(new String[]{"application/octet-stream"});
                Response resp = builder.get();
                InputStream stream = (InputStream)resp.readEntity(InputStream.class);
                String disposition = resp.getHeaderString("Content-Disposition");
                String fileName = disposition.replaceFirst("attachment; filename = ([^/s]+)?", "$1");
                return new StreamDescriptor(stream, fileName);
            }
        };
        try {
            StreamDescriptor result = (StreamDescriptor)this.delegate.make((Call)call);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Item get(final String id, final String ... excludeNodes) {
        Call<WebTarget, ItemWrapper<Item>> call = new Call<WebTarget, ItemWrapper<Item>>(){

            public ItemWrapper<Item> call(WebTarget manager) throws Exception {
                WebTarget myManager = manager.path(id);
                if (excludeNodes != null && excludeNodes.length > 0) {
                    myManager = myManager.queryParam("exclude", (Object[])excludeNodes);
                }
                Invocation.Builder builder = myManager.request(new String[]{"application/json"});
                ItemWrapper response = (ItemWrapper)builder.get(ItemWrapper.class);
                return response;
            }
        };
        try {
            ItemWrapper result = (ItemWrapper)this.delegate.make((Call)call);
            return result.getItem();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Item getRootSharedFolder(final String id) {
        Call<WebTarget, ItemWrapper<Item>> call = new Call<WebTarget, ItemWrapper<Item>>(){

            public ItemWrapper<Item> call(WebTarget manager) throws Exception {
                WebTarget myManager = manager.path(id).path("rootSharedFolder");
                Invocation.Builder builder = myManager.request(new String[]{"application/json"});
                ItemWrapper response = (ItemWrapper)builder.get(ItemWrapper.class);
                return response;
            }
        };
        try {
            ItemWrapper result = (ItemWrapper)this.delegate.make((Call)call);
            return result.getItem();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public URL getPublickLink(final String id) {
        Call<WebTarget, URL> call = new Call<WebTarget, URL>(){

            public URL call(WebTarget manager) throws Exception {
                WebTarget myManager = manager.path(id).path("publiclink");
                Invocation.Builder builder = myManager.request(new String[]{"application/json"});
                URL response = (URL)builder.get(URL.class);
                return response;
            }
        };
        try {
            URL result = (URL)this.delegate.make((Call)call);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<? extends Item> getChildren(final String id, final int start, final int limit, final String ... excludeNodes) {
        Call<WebTarget, ItemList> call = new Call<WebTarget, ItemList>(){

            public ItemList call(WebTarget manager) throws Exception {
                WebTarget myManager = manager.path(id).path("children").path("paged");
                if (excludeNodes != null && excludeNodes.length > 0) {
                    myManager = myManager.queryParam("exclude", (Object[])excludeNodes);
                }
                myManager = myManager.queryParam("start", new Object[]{start}).queryParam("limit", new Object[]{limit});
                Invocation.Builder builder = myManager.request(new String[]{"application/json"});
                ItemList response = (ItemList)builder.get(ItemList.class);
                return response;
            }
        };
        try {
            ItemList result = (ItemList)this.delegate.make((Call)call);
            return result.getItemlist();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<? extends Item> findChildrenByNamePattern(final String id, final String name, final String ... excludeNodes) {
        Call<WebTarget, ItemList> call = new Call<WebTarget, ItemList>(){

            public ItemList call(WebTarget manager) throws Exception {
                WebTarget myManager = manager.path(id).path("items").path(name);
                if (excludeNodes != null && excludeNodes.length > 0) {
                    myManager = myManager.queryParam("exclude", (Object[])excludeNodes);
                }
                Invocation.Builder builder = myManager.request(new String[]{"application/json"});
                ItemList response = (ItemList)builder.get(ItemList.class);
                return response;
            }
        };
        try {
            ItemList result = (ItemList)this.delegate.make((Call)call);
            return result.getItemlist();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Integer childrenCount(final String id) {
        Call<WebTarget, Integer> call = new Call<WebTarget, Integer>(){

            public Integer call(WebTarget manager) throws Exception {
                WebTarget myManager = manager.path(id).path("children").path("count");
                Invocation.Builder builder = myManager.request(new String[]{"application/json"});
                Integer response = (Integer)builder.get(Integer.class);
                return response;
            }
        };
        try {
            Integer result = (Integer)this.delegate.make((Call)call);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String uploadFile(final InputStream stream, final String parentId, final String fileName, final String description) {
        Call<WebTarget, String> call = new Call<WebTarget, String>(){

            public String call(WebTarget manager) throws Exception {
                WebTarget myManager = ((WebTarget)manager.register(MultiPartFeature.class)).path(parentId).path("create").path("FILE");
                Invocation.Builder builder = myManager.request();
                FormDataMultiPart multipart = new FormDataMultiPart();
                multipart.field("name", fileName);
                multipart.field("description", description);
                multipart.field("file", (Object)stream, MediaType.APPLICATION_OCTET_STREAM_TYPE);
                String response = (String)builder.post(Entity.entity((Object)multipart, (MediaType)MediaType.MULTIPART_FORM_DATA_TYPE), String.class);
                return response;
            }
        };
        try {
            return (String)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String uploadArchive(final InputStream stream, final String parentId, final String extractionFolderName) {
        Call<WebTarget, String> call = new Call<WebTarget, String>(){

            public String call(WebTarget manager) throws Exception {
                WebTarget myManager = ((WebTarget)manager.register(MultiPartFeature.class)).path(parentId).path("create").path("ARCHIVE");
                Invocation.Builder builder = myManager.request();
                FormDataMultiPart multipart = new FormDataMultiPart();
                multipart.field("parentFolderName", extractionFolderName);
                multipart.field("file", (Object)stream, MediaType.APPLICATION_OCTET_STREAM_TYPE);
                String response = (String)builder.post(Entity.entity((Object)multipart, (MediaType)MediaType.MULTIPART_FORM_DATA_TYPE), String.class);
                return response;
            }
        };
        try {
            return (String)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String createFolder(final String parentId, final String name, final String description) {
        Call<WebTarget, String> call = new Call<WebTarget, String>(){

            public String call(WebTarget manager) throws Exception {
                WebTarget myManager = manager.path(parentId).path("create").path("FOLDER").queryParam("name", new Object[]{name}).queryParam("description", new Object[]{description});
                Invocation.Builder builder = myManager.request();
                MultivaluedHashMap formData = new MultivaluedHashMap();
                formData.add((Object)"name", (Object)name);
                formData.add((Object)"description", (Object)description);
                String response = (String)builder.post(Entity.form((MultivaluedMap)formData), String.class);
                return response;
            }
        };
        try {
            return (String)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String shareFolder(final String id, final Set<String> users, final AccessType accessType) {
        Call<WebTarget, String> call = new Call<WebTarget, String>(){

            public String call(WebTarget manager) throws Exception {
                WebTarget myManager = ((WebTarget)manager.register(MultiPartFeature.class)).path(id).path("share");
                Invocation.Builder builder = myManager.request();
                try (FormDataMultiPart multipart = new FormDataMultiPart();){
                    String response;
                    multipart.field("defaultAccessType", (Object)accessType, MediaType.APPLICATION_JSON_TYPE);
                    multipart.field("users", (Object)users, MediaType.APPLICATION_JSON_TYPE);
                    String string = response = (String)builder.put(Entity.entity((Object)multipart, (MediaType)MediaType.MULTIPART_FORM_DATA_TYPE), String.class);
                    return string;
                }
            }
        };
        try {
            return (String)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String unshareFolder(final String id, final Set<String> users) {
        Call<WebTarget, String> call = new Call<WebTarget, String>(){

            public String call(WebTarget manager) throws Exception {
                WebTarget myManager = ((WebTarget)manager.register(MultiPartFeature.class)).path(id).path("unshare");
                Invocation.Builder builder = myManager.request();
                try (FormDataMultiPart multipart = new FormDataMultiPart();){
                    String response;
                    multipart.field("users", (Object)users, MediaType.APPLICATION_JSON_TYPE);
                    String string = response = (String)builder.put(Entity.entity((Object)multipart, (MediaType)MediaType.MULTIPART_FORM_DATA_TYPE), String.class);
                    return string;
                }
            }
        };
        try {
            return (String)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void delete(final String id) {
        Call<WebTarget, Void> call = new Call<WebTarget, Void>(){

            public Void call(WebTarget manager) throws Exception {
                WebTarget myManager = manager.path(id);
                Invocation.Builder builder = myManager.request();
                builder.delete();
                return null;
            }
        };
        try {
            this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<? extends Item> getAnchestors(final String id, final String ... excludeNodes) {
        Call<WebTarget, ItemList> call = new Call<WebTarget, ItemList>(){

            public ItemList call(WebTarget manager) throws Exception {
                WebTarget myManager = manager.path(id).path("anchestors");
                if (excludeNodes != null && excludeNodes.length > 0) {
                    myManager = myManager.queryParam("exclude", (Object[])excludeNodes);
                }
                Invocation.Builder builder = myManager.request(new String[]{"application/json"});
                ItemList response = (ItemList)builder.get(ItemList.class);
                return response;
            }
        };
        try {
            ItemList result = (ItemList)this.delegate.make((Call)call);
            return result.getItemlist();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<ACL> getACL(final String id) {
        Call<WebTarget, ACLList> call = new Call<WebTarget, ACLList>(){

            public ACLList call(WebTarget manager) throws Exception {
                WebTarget myManager = manager.path(id).path("acls");
                Invocation.Builder builder = myManager.request(new String[]{"application/json"});
                ACLList response = (ACLList)builder.get(ACLList.class);
                return response;
            }
        };
        try {
            return ((ACLList)this.delegate.make((Call)call)).getAcls();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

