/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.software.processor.zenodo;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.client.ClientResponseContext;
import jakarta.ws.rs.client.ClientResponseFilter;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.gcube.common.software.config.Config;
import org.gcube.common.software.model.ElaborationType;
import org.gcube.common.software.model.SoftwareArtifactFile;
import org.gcube.common.software.model.SoftwareArtifactMetadata;
import org.gcube.common.software.processor.SoftwareArtifactProcessor;
import org.gcube.common.software.utils.Utils;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.media.multipart.file.FileDataBodyPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZenodoExporter
extends SoftwareArtifactProcessor {
    private static final Logger logger = LoggerFactory.getLogger(ZenodoExporter.class);
    public static final String EXPORT_FILENAME_EXTENSION = ".json";
    public static final String GUCBE_ZENODO_SOFTWARE_DEPOSIT = "gCubeSoftwareDeposit";
    public static final String HTML_DESCRIPTION_CONFIG_FIELD_NAME = "html_description";
    public static final String ADDITIONAL_HTML_DESCRIPTION_CONFIG_FIELD_NAME = "additional_html_description";
    public static final String SKIP_GRANTS_CONFIG_FIELD_NAME = "skip_grants";
    public static final String METADATA_FIELD_NAME = "metadata";
    public static final String COMMUNITIES_FIELD_NAME = "communities";
    public static final String DEPOSITIONS_COLLECTION_PATH = "/api/deposit/depositions";
    public static final String DEPOSITION_PATH = "/api/deposit/depositions/:id";
    public static final String RECORD_PATH = "/api/records/:id";
    public static final String DEPOSTION_FILES_PATH = "/api/deposit/depositions/:id/files";
    public static final String DEPOSTION_NEW_VERSION_PATH = "/api/deposit/depositions/:id/actions/newversion";
    public static final String DEPOSTION_EDIT_PATH = "/api/deposit/depositions/:id/actions/edit";
    public static final String DEPOSTION_PUBLISH_PATH = "/api/deposit/depositions/:id/actions/publish";
    protected URL zenodoBaseURL;
    protected String accessToken;
    protected String zenodoID;
    protected JsonNode response;
    protected String doiBaseURL;

    protected String getZenodoIDFromDOIURL(URL doiURL) {
        return this.getZenodoIDFromDOIURL(doiURL.toString());
    }

    protected String getZenodoIDFromDOIURL(String doiURL) {
        return doiURL.replace(this.doiBaseURL, "");
    }

    public ZenodoExporter() {
        super(EXPORT_FILENAME_EXTENSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonNode getResponse(Response response) throws Exception {
        Object content = null;
        try {
            Response.StatusType statusType = response.getStatusInfo();
            int responseCode = statusType.getStatusCode();
            String responseMessage = statusType.getReasonPhrase();
            StringBuffer responseBuffer = new StringBuffer();
            responseBuffer.append("Response: ").append(responseCode).append(" ").append(responseMessage);
            try {
                content = (String)response.readEntity(String.class);
                if (content != null && !((String)content).trim().isEmpty()) {
                    responseBuffer.append(" - Content: ");
                    responseBuffer.append((String)content);
                }
            }
            catch (Exception e) {
                logger.trace("Could not read response content: {}", (Object)e.getMessage());
                content = "Could not read response content: " + e.getMessage();
                responseBuffer.append(" - ").append((String)content);
            }
            if (responseCode >= 400) {
                logger.error(responseBuffer.toString());
                throw new RuntimeException(responseBuffer.toString());
            }
            if (content != null && !((String)content).trim().isEmpty()) {
                JsonNode jsonNode = Utils.getObjectMapper().readTree((String)content);
                return jsonNode;
            }
            JsonNode jsonNode = null;
            return jsonNode;
        }
        finally {
            response.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addFilesToDeposition(List<File> files) throws Exception {
        logger.debug("Going to add files {} to deposition for {}", files, (Object)this.softwareArtifactMetadata.getTitle());
        String depositID = this.getZenodoIDFromDOIURL(this.softwareArtifactMetadata.getVersionDOIURL());
        String newFilePath = DEPOSTION_FILES_PATH.replace(":id", depositID);
        for (File file : files) {
            try (Client client = this.getJerseyClientWithAutoHeaders(this.zenodoBaseURL.toString());){
                client.register(MultiPartFeature.class);
                FormDataMultiPart multi = new FormDataMultiPart();
                FileDataBodyPart fileDataBodyPart = new FileDataBodyPart("file", file, MediaType.APPLICATION_OCTET_STREAM_TYPE);
                multi.field("name", file.getName());
                multi.bodyPart((BodyPart)fileDataBodyPart);
                Response response = client.target(this.zenodoBaseURL.toString()).path(newFilePath).request(new String[]{"application/json"}).post(Entity.entity((Object)multi, (MediaType)multi.getMediaType()));
                this.getResponse(response);
            }
        }
    }

    protected Client getJerseyClientWithAutoHeaders(String baseUrl) {
        Client client = ClientBuilder.newClient();
        client.register(JacksonFeature.class);
        client.property("jersey.config.client.connectTimeout", (Object)30000);
        client.property("jersey.config.client.readTimeout", (Object)60000);
        client.property("jersey.config.client.suppressHttpComplianceValidation", (Object)true);
        client.register((Object)new AutoHeaderFilter(GUCBE_ZENODO_SOFTWARE_DEPOSIT, "Bearer " + this.accessToken));
        client.register((Object)new RateLimitResponseFilter());
        client.property("access_token", (Object)this.accessToken);
        return client;
    }

    protected ClientAndBuilder getZenodoRequestBuilderWithClient(String path) {
        Client client = this.getJerseyClientWithAutoHeaders(this.zenodoBaseURL.toString());
        WebTarget webTarget = client.target(this.zenodoBaseURL.toString()).path(path);
        Invocation.Builder builder = webTarget.request(new String[]{"application/json"}).header("Accept", (Object)"application/json");
        return new ClientAndBuilder(client, builder);
    }

    protected void updateMetadata() throws Exception {
        logger.debug("Going to update metadata of {}", (Object)this.softwareArtifactMetadata.getTitle());
        ObjectNode metadata = this.generateMetadata();
        String id = this.getZenodoIDFromDOIURL(this.softwareArtifactMetadata.getVersionDOIURL());
        String path = DEPOSITION_PATH.replace(":id", id);
        try (ClientAndBuilder clientAndBuilder = this.getZenodoRequestBuilderWithClient(path);){
            clientAndBuilder.builder.header("Content-Type", (Object)"application/json");
            Response response = clientAndBuilder.builder.put(Entity.json((Object)metadata));
            this.getResponse(response);
        }
    }

    protected void commitVersion() throws Exception {
        logger.debug("Going to confirm the version of {}", (Object)this.softwareArtifactMetadata.getTitle());
        String id = this.getZenodoIDFromDOIURL(this.softwareArtifactMetadata.getVersionDOIURL());
        String path = DEPOSTION_PUBLISH_PATH.replace(":id", id);
        try (ClientAndBuilder clientAndBuilder = this.getZenodoRequestBuilderWithClient(path);){
            clientAndBuilder.builder.header("Content-Type", (Object)"application/json");
            Response response = clientAndBuilder.builder.post(Entity.text((Object)""));
            this.getResponse(response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalizeProcessing() throws Exception {
        ArrayList<File> files = new ArrayList<File>();
        for (SoftwareArtifactFile svf : this.softwareArtifactMetadata.getFiles()) {
            File file = svf.downloadFile();
            files.add(file);
            Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
        }
        try {
            this.addFilesToDeposition(files);
            this.updateMetadata();
            this.commitVersion();
        }
        catch (Throwable throwable) {
            for (File file : files) {
                logger.trace("Going to delete file {}", (Object)file.getAbsolutePath());
                if (!file.exists()) {
                    throw new RuntimeException(file.getAbsolutePath() + " does not exist");
                }
                try {
                    int i;
                    for (i = 0; !file.delete() && i < 10; ++i) {
                        int millis = 100;
                        logger.warn("File {} not deleted at the attemp {}. Retrying in {} milliseconds.", new Object[]{file.getAbsolutePath(), i + 1, millis});
                        Thread.sleep(millis);
                    }
                    if (i != 10) continue;
                    logger.warn("After {} attemps the file {} was not deleted. Trying using deleteOnExit().", (Object)i, (Object)file.getAbsolutePath());
                    file.deleteOnExit();
                }
                catch (Exception e) {
                    logger.error("Unable to delete file {}", (Object)file.getAbsolutePath());
                }
            }
            throw throwable;
        }
        for (File file : files) {
            logger.trace("Going to delete file {}", (Object)file.getAbsolutePath());
            if (!file.exists()) {
                throw new RuntimeException(file.getAbsolutePath() + " does not exist");
            }
            try {
                int i;
                for (i = 0; !file.delete() && i < 10; ++i) {
                    int millis = 100;
                    logger.warn("File {} not deleted at the attemp {}. Retrying in {} milliseconds.", new Object[]{file.getAbsolutePath(), i + 1, millis});
                    Thread.sleep(millis);
                }
                if (i != 10) continue;
                logger.warn("After {} attemps the file {} was not deleted. Trying using deleteOnExit().", (Object)i, (Object)file.getAbsolutePath());
                file.deleteOnExit();
            }
            catch (Exception e) {
                logger.error("Unable to delete file {}", (Object)file.getAbsolutePath());
            }
        }
    }

    protected String createZenodoDOIURLFromID(String id) throws MalformedURLException {
        return this.doiBaseURL + id;
    }

    public void create() throws Exception {
        logger.info("Going to create new deposition for {}", (Object)this.softwareArtifactMetadata.getTitle());
        ObjectNode metadata = this.generateMetadata();
        try (ClientAndBuilder clientAndBuilder = this.getZenodoRequestBuilderWithClient(DEPOSITIONS_COLLECTION_PATH);){
            clientAndBuilder.builder.header("Content-Type", (Object)"application/json");
            Response response = clientAndBuilder.builder.post(Entity.json((Object)metadata));
            JsonNode responseJson = this.getResponse(response);
            String conceptDOIURL = this.createZenodoDOIURLFromID(responseJson.get("conceptrecid").asText());
            this.softwareArtifactMetadata.setConceptDOIURL(conceptDOIURL);
            String versionDOIURL = this.createZenodoDOIURLFromID(responseJson.get("id").asText());
            this.softwareArtifactMetadata.setVersionDOIURL(versionDOIURL);
        }
        this.finalizeProcessing();
    }

    private ArrayNode getAuthors() {
        ArrayNode authors = this.softwareArtifactMetadata.getAuthors().deepCopy();
        return authors;
    }

    private String getDescription() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.softwareArtifactMetadata.getAdditionalProperty(HTML_DESCRIPTION_CONFIG_FIELD_NAME).asText());
        if (this.processorConfig.getProperty(ADDITIONAL_HTML_DESCRIPTION_CONFIG_FIELD_NAME) != null) {
            String additionalHTMLDescription = this.processorConfig.getProperty(ADDITIONAL_HTML_DESCRIPTION_CONFIG_FIELD_NAME).asText();
            stringBuffer.append(additionalHTMLDescription);
        }
        return stringBuffer.toString();
    }

    private ArrayNode getGrants() {
        ObjectMapper objectMapper = Utils.getObjectMapper();
        ArrayNode grants = objectMapper.createArrayNode();
        ArrayNode arrayNode = (ArrayNode)this.processorConfig.getProperty(SKIP_GRANTS_CONFIG_FIELD_NAME);
        HashSet<String> idToSkip = new HashSet<String>();
        for (JsonNode idNode : arrayNode) {
            idToSkip.add(idNode.asText());
        }
        for (JsonNode g : this.softwareArtifactMetadata.getGrants()) {
            String id = g.get("id").asText();
            if (idToSkip.contains(id)) continue;
            ObjectNode grant = objectMapper.createObjectNode();
            grant.put("id", id);
            grants.add((JsonNode)grant);
        }
        return grants;
    }

    private ArrayNode getKeywords() {
        Set<String> keywords = this.softwareArtifactMetadata.getKeywords();
        ObjectMapper objectMapper = Utils.getObjectMapper();
        ArrayNode keywordsArrayNode = objectMapper.createArrayNode();
        for (String keyword : keywords) {
            keywordsArrayNode.add(keyword);
        }
        return keywordsArrayNode;
    }

    private ArrayNode getCommunities() {
        return (ArrayNode)this.softwareArtifactMetadata.getAdditionalProperty(COMMUNITIES_FIELD_NAME);
    }

    private String getLicense() {
        return this.softwareArtifactMetadata.getLicense().get("id").asText();
    }

    private String getDate() {
        return Utils.getDateAsString(this.softwareArtifactMetadata.getDate());
    }

    private ObjectNode generateMetadata() {
        ObjectMapper objectMapper = Utils.getObjectMapper();
        ObjectNode metadatWrapper = objectMapper.createObjectNode();
        ObjectNode metadata = objectMapper.createObjectNode();
        metadata.put("access_right", "open");
        metadata.put("upload_type", "software");
        metadata.replace("creators", (JsonNode)this.getAuthors());
        metadata.put("description", this.getDescription());
        metadata.replace(COMMUNITIES_FIELD_NAME, (JsonNode)this.getCommunities());
        metadata.replace("grants", (JsonNode)this.getGrants());
        metadata.replace("keywords", (JsonNode)this.getKeywords());
        metadata.put("license", this.getLicense());
        metadata.put("publication_date", this.getDate());
        metadata.put("title", this.softwareArtifactMetadata.getTitle());
        metadata.put("version", this.softwareArtifactMetadata.getVersion());
        metadatWrapper.set(METADATA_FIELD_NAME, (JsonNode)metadata);
        return metadatWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() throws Exception {
        logger.debug("Going to unlock already submitted deposition {} to update it", (Object)this.softwareArtifactMetadata.getTitle());
        String id = this.getZenodoIDFromDOIURL(this.softwareArtifactMetadata.getVersionDOIURL());
        String editPath = DEPOSTION_EDIT_PATH.replace(":id", id);
        try (ClientAndBuilder clientAndBuilder = this.getZenodoRequestBuilderWithClient(editPath);){
            clientAndBuilder.builder.header("Accept", (Object)"application/json");
            Response response = clientAndBuilder.builder.post(Entity.json((Object)""));
            this.getResponse(response);
        }
        this.updateMetadata();
        this.commitVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deletePreviousFiles(JsonNode jsonNode) throws Exception {
        logger.debug("Going to delete previous deposition files to properly publish {}", (Object)this.softwareArtifactMetadata.getTitle());
        ArrayNode files = (ArrayNode)jsonNode.get("files");
        for (int i = 0; i < files.size(); ++i) {
            ObjectNode file = (ObjectNode)files.get(i);
            String fileURLString = file.get("links").get("self").asText();
            String filePath = fileURLString.replace(this.zenodoBaseURL.toString(), "");
            try (ClientAndBuilder clientAndBuilder = this.getZenodoRequestBuilderWithClient(filePath);){
                clientAndBuilder.builder.header("Accept", (Object)"application/json");
                Response response = clientAndBuilder.builder.delete();
                this.getResponse(response);
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newVersion() throws Exception {
        String previousVersionVersion;
        JsonNode jsonNode;
        String conceptDOIURL = this.softwareArtifactMetadata.getConceptDOIURL();
        String conceptID = this.getZenodoIDFromDOIURL(conceptDOIURL);
        String recordPath = RECORD_PATH.replace(":id", conceptID);
        logger.debug("Going to read record using conceptID {} to get the latest published version (should be {}) to be able to publish {}", new Object[]{conceptID, this.softwareArtifactMetadata.getPrevious().getTitle(), this.softwareArtifactMetadata.getTitle()});
        try (ClientAndBuilder clientAndBuilder = this.getZenodoRequestBuilderWithClient(recordPath);){
            clientAndBuilder.builder.header("Content-Type", (Object)"application/json");
            clientAndBuilder.builder.header("Accept", (Object)"application/json");
            Response response = clientAndBuilder.builder.get();
            jsonNode = this.getResponse(response);
        }
        String latestVersionDOI = jsonNode.get("links").get("doi").asText();
        String previousVersionDOI = this.softwareArtifactMetadata.getPrevious().getVersionDOIURL().toString();
        if (previousVersionDOI.compareTo(latestVersionDOI) != 0) {
            logger.error("Zenodo obtained latest DOI {} != {} DOI from previous version", (Object)latestVersionDOI, (Object)previousVersionDOI);
            throw new RuntimeException("It seems that your json is not up to date with Zenodo.");
        }
        String latestVersionVersion = jsonNode.get(METADATA_FIELD_NAME).get("version").asText();
        if (latestVersionVersion.compareTo(previousVersionVersion = this.softwareArtifactMetadata.getPrevious().getVersion().toString()) != 0) {
            logger.error("Zenodo obtained latest Version {} != {} Version from previous version", (Object)latestVersionVersion, (Object)previousVersionVersion);
            throw new RuntimeException("It seems that your json is not up to date with Zenodo.");
        }
        logger.debug("Going to create the new version {} starting from latest deposited version {}", (Object)this.softwareArtifactMetadata.getTitle(), (Object)this.softwareArtifactMetadata.getPrevious().getTitle());
        String latestID = this.getZenodoIDFromDOIURL(latestVersionDOI);
        String newVersionPath = DEPOSTION_NEW_VERSION_PATH.replace(":id", latestID);
        clientAndBuilder = this.getZenodoRequestBuilderWithClient(newVersionPath);
        try {
            clientAndBuilder.builder.header("Content-Type", (Object)"application/json");
            clientAndBuilder.builder.header("Accept", (Object)"application/json");
            Response response = clientAndBuilder.builder.post(Entity.json((Object)""));
            jsonNode = null;
            jsonNode = this.getResponse(response);
        }
        finally {
            clientAndBuilder.close();
        }
        String newVersionId = jsonNode.get("id").toString();
        this.softwareArtifactMetadata.setVersionDOIURL(this.doiBaseURL + newVersionId);
        if (jsonNode != null) {
            this.deletePreviousFiles(jsonNode);
        }
        this.finalizeProcessing();
    }

    protected String getConfig(String propertyName) throws Exception {
        String conf = null;
        JsonNode node = this.processorConfig.getProperty(propertyName);
        if (node == null || node.getNodeType() == JsonNodeType.NULL) {
            conf = Config.getProperties().getProperty(propertyName);
        }
        if (conf == null) {
            throw new Exception("No configuration for '" + propertyName + "' property found.");
        }
        return conf;
    }

    protected void getZenodoConnectionConfig() throws Exception {
        this.zenodoBaseURL = new URL(this.getConfig("zenodo_base_url"));
        this.accessToken = this.getConfig("zenodo_access_token");
        this.doiBaseURL = this.getConfig("doi_base_url");
    }

    @Override
    public void export() throws Exception {
        if (this.first) {
            File exportFile = super.getOutputFile();
            if (exportFile.exists()) {
                exportFile.delete();
            }
            exportFile.createNewFile();
        }
        this.getZenodoConnectionConfig();
        String title = this.softwareArtifactMetadata.getTitle();
        ElaborationType elaborationType = this.processorConfig.getElaborationType();
        if (elaborationType == ElaborationType.NONE) {
            logger.info("Zenodo Deposit is disabled for {}.", (Object)title);
            return;
        }
        if (this.softwareArtifactMetadata.getVersionDOIURL() != null) {
            this.softwareArtifactMetadata.setNewDeposition(false);
            if (elaborationType == ElaborationType.ALL || elaborationType == ElaborationType.UPDATE_ONLY) {
                logger.info("Going to update {}.", (Object)title);
                this.update();
            } else {
                logger.info("{} has been already deposited.", (Object)title);
            }
        } else if (elaborationType == ElaborationType.ALL || elaborationType == ElaborationType.NEW) {
            this.softwareArtifactMetadata.setNewDeposition(true);
            if (this.softwareArtifactMetadata.getConceptDOIURL() == null) {
                logger.info("Going to create {}", (Object)title);
                this.create();
            } else {
                logger.info("Going to create new version for {}", (Object)title);
                this.newVersion();
            }
        }
    }

    protected ObjectNode getObjectNode() throws Exception {
        ObjectMapper objectMapper = Utils.getObjectMapper();
        ObjectNode toBeExported = objectMapper.createObjectNode();
        toBeExported.replace("configuration", (JsonNode)this.globalConfig.getOriginalJson().deepCopy());
        ArrayNode array = objectMapper.createArrayNode();
        boolean firstNode = true;
        for (SoftwareArtifactMetadata previous = this.softwareArtifactMetadata; previous != null; previous = previous.getPrevious()) {
            ObjectNode node = previous.getOriginalJson().deepCopy();
            node.put("concept_doi_url", previous.getConceptDOIURL());
            if (firstNode) {
                toBeExported.put("concept_doi_url", previous.getConceptDOIURL());
                firstNode = false;
            }
            node.put("version_doi_url", previous.getVersionDOIURL());
            array.insert(0, (JsonNode)node);
        }
        toBeExported.replace("artifacts", (JsonNode)array);
        return toBeExported;
    }

    protected void writeObjectNodeToFile(ObjectNode toBeExported, File file) throws Exception {
        ObjectMapper objectMapper = Utils.getObjectMapper();
        objectMapper.writeValue(file, (Object)toBeExported);
    }

    @Override
    public File getOutputFile() throws Exception {
        File exportFile = super.getOutputFile();
        if (this.last) {
            ObjectNode toBeExported = this.getObjectNode();
            this.writeObjectNodeToFile(toBeExported, exportFile);
        }
        return exportFile;
    }

    public static class AutoHeaderFilter
    implements ClientRequestFilter {
        private final String userAgent;
        private final String authorization;

        public AutoHeaderFilter(String userAgent, String authorization) {
            this.userAgent = userAgent;
            this.authorization = authorization;
        }

        public void filter(ClientRequestContext requestContext) {
            requestContext.getHeaders().add((Object)"User-Agent", (Object)this.userAgent);
            requestContext.getHeaders().add((Object)"Authorization", (Object)this.authorization);
        }
    }

    public static class RateLimitResponseFilter
    implements ClientResponseFilter {
        private static final Logger logger = LoggerFactory.getLogger(RateLimitResponseFilter.class);
        private static final long DEFAULT_DELAY_MS = 1000L;
        private static final long LOW_REMAINING_DELAY_MS = 2000L;
        private static final long VERY_LOW_REMAINING_DELAY_MS = 5000L;

        public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) {
            long delayMs;
            String rateLimitLimit = responseContext.getHeaderString("X-RateLimit-Limit");
            String rateLimitRemaining = responseContext.getHeaderString("X-RateLimit-Remaining");
            String rateLimitReset = responseContext.getHeaderString("X-RateLimit-Reset");
            if (rateLimitLimit != null || rateLimitRemaining != null || rateLimitReset != null) {
                logger.debug("Zenodo Rate Limit Info - Limit: {}, Remaining: {}, Reset: {}", new Object[]{rateLimitLimit != null ? rateLimitLimit : "N/A", rateLimitRemaining != null ? rateLimitRemaining : "N/A", rateLimitReset != null ? rateLimitReset : "N/A"});
            }
            if ((delayMs = this.calculateDelay(rateLimitLimit, rateLimitRemaining, rateLimitReset)) > 0L) {
                try {
                    logger.trace("Applying intelligent rate limit delay of {} ms", (Object)delayMs);
                    Thread.sleep(delayMs);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    logger.warn("Rate limit delay interrupted", (Throwable)e);
                }
            }
        }

        private long calculateDelay(String limitHeader, String remainingHeader, String resetHeader) {
            if (remainingHeader == null) {
                return 1000L;
            }
            try {
                int remaining = Integer.parseInt(remainingHeader);
                Integer limit = null;
                Long resetTime = null;
                if (limitHeader != null) {
                    try {
                        limit = Integer.parseInt(limitHeader);
                    }
                    catch (NumberFormatException e) {
                        logger.trace("Could not parse rate limit value: {}", (Object)limitHeader);
                    }
                }
                if (resetHeader != null) {
                    try {
                        resetTime = Long.parseLong(resetHeader);
                    }
                    catch (NumberFormatException e) {
                        logger.trace("Could not parse reset time value: {}", (Object)resetHeader);
                    }
                }
                if (remaining <= 2) {
                    logger.warn("Zenodo Rate Limit Critical: Only {} requests remaining - applying extended delay", (Object)remaining);
                    return 5000L;
                }
                if (remaining <= 10) {
                    logger.warn("Zenodo Rate Limit Warning: Only {} requests remaining - applying increased delay", (Object)remaining);
                    return 2000L;
                }
                if (limit != null && (double)remaining <= (double)limit.intValue() * 0.2) {
                    logger.debug("Zenodo Rate Limit: Less than 20% requests remaining ({}/{})", (Object)remaining, (Object)limit);
                    return 2000L;
                }
                if (resetTime != null && limit != null) {
                    long currentTime = System.currentTimeMillis() / 1000L;
                    long timeUntilReset = resetTime - currentTime;
                    if (timeUntilReset > 0L && remaining > 0) {
                        long optimalDelay = timeUntilReset * 1000L / (long)remaining;
                        optimalDelay = Math.max(500L, Math.min(optimalDelay, 10000L));
                        logger.trace("Calculated optimal delay: {} ms (remaining: {}, time until reset: {} s)", new Object[]{optimalDelay, remaining, timeUntilReset});
                        return optimalDelay;
                    }
                }
                return 1000L;
            }
            catch (NumberFormatException e) {
                logger.trace("Could not parse remaining rate limit value: {}", (Object)remainingHeader);
                return 1000L;
            }
        }
    }

    protected static class ClientAndBuilder
    implements AutoCloseable {
        public final Client client;
        public final Invocation.Builder builder;

        public ClientAndBuilder(Client client, Invocation.Builder builder) {
            this.client = client;
            this.builder = builder;
        }

        @Override
        public void close() {
            if (this.client != null) {
                this.client.close();
            }
        }
    }
}

