/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.software.export.zenodo;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.com.fasterxml.jackson.databind.node.ArrayNode;
import org.gcube.com.fasterxml.jackson.databind.node.JsonNodeType;
import org.gcube.com.fasterxml.jackson.databind.node.ObjectNode;
import org.gcube.common.gxhttp.request.GXHTTPStringRequest;
import org.gcube.common.software.config.Config;
import org.gcube.common.software.export.SoftwareArtifactProcessor;
import org.gcube.common.software.model.ElaborationType;
import org.gcube.common.software.model.SoftwareArtifactConfig;
import org.gcube.common.software.model.SoftwareArtifactFile;
import org.gcube.common.software.utils.Utils;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.media.multipart.file.FileDataBodyPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZenodoExporter
extends SoftwareArtifactProcessor {
    private static final Logger logger = LoggerFactory.getLogger(ZenodoExporter.class);
    public static final String EXPORT_FILENAME_EXTENSION = ".json";
    public static final String GUCBE_ZENODO_SOFTWARE_DEPOSIT = "gCubeSoftwareDeposit";
    public static final String HTML_DESCRIPTION_CONFIG_FIELD_NAME = "html_description";
    public static final String ADDITIONAL_HTML_DESCRIPTION_CONFIG_FIELD_NAME = "additional_html_description";
    public static final String SKIP_GRANTS_CONFIG_FIELD_NAME = "skip_grants";
    public static final String METADATA_FIELD_NAME = "metadata";
    public static final String COMMUNITIES_FIELD_NAME = "communities";
    public static final String DEPOSITIONS_COLLECTION_PATH = "/api/deposit/depositions";
    public static final String DEPOSITION_PATH = "/api/deposit/depositions/:id";
    public static final String RECORD_PATH = "/api/records/:id";
    public static final String DEPOSTION_FILES_PATH = "/api/deposit/depositions/:id/files";
    public static final String DEPOSTION_NEW_VERSION_PATH = "/api/deposit/depositions/:id/actions/newversion";
    public static final String DEPOSTION_EDIT_PATH = "/api/deposit/depositions/:id/actions/edit";
    public static final String DEPOSTION_PUBLISH_PATH = "/api/deposit/depositions/:id/actions/publish";
    protected URL zenodoBaseURL;
    protected String accessToken;
    protected String zenodoID;
    protected JsonNode response;
    protected String doiBaseURL;

    protected String getZenodoIDFromDOIURL(URL doiURL) {
        return this.getZenodoIDFromDOIURL(doiURL.toString());
    }

    protected String getZenodoIDFromDOIURL(String doiURL) {
        return doiURL.replace(this.doiBaseURL, "");
    }

    protected Map<String, String> getAccessTokenQueryParamters() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("access_token", this.accessToken);
        return map;
    }

    public ZenodoExporter() {
        super(EXPORT_FILENAME_EXTENSION);
    }

    protected void addFilesToDeposition(List<File> files) throws Exception {
        String depositID = this.getZenodoIDFromDOIURL(this.softwareVersionConfig.getVersionDOIURL());
        String newFilePath = DEPOSTION_FILES_PATH.replace(":id", depositID);
        URL url = new URL(this.zenodoBaseURL, newFilePath);
        for (File file : files) {
            Client client = (Client)ClientBuilder.newClient().property("jersey.config.client.suppressHttpComplianceValidation", (Object)true);
            client.register(MultiPartFeature.class);
            FormDataMultiPart multi = new FormDataMultiPart();
            FileDataBodyPart fileDataBodyPart = new FileDataBodyPart("file", file, MediaType.APPLICATION_OCTET_STREAM_TYPE);
            multi.field("name", file.getName());
            multi.bodyPart((BodyPart)fileDataBodyPart);
            Response response = client.target(url.toURI().toString()).queryParam("access_token", new Object[]{this.accessToken}).request(new String[]{"application/json"}).post(Entity.entity((Object)multi, (MediaType)multi.getMediaType()));
            int statusCode = response.getStatus();
            if (statusCode <= 400) continue;
            throw new RuntimeException("Error while uploading file " + file.getAbsolutePath());
        }
    }

    protected void updateMetadata() throws Exception {
        GXHTTPStringRequest gxHTTPStringRequest = GXHTTPStringRequest.newRequest((String)this.zenodoBaseURL.toString());
        gxHTTPStringRequest.isExternalCall(true);
        gxHTTPStringRequest.from(GUCBE_ZENODO_SOFTWARE_DEPOSIT);
        gxHTTPStringRequest.queryParams(this.getAccessTokenQueryParamters());
        gxHTTPStringRequest.header("Content-Type", "application/json");
        gxHTTPStringRequest.header("Accept", "application/json");
        String id = this.getZenodoIDFromDOIURL(this.softwareVersionConfig.getVersionDOIURL());
        gxHTTPStringRequest.path(DEPOSITION_PATH.replace(":id", id));
        ObjectNode metadata = this.generateMetadata();
        HttpURLConnection httpURLConnection = gxHTTPStringRequest.put(Utils.getObjectMapper().writeValueAsString((Object)metadata));
        this.getResponse(httpURLConnection);
    }

    protected void publishToZenodo() throws Exception {
        GXHTTPStringRequest gxHTTPStringRequest = GXHTTPStringRequest.newRequest((String)this.zenodoBaseURL.toString());
        gxHTTPStringRequest.isExternalCall(true);
        gxHTTPStringRequest.from(GUCBE_ZENODO_SOFTWARE_DEPOSIT);
        gxHTTPStringRequest.queryParams(this.getAccessTokenQueryParamters());
        gxHTTPStringRequest.header("Content-Type", "application/json");
        gxHTTPStringRequest.header("Accept", "application/json");
        String id = this.getZenodoIDFromDOIURL(this.softwareVersionConfig.getVersionDOIURL());
        gxHTTPStringRequest.path(DEPOSTION_PUBLISH_PATH.replace(":id", id));
        HttpURLConnection httpURLConnection = gxHTTPStringRequest.post();
        this.getResponse(httpURLConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Exception {
        ArrayList<File> files = new ArrayList<File>();
        for (SoftwareArtifactFile svf : this.softwareVersionConfig.getFiles()) {
            File file = svf.downloadFile();
            files.add(file);
            Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
        }
        try {
            this.addFilesToDeposition(files);
            this.updateMetadata();
            this.publishToZenodo();
        }
        catch (Throwable throwable) {
            for (File file : files) {
                logger.trace("Going to delete file {}", (Object)file.getAbsolutePath());
                if (!file.exists()) {
                    throw new RuntimeException(file.getAbsolutePath() + " does not exist");
                }
                try {
                    int i;
                    for (i = 0; !file.delete() && i < 10; ++i) {
                        int millis = 100;
                        logger.warn("File {} not deleted at the attemp {}. Retrying in {} milliseconds.", new Object[]{file.getAbsolutePath(), i + 1, millis});
                        Thread.sleep(millis);
                    }
                    if (i != 10) continue;
                    logger.warn("After {} attemps the file {} was not deleted. Trying using deleteOnExit().", (Object)i, (Object)file.getAbsolutePath());
                    file.deleteOnExit();
                }
                catch (Exception e) {
                    logger.error("Unable to delete file {}", (Object)file.getAbsolutePath());
                }
            }
            throw throwable;
        }
        for (File file : files) {
            logger.trace("Going to delete file {}", (Object)file.getAbsolutePath());
            if (!file.exists()) {
                throw new RuntimeException(file.getAbsolutePath() + " does not exist");
            }
            try {
                int i;
                for (i = 0; !file.delete() && i < 10; ++i) {
                    int millis = 100;
                    logger.warn("File {} not deleted at the attemp {}. Retrying in {} milliseconds.", new Object[]{file.getAbsolutePath(), i + 1, millis});
                    Thread.sleep(millis);
                }
                if (i != 10) continue;
                logger.warn("After {} attemps the file {} was not deleted. Trying using deleteOnExit().", (Object)i, (Object)file.getAbsolutePath());
                file.deleteOnExit();
            }
            catch (Exception e) {
                logger.error("Unable to delete file {}", (Object)file.getAbsolutePath());
            }
        }
    }

    protected StringBuilder getStringBuilder(InputStream inputStream) throws IOException {
        StringBuilder result = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            String line;
            while ((line = reader.readLine()) != null) {
                result.append(line);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonNode getResponse(HttpURLConnection connection) throws Exception {
        try {
            int responseCode = connection.getResponseCode();
            String responseMessage = connection.getResponseMessage();
            logger.trace("Response {} {}", (Object)responseCode, (Object)responseMessage);
            if (responseCode == 204) {
                JsonNode jsonNode = null;
                return jsonNode;
            }
            if (responseCode == 404) {
                throw new RuntimeException(responseCode + " " + responseMessage);
            }
            if (responseCode == 403) {
                throw new RuntimeException(responseCode + " " + responseMessage);
            }
            if (responseCode >= 400) {
                InputStream inputStream = connection.getErrorStream();
                StringBuilder result = this.getStringBuilder(inputStream);
                String res = result.toString();
                throw new RuntimeException(res);
            }
            StringBuilder result = this.getStringBuilder(connection.getInputStream());
            String res = result.toString();
            logger.trace("Server returned content : {}", (Object)res);
            JsonNode jsonNode = Utils.getObjectMapper().readTree(res);
            return jsonNode;
        }
        finally {
            connection.disconnect();
        }
    }

    protected String createZenodoDOIURLFromID(String id) throws MalformedURLException {
        return this.doiBaseURL + id;
    }

    public void create() throws Exception {
        GXHTTPStringRequest gxHTTPStringRequest = GXHTTPStringRequest.newRequest((String)this.zenodoBaseURL.toString());
        gxHTTPStringRequest.isExternalCall(true);
        gxHTTPStringRequest.from(GUCBE_ZENODO_SOFTWARE_DEPOSIT);
        gxHTTPStringRequest.queryParams(this.getAccessTokenQueryParamters());
        gxHTTPStringRequest.header("Content-Type", "application/json");
        gxHTTPStringRequest.header("Accept", "application/json");
        gxHTTPStringRequest.path(DEPOSITIONS_COLLECTION_PATH);
        ObjectNode metadata = this.generateMetadata();
        HttpURLConnection httpURLConnection = gxHTTPStringRequest.post(Utils.getObjectMapper().writeValueAsString((Object)metadata));
        this.response = this.getResponse(httpURLConnection);
        String conceptDOIURL = this.createZenodoDOIURLFromID(this.response.get("conceptrecid").asText());
        this.softwareVersionConfig.setConceptDOIURL(conceptDOIURL);
        String versionDOIURL = this.createZenodoDOIURLFromID(this.response.get("id").asText());
        this.softwareVersionConfig.setVersionDOIURL(versionDOIURL);
        this.finalize();
    }

    private ArrayNode getAuthors() {
        ArrayNode authors = this.softwareVersionConfig.getAuthors().deepCopy();
        return authors;
    }

    private String getDescription() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.softwareVersionConfig.getAdditionalProperty(HTML_DESCRIPTION_CONFIG_FIELD_NAME).asText());
        if (this.exporterConfig.getProperty(ADDITIONAL_HTML_DESCRIPTION_CONFIG_FIELD_NAME) != null) {
            String additionalHTMLDescription = this.exporterConfig.getProperty(ADDITIONAL_HTML_DESCRIPTION_CONFIG_FIELD_NAME).asText();
            stringBuffer.append(additionalHTMLDescription);
        }
        return stringBuffer.toString();
    }

    private ArrayNode getGrants() {
        ObjectMapper objectMapper = Utils.getObjectMapper();
        ArrayNode grants = objectMapper.createArrayNode();
        ArrayNode arrayNode = (ArrayNode)this.exporterConfig.getProperty(SKIP_GRANTS_CONFIG_FIELD_NAME);
        HashSet<String> idToSkip = new HashSet<String>();
        for (JsonNode idNode : arrayNode) {
            idToSkip.add(idNode.asText());
        }
        for (JsonNode g : this.softwareVersionConfig.getGrants()) {
            String id = g.get("id").asText();
            if (idToSkip.contains(id)) continue;
            ObjectNode grant = objectMapper.createObjectNode();
            grant.put("id", id);
            grants.add((JsonNode)grant);
        }
        return grants;
    }

    private ArrayNode getKeywords() {
        Set<String> keywords = this.softwareVersionConfig.getKeywords();
        ObjectMapper objectMapper = Utils.getObjectMapper();
        ArrayNode keywordsArrayNode = objectMapper.createArrayNode();
        for (String keyword : keywords) {
            keywordsArrayNode.add(keyword);
        }
        return keywordsArrayNode;
    }

    private ArrayNode getCommunities() {
        return (ArrayNode)this.softwareVersionConfig.getAdditionalProperty(COMMUNITIES_FIELD_NAME);
    }

    private String getLicense() {
        return this.softwareVersionConfig.getLicense().get("id").asText();
    }

    private String getDate() {
        return Utils.getDateAsString(this.softwareVersionConfig.getDate());
    }

    private ObjectNode generateMetadata() {
        ObjectMapper objectMapper = Utils.getObjectMapper();
        ObjectNode metadatWrapper = objectMapper.createObjectNode();
        ObjectNode metadata = objectMapper.createObjectNode();
        metadata.put("access_right", "open");
        metadata.put("upload_type", "software");
        metadata.replace("creators", (JsonNode)this.getAuthors());
        metadata.put("description", this.getDescription());
        metadata.replace(COMMUNITIES_FIELD_NAME, (JsonNode)this.getCommunities());
        metadata.replace("grants", (JsonNode)this.getGrants());
        metadata.replace("keywords", (JsonNode)this.getKeywords());
        metadata.put("license", this.getLicense());
        metadata.put("publication_date", this.getDate());
        metadata.put("title", this.softwareVersionConfig.getTitle());
        metadata.put("version", this.softwareVersionConfig.getVersion());
        metadatWrapper.set(METADATA_FIELD_NAME, (JsonNode)metadata);
        return metadatWrapper;
    }

    public void update() throws Exception {
        GXHTTPStringRequest gxHTTPStringRequest = GXHTTPStringRequest.newRequest((String)this.zenodoBaseURL.toString());
        gxHTTPStringRequest.isExternalCall(true);
        gxHTTPStringRequest.from(GUCBE_ZENODO_SOFTWARE_DEPOSIT);
        gxHTTPStringRequest.queryParams(this.getAccessTokenQueryParamters());
        gxHTTPStringRequest.header("Accept", "application/json");
        String id = this.getZenodoIDFromDOIURL(this.softwareVersionConfig.getVersionDOIURL());
        gxHTTPStringRequest.path(DEPOSTION_EDIT_PATH.replace(":id", id));
        HttpURLConnection httpURLConnection = gxHTTPStringRequest.post();
        this.getResponse(httpURLConnection);
        this.updateMetadata();
        this.publishToZenodo();
    }

    protected void deletePreviousFiles() throws Exception {
        ArrayNode files = (ArrayNode)this.response.get("files");
        for (int i = 0; i < files.size(); ++i) {
            ObjectNode file = (ObjectNode)files.get(i);
            String fileURLString = file.get("links").get("self").asText();
            GXHTTPStringRequest gxHTTPStringRequest = GXHTTPStringRequest.newRequest((String)fileURLString);
            gxHTTPStringRequest.isExternalCall(true);
            gxHTTPStringRequest.from(GUCBE_ZENODO_SOFTWARE_DEPOSIT);
            gxHTTPStringRequest.queryParams(this.getAccessTokenQueryParamters());
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.delete();
            this.getResponse(httpURLConnection);
        }
    }

    public void newVersion() throws Exception {
        String previousVersionVersion;
        GXHTTPStringRequest gxHTTPStringRequest = GXHTTPStringRequest.newRequest((String)this.zenodoBaseURL.toString());
        gxHTTPStringRequest.isExternalCall(true);
        gxHTTPStringRequest.from(GUCBE_ZENODO_SOFTWARE_DEPOSIT);
        gxHTTPStringRequest.queryParams(this.getAccessTokenQueryParamters());
        gxHTTPStringRequest.header("Content-Type", "application/json");
        gxHTTPStringRequest.header("Accept", "application/json");
        String conceptDOIURL = this.softwareVersionConfig.getConceptDOIURL();
        String conceptID = this.getZenodoIDFromDOIURL(conceptDOIURL);
        gxHTTPStringRequest.path(RECORD_PATH.replace(":id", conceptID));
        HttpURLConnection httpURLConnection = gxHTTPStringRequest.get();
        JsonNode jsonNode = this.getResponse(httpURLConnection);
        String latestVersionDOI = jsonNode.get("links").get("doi").asText();
        String previousVersionDOI = this.softwareVersionConfig.getPrevious().getVersionDOIURL().toString();
        if (previousVersionDOI.compareTo(latestVersionDOI) != 0) {
            logger.error("Zenodo obtained latest DOI {} != {} DOI from previous version", (Object)latestVersionDOI, (Object)previousVersionDOI);
            throw new RuntimeException("It seems that your json is not up to date with Zenodo.");
        }
        String latestVersionVersion = jsonNode.get(METADATA_FIELD_NAME).get("version").asText();
        if (latestVersionVersion.compareTo(previousVersionVersion = this.softwareVersionConfig.getPrevious().getVersion().toString()) != 0) {
            logger.error("Zenodo obtained latest Version {} != {} Version from previous version", (Object)latestVersionVersion, (Object)previousVersionVersion);
            throw new RuntimeException("It seems that your json is not up to date with Zenodo.");
        }
        gxHTTPStringRequest = GXHTTPStringRequest.newRequest((String)this.zenodoBaseURL.toString());
        gxHTTPStringRequest.isExternalCall(true);
        gxHTTPStringRequest.from(GUCBE_ZENODO_SOFTWARE_DEPOSIT);
        gxHTTPStringRequest.queryParams(this.getAccessTokenQueryParamters());
        gxHTTPStringRequest.header("Content-Type", "application/json");
        gxHTTPStringRequest.header("Accept", "application/json");
        String latestID = this.getZenodoIDFromDOIURL(latestVersionDOI);
        gxHTTPStringRequest.path(DEPOSTION_NEW_VERSION_PATH.replace(":id", latestID));
        httpURLConnection = gxHTTPStringRequest.post();
        jsonNode = this.getResponse(httpURLConnection);
        String draftURL = jsonNode.get("links").get("latest_draft").asText();
        String draftID = draftURL.replace(this.zenodoBaseURL.toString() + DEPOSITIONS_COLLECTION_PATH + "/", "");
        gxHTTPStringRequest = GXHTTPStringRequest.newRequest((String)this.zenodoBaseURL.toString());
        gxHTTPStringRequest.isExternalCall(true);
        gxHTTPStringRequest.from(GUCBE_ZENODO_SOFTWARE_DEPOSIT);
        gxHTTPStringRequest.queryParams(this.getAccessTokenQueryParamters());
        gxHTTPStringRequest.header("Accept", "application/json");
        gxHTTPStringRequest.path(DEPOSITION_PATH.replace(":id", draftID));
        httpURLConnection = gxHTTPStringRequest.get();
        this.response = this.getResponse(httpURLConnection);
        String newVersionDOIURL = this.response.get("doi_url").asText();
        this.softwareVersionConfig.setVersionDOIURL(newVersionDOIURL);
        this.deletePreviousFiles();
        this.finalize();
    }

    protected String getConfig(String propertyName) throws Exception {
        String conf = null;
        JsonNode node = this.exporterConfig.getProperty(propertyName);
        if (node == null || node.getNodeType() == JsonNodeType.NULL) {
            conf = Config.getProperties().getProperty(propertyName);
        }
        if (conf == null) {
            throw new Exception("No configuration for '" + propertyName + "' property found.");
        }
        return conf;
    }

    protected void getZenodoConnectionConfig() throws Exception {
        this.zenodoBaseURL = new URL(this.getConfig("zenodo_base_url"));
        this.accessToken = this.getConfig("zenodo_access_token");
        this.doiBaseURL = this.getConfig("doi_base_url");
    }

    @Override
    public void export() throws Exception {
        if (this.first) {
            File exportFile = super.getOutputFile();
            if (exportFile.exists()) {
                exportFile.delete();
            }
            exportFile.createNewFile();
        }
        this.getZenodoConnectionConfig();
        String title = this.softwareVersionConfig.getTitle();
        ElaborationType publish = this.exporterConfig.getElaboration();
        if (publish == ElaborationType.NONE) {
            logger.info("Zenodo Deposit is disabled for {}.", (Object)title);
            return;
        }
        if (this.softwareVersionConfig.getVersionDOIURL() != null) {
            this.softwareVersionConfig.setNewDeposition(false);
            if (publish == ElaborationType.ALL || publish == ElaborationType.UPDATE_ONLY) {
                logger.info("Going to update {}.", (Object)title);
                this.update();
            } else {
                logger.info("{} has been already deposited.", (Object)title);
            }
        } else if (publish == ElaborationType.ALL || publish == ElaborationType.NEW) {
            logger.info("Going to deposit {}", (Object)title);
            this.softwareVersionConfig.setNewDeposition(true);
            if (this.softwareVersionConfig.getConceptDOIURL() == null) {
                this.create();
            } else {
                this.newVersion();
            }
        }
    }

    protected ObjectNode getObjectNode() throws Exception {
        ObjectMapper objectMapper = Utils.getObjectMapper();
        ObjectNode toBeExported = objectMapper.createObjectNode();
        toBeExported.replace("configuration", (JsonNode)this.globalConfig.getOriginalJson().deepCopy());
        ArrayNode array = objectMapper.createArrayNode();
        boolean firstNode = true;
        for (SoftwareArtifactConfig previous = this.softwareVersionConfig; previous != null; previous = previous.getPrevious()) {
            ObjectNode node = previous.getOriginalJson().deepCopy();
            node.put("concept_doi_url", previous.getConceptDOIURL());
            if (firstNode) {
                toBeExported.put("concept_doi_url", previous.getConceptDOIURL());
                firstNode = false;
            }
            node.put("version_doi_url", previous.getVersionDOIURL());
            array.insert(0, (JsonNode)node);
        }
        toBeExported.replace("artifacts", (JsonNode)array);
        return toBeExported;
    }

    protected void writeObjectNodeToFile(ObjectNode toBeExported, File file) throws Exception {
        ObjectMapper objectMapper = Utils.getObjectMapper();
        objectMapper.writeValue(file, (Object)toBeExported);
    }

    @Override
    public File getOutputFile() throws Exception {
        File exportFile = super.getOutputFile();
        if (this.last) {
            ObjectNode toBeExported = this.getObjectNode();
            this.writeObjectNodeToFile(toBeExported, exportFile);
        }
        return exportFile;
    }
}

