/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.software.analyser;

import java.io.File;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.com.fasterxml.jackson.databind.node.ArrayNode;
import org.gcube.com.fasterxml.jackson.databind.node.ObjectNode;
import org.gcube.common.software.analyser.Analyser;
import org.gcube.common.software.utils.Utils;

public class AnalyserFactory {
    public static final String EXPORT_FILENAME_EXTENSION = ".json";
    public static final String CONFIGURATION_PROPERTY_NAME = "configuration";
    public static final String ARTIFACTS_PROPERTY_NAME = "artifacts";

    public static Analyser getAnalyser(File jsonFile) throws Exception {
        ObjectMapper objectMapper = Utils.getObjectMapper();
        JsonNode jsonNode = objectMapper.readTree(jsonFile);
        return AnalyserFactory.getAnalyser(jsonNode);
    }

    public static Analyser getAnalyser(String json) throws Exception {
        ObjectMapper objectMapper = Utils.getObjectMapper();
        JsonNode jsonNode = objectMapper.readTree(json);
        return AnalyserFactory.getAnalyser(jsonNode);
    }

    public static Analyser getAnalyser(JsonNode jsonNode) throws Exception {
        Analyser analyser = new Analyser();
        ObjectNode originalGlobal = (ObjectNode)jsonNode.get(CONFIGURATION_PROPERTY_NAME);
        analyser.setGlobalConfiguration(originalGlobal);
        ArrayNode originalVersions = (ArrayNode)jsonNode.get(ARTIFACTS_PROPERTY_NAME);
        analyser.setVersionConfigurations(originalVersions);
        return analyser;
    }
}

