/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.software.export.biblatex;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Set;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.node.ArrayNode;
import org.gcube.common.software.export.SoftwareVersionExporter;
import org.gcube.common.software.model.ElaborationType;
import org.gcube.common.software.model.Variables;
import org.gcube.common.software.utils.FileUtils;
import org.gcube.common.software.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BibLaTeXSoftwareVersionExporter
extends SoftwareVersionExporter {
    private static final Logger logger = LoggerFactory.getLogger(BibLaTeXSoftwareVersionExporter.class);
    public static final String EXPORT_FILENAME_EXTENSION = ".bib";
    public static final String TEMPLATE_FILENAME = "biblatex.template";

    public BibLaTeXSoftwareVersionExporter() {
        super(EXPORT_FILENAME_EXTENSION);
    }

    @Override
    public void export() throws Exception {
        if (this.first) {
            File exportFile = this.getOutputFile();
            if (exportFile.exists()) {
                exportFile.delete();
            }
            exportFile.createNewFile();
        }
        String title = this.softwareVersionConfig.getTitle();
        ElaborationType export = this.exporterConfig.getElaboration();
        switch (export) {
            case ALL: {
                this.generate();
                break;
            }
            case UPDATE_ONLY: {
                if (this.softwareVersionConfig.isNewDeposition().booleanValue()) {
                    logger.info("Skipping export for {}.", (Object)title);
                    return;
                }
                this.generate();
                break;
            }
            case NEW: {
                if (!this.softwareVersionConfig.isNewDeposition().booleanValue()) {
                    logger.info("Skipping export for {}.", (Object)title);
                    return;
                }
                this.generate();
                break;
            }
            default: {
                logger.info("Skipping export for {}.", (Object)title);
                return;
            }
        }
    }

    protected String getTemplate() throws Exception {
        File file = FileUtils.getFileFromFilename(TEMPLATE_FILENAME);
        byte[] bytes = Files.readAllBytes(file.toPath());
        String template = new String(bytes, StandardCharsets.UTF_8);
        return template;
    }

    private String getAuthors(ArrayNode arrayNode) {
        StringBuffer stringBuffer = new StringBuffer();
        int size = arrayNode.size();
        for (int i = 0; i < size; ++i) {
            JsonNode jsonNode = arrayNode.get(i);
            stringBuffer.append("{");
            String fullName = jsonNode.get("name").asText();
            String[] nameParts = fullName.split(",");
            stringBuffer.append(nameParts[1].trim());
            stringBuffer.append(" ");
            stringBuffer.append(nameParts[0].trim());
            stringBuffer.append("}");
            if (i >= size - 1) continue;
            stringBuffer.append(" and ");
        }
        return stringBuffer.toString();
    }

    private String getKeywords(Set<String> keywords) {
        StringBuffer stringBuffer = new StringBuffer();
        int size = keywords.size();
        String[] array = keywords.toArray(new String[size]);
        for (int i = 0; i < size; ++i) {
            stringBuffer.append(array[i]);
            if (i >= size - 1) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    protected String parseTemplate(String template) throws Exception {
        String s = template;
        s = Utils.replaceVariable("author", this.getAuthors(this.softwareVersionConfig.getAuthors()), s);
        s = Utils.replaceVariable("keywords", this.getKeywords(this.softwareVersionConfig.getKeywords()), s);
        Variables variables = this.softwareVersionConfig.getVariables();
        s = variables.replaceAllVariables(s);
        return s;
    }

    protected void generate() throws Exception {
        String title = this.softwareVersionConfig.getTitle();
        if (this.softwareVersionConfig.getVersionDOIURL() == null) {
            logger.info("No Version DOI URL for {}. It will not be exported in BibLaTex format.", (Object)title);
            return;
        }
        logger.info("Going to export {} in BibLaTex format.", (Object)title);
        String template = this.getTemplate();
        String output = this.parseTemplate(template);
        this.writeToFile(output);
    }

    protected void writeToFile(String output) throws Exception {
        File exportFile = this.getOutputFile();
        FileWriter fileWritter = new FileWriter(exportFile, true);
        BufferedWriter bw = new BufferedWriter(fileWritter);
        bw.write(output);
        bw.write("\n\n");
        bw.close();
    }
}

