/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.security.secrets;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.ClientType;
import org.gcube.common.security.Owner;
import org.gcube.common.security.secrets.Secret;

public class GCubeSecret
extends Secret {
    public static final String GCUBE_TOKEN_REGEX = "([0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12})(-[0-9]+)?";
    private String gcubeToken;
    private Owner owner;
    private String context;

    public GCubeSecret(String gcubeToken) {
        if (gcubeToken == null || gcubeToken.isEmpty()) {
            throw new RuntimeException("Invalid token: is null or empty");
        }
        if (!Pattern.matches(GCUBE_TOKEN_REGEX, gcubeToken)) {
            throw new RuntimeException("Invalid token: the gCube token must comply with the regex ([0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12})(-[0-9]+)?");
        }
        this.gcubeToken = gcubeToken;
    }

    private void init() throws Exception {
        AuthorizationEntry authorizationEntry = Constants.authorizationService().get(this.gcubeToken);
        this.owner = new Owner(authorizationEntry.getClientInfo().getId(), authorizationEntry.getClientInfo().getRoles(), authorizationEntry.getClientInfo().getType() != ClientType.USER);
        this.context = authorizationEntry.getContext();
    }

    public Owner getOwner() {
        if (Objects.isNull(this.owner)) {
            try {
                this.init();
            }
            catch (Exception e) {
                throw new RuntimeException("error retrieving context", e);
            }
        }
        return this.owner;
    }

    public String getContext() {
        if (Objects.isNull(this.context)) {
            try {
                this.init();
            }
            catch (Exception e) {
                throw new RuntimeException("error retrieving context", e);
            }
        }
        return this.context;
    }

    public Map<String, String> getHTTPAuthorizationHeaders() {
        HashMap<String, String> authorizationHeaders = new HashMap<String, String>();
        authorizationHeaders.put("gcube-token", this.gcubeToken);
        return authorizationHeaders;
    }

    public boolean isExpired() {
        return false;
    }
}

