package org.gcube.common.security.secrets;

import java.util.Map;
import java.util.concurrent.TimeUnit;

import org.gcube.common.keycloak.KeycloakClient;
import org.gcube.common.keycloak.KeycloakClientFactory;
import org.gcube.common.keycloak.model.TokenResponse;
import org.gcube.common.security.Owner;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
public class JWTSecret extends Secret {

	//private static final Logger logger = LoggerFactory.getLogger(JWTSecret.class);

	/**
	 * The interval of time expressed in milliseconds used as guard to refresh the token before that it expires .
	 * TimeUnit has been used to in place of just 
	 * using the number to have a clearer code 
	 */
	public static final long TOLERANCE = TimeUnit.MILLISECONDS.toMillis(200);

	private String jwtToken;


	private String context;
	private AccessTokenSecret accessTokenSecret;

	protected boolean initialised = false;

	public JWTSecret(String jwtToken) {
		this.jwtToken = jwtToken;
		init();
	}

	private synchronized void init() {
		try {
			KeycloakClient client = KeycloakClientFactory.newInstance();
			TokenResponse tokenResponse = client.queryUMAToken(context, "Bearer "+jwtToken, context, null);
			this.accessTokenSecret = new AccessTokenSecret(tokenResponse.getAccessToken());
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

	private synchronized void refreshAccessToken() {
		try {
			KeycloakClient client = KeycloakClientFactory.newInstance();
			TokenResponse tokenResponse = client.queryUMAToken(context, "Bearer "+jwtToken, context, null);
			this.accessTokenSecret = new AccessTokenSecret(tokenResponse.getAccessToken());
		} catch (Exception e) {
			throw new RuntimeException(e);
		}		
	}

	@Override
	public Owner getOwner() {
		return this.accessTokenSecret.getOwner();
	}

	@Override
	public String getContext() {
		if (this.accessTokenSecret.isExpired())
			refreshAccessToken();
		return this.accessTokenSecret.getContext();
	}

	@Override
	public Map<String, String> getHTTPAuthorizationHeaders() {
		if (this.accessTokenSecret.isExpired())
			refreshAccessToken();
		return this.accessTokenSecret.getHTTPAuthorizationHeaders();
	}

	@Override
	public boolean isExpired() {
		return false;
	}


}