package org.gcube.rest.resourcemanager.publisher;

import org.gcube.rest.commons.resourceawareservice.resources.GeneralResource;

public interface ResourcePublisher<T extends GeneralResource> {

	public abstract void deleteResource(String resourceID, String scope)
			throws ResourcePublisherException;

	public abstract void publishResource(T resource, String resourceClass, String resourceNamePref, String scope)
			throws ResourcePublisherException;

	public abstract void updateResource(T resource, String resourceClass, String resourceNamePref, String scope)
			throws ResourcePublisherException;

}