/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.resourcemanager.harvester;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.gcube.rest.commons.resourceawareservice.ResourceAwareServiceRestAPI;
import org.gcube.rest.commons.resourceawareservice.resources.StatefulResource;
import org.gcube.rest.resourcemanager.harvester.IResourceHarvester;
import org.gcube.rest.resourcemanager.harvester.exceptions.ResourceHarvesterException;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.jboss.resteasy.client.jaxrs.engines.ApacheHttpClient4Engine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceHarvester<T extends StatefulResource>
implements IResourceHarvester<T> {
    private static final Logger logger = LoggerFactory.getLogger(ResourceHarvester.class);
    private static final Integer CONNECTION_TIMEOUT_MILLIS = 10000;
    private static final Integer SOCKET_TIMEOUT_MILLIS = 10000;
    private static Gson gson = new Gson();
    private static ClientHttpEngine engine;

    @Inject
    public ResourceHarvester() {
    }

    @Override
    public T getResourceByID(String serviceEndpoint, String resourceID, Class<T> resourceCls, String scope) throws ResourceHarvesterException {
        ResteasyClient client = null;
        ResteasyWebTarget target = null;
        ResourceAwareServiceRestAPI simple = null;
        try {
            client = new ResteasyClientBuilder().build();
            target = client.target(serviceEndpoint);
            simple = (ResourceAwareServiceRestAPI)target.proxy(ResourceAwareServiceRestAPI.class);
        }
        catch (Exception e) {
            logger.error("Client could not connect to endpoint : " + serviceEndpoint, (Throwable)e);
            throw new ResourceHarvesterException("Client could not connect to endpoint : " + serviceEndpoint, e);
        }
        Response response = simple.getResourceREST(scope, resourceID, Boolean.valueOf(false));
        String resource = (String)response.readEntity(String.class);
        response.close();
        logger.info("resource json : " + resource);
        return (T)((StatefulResource)gson.fromJson(resource, resourceCls));
    }

    @Override
    public Set<T> getResources(String serviceEndpoint, Class<T> resourceCls, String scope) throws ResourceHarvesterException {
        Set<String> resourceIDs = null;
        try {
            resourceIDs = ResourceHarvester.getResourceIDs(serviceEndpoint, scope);
        }
        catch (ResourceHarvesterException e) {
            logger.error("error getting the resource ids from the endpoint : " + serviceEndpoint);
            throw e;
        }
        HashSet<T> resources = new HashSet<T>();
        logger.info("resource ids : " + resourceIDs);
        for (String resourceID : resourceIDs) {
            logger.info("getting resource with id : " + resourceID);
            try {
                T resource = this.getResourceByID(serviceEndpoint, resourceID, resourceCls, scope);
                resources.add(resource);
                logger.info("resource got : " + resource.toJSON());
            }
            catch (Exception e) {
                logger.warn("error while trying to get resource with id : " + resourceID + " from endpoint : " + serviceEndpoint + " skipping this resource..", (Throwable)e);
            }
        }
        return resources;
    }

    public static Set<String> getResourceIDs(String serviceEndpoint, String scope) throws ResourceHarvesterException {
        logger.info("getResourceIDs... from endpoint : " + serviceEndpoint + " scope : " + scope);
        ResteasyClient client = null;
        ResteasyWebTarget target = null;
        ResourceAwareServiceRestAPI simple = null;
        try {
            client = new ResteasyClientBuilder().httpEngine(ResourceHarvester.getHttpEngine()).build();
            target = client.target(serviceEndpoint);
            simple = (ResourceAwareServiceRestAPI)target.proxy(ResourceAwareServiceRestAPI.class);
        }
        catch (Exception e) {
            logger.error("Client could not connect to endpoint : " + serviceEndpoint, (Throwable)e);
            throw new ResourceHarvesterException("Client could not connect to endpoint : " + serviceEndpoint, e);
        }
        Response response = simple.listResourcesREST(scope, Boolean.valueOf(false), Boolean.valueOf(false));
        String resourcesJson = (String)response.readEntity(String.class);
        response.close();
        logger.info("getResourceIDs...OK");
        logger.info("getResourceIDs json : " + resourcesJson);
        try {
            return (Set)gson.fromJson(resourcesJson, new TypeToken<Set<String>>(){}.getType());
        }
        catch (Exception e) {
            throw new ResourceHarvesterException("could not convert  : " + resourcesJson + " to set of strings", e);
        }
    }

    private static synchronized ClientHttpEngine getHttpEngine() {
        if (engine == null) {
            DefaultHttpClient httpClient = new DefaultHttpClient();
            HttpParams params = httpClient.getParams();
            HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)CONNECTION_TIMEOUT_MILLIS);
            HttpConnectionParams.setSoTimeout((HttpParams)params, (int)SOCKET_TIMEOUT_MILLIS);
            engine = new ApacheHttpClient4Engine((HttpClient)httpClient);
        }
        return engine;
    }
}

