/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.commons.db.dao.app;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Singleton;
import org.gcube.rest.commons.db.model.app.RunInstanceModel;
import org.gcube.rest.commons.db.model.core.GenericDaoImpl;
import org.gcube.rest.commons.db.model.core.IGenericDAO;
import org.gcube.rest.commons.resourceawareservice.resources.RunInstance;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

@Singleton
public class RunInstanceModelDao
extends GenericDaoImpl<RunInstanceModel>
implements IGenericDAO<RunInstanceModel> {
    public static final Function<RunInstanceModel, String> resourceIDextractor = new Function<RunInstanceModel, String>(){

        public String apply(RunInstanceModel input) {
            return input.getResourceId();
        }
    };
    public static final Function<RunInstanceModel, RunInstance> converterModelToBase = new Function<RunInstanceModel, RunInstance>(){

        public RunInstance apply(RunInstanceModel input) {
            return input.copyTo();
        }
    };
    public static final Function<RunInstance, RunInstanceModel> converterBaseToModel = new Function<RunInstance, RunInstanceModel>(){

        public RunInstanceModel apply(RunInstance input) {
            return new RunInstanceModel(input);
        }
    };

    @Override
    public Class<RunInstanceModel> getClazz() {
        return RunInstanceModel.class;
    }

    public List<RunInstanceModel> getByServiceClassAndServiceNameAndScopeAndEndpointKey(String serviceClass, String serviceName, String scope, String endpointKey) {
        List results = this.findByCriteria(new Criterion[]{Restrictions.eq((String)"serviceClass", (Object)serviceClass), Restrictions.eq((String)"serviceName", (Object)serviceName)});
        ArrayList runningInstances = Lists.newArrayList();
        for (RunInstanceModel result : results) {
            String url = result.getEndpoints().get(endpointKey).toASCIIString();
            runningInstances.add(result);
        }
        return runningInstances;
    }

    public List<RunInstanceModel> getByServiceClassAndServiceNameAndScope(String serviceClass, String serviceName, String scope) {
        List<RunInstanceModel> results = this.findByCriteria(new Criterion[]{Restrictions.eq((String)"serviceClass", (Object)serviceClass), Restrictions.eq((String)"serviceName", (Object)serviceName)});
        return results;
    }

    public static List<RunInstance> convertToRunInstanceList(List<RunInstanceModel> list) {
        return Lists.newArrayList((Iterable)Collections2.transform(list, converterModelToBase));
    }

    public static Set<RunInstance> convertToRunInstanceSet(Collection<RunInstanceModel> list) {
        return Sets.newHashSet((Iterable)Collections2.transform(list, converterModelToBase));
    }

    public static Set<String> convertToResourceIDsSet(List<RunInstanceModel> list) {
        return Sets.newHashSet((Iterable)Collections2.transform(list, resourceIDextractor));
    }
}

