/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.function.aggregation;

import com.rapidminer.example.Attribute;
import com.rapidminer.tools.math.function.aggregation.AbstractAggregationFunction;
import java.util.HashMap;

public class ModeFunction
extends AbstractAggregationFunction {
    private HashMap<Double, Double> valueWeightMap = new HashMap();
    private double maximumValueWeight = Double.NEGATIVE_INFINITY;
    private double valueMaximumWeight = Double.NaN;

    public ModeFunction() {
        this(true);
    }

    public ModeFunction(Boolean ignoreMissings) {
        super(ignoreMissings);
    }

    public String getName() {
        return "mode";
    }

    protected void reset() {
        this.foundMissing = false;
        this.maximumValueWeight = 0.0;
        this.valueMaximumWeight = Double.NaN;
        if (this.valueWeightMap != null) {
            this.valueWeightMap.clear();
        }
    }

    public void update(double value, double weight) {
        if (Double.isNaN(value)) {
            this.foundMissing = true;
            return;
        }
        Double totalValueWeight = this.valueWeightMap.get(value);
        totalValueWeight = totalValueWeight != null ? Double.valueOf(totalValueWeight + weight) : new Double(weight);
        this.valueWeightMap.put(value, totalValueWeight);
        if (totalValueWeight > this.maximumValueWeight) {
            this.maximumValueWeight = totalValueWeight;
            this.valueMaximumWeight = value;
        }
    }

    public void update(double value) {
        if (Double.isNaN(value)) {
            this.foundMissing = true;
            return;
        }
        Double totalValueWeight = this.valueWeightMap.get(value);
        totalValueWeight = totalValueWeight != null ? Double.valueOf(totalValueWeight + 1.0) : new Double(1.0);
        this.valueWeightMap.put(value, totalValueWeight);
        if (totalValueWeight > this.maximumValueWeight) {
            this.maximumValueWeight = totalValueWeight;
            this.valueMaximumWeight = value;
        }
    }

    public double getValue() {
        if (this.foundMissing && !this.ignoreMissings) {
            return Double.NaN;
        }
        return this.valueMaximumWeight;
    }

    public boolean supportsAttribute(Attribute attribute) {
        return true;
    }
}

