/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.validation;

import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.condition.InnerOperatorCondition;
import com.rapidminer.operator.condition.LastInnerOperatorCondition;
import com.rapidminer.operator.performance.PerformanceCriterion;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.operator.validation.Tools;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.tools.math.AverageVector;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IteratingPerformanceAverage
extends OperatorChain {
    public static final String PARAMETER_ITERATIONS = "iterations";
    public static final String PARAMETER_AVERAGE_PERFORMANCES_ONLY = "average_performances_only";
    private PerformanceCriterion lastPerformance;

    public IteratingPerformanceAverage(OperatorDescription description) {
        super(description);
        this.addValue(new ValueDouble("performance", "The last performance average (main criterion)."){

            public double getDoubleValue() {
                if (IteratingPerformanceAverage.this.lastPerformance != null) {
                    return IteratingPerformanceAverage.this.lastPerformance.getAverage();
                }
                return Double.NaN;
            }
        });
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        int numberOfIterations = this.getParameterAsInt(PARAMETER_ITERATIONS);
        LinkedList<AverageVector> averageVectors = new LinkedList<AverageVector>();
        int i = 0;
        while (i < numberOfIterations) {
            IOContainer evalOutput = this.evaluate();
            Tools.handleAverages(evalOutput, averageVectors, this.getParameterAsBoolean(PARAMETER_AVERAGE_PERFORMANCES_ONLY));
            this.inApplyLoop();
            ++i;
        }
        PerformanceVector averagePerformance = Tools.getPerformanceVector(averageVectors);
        if (averagePerformance != null) {
            this.lastPerformance = averagePerformance.getMainCriterion();
        }
        IOObject[] result = new AverageVector[averageVectors.size()];
        averageVectors.toArray(result);
        return result;
    }

    private IOContainer evaluate() throws OperatorException {
        IOContainer container = this.getInput().copy();
        int i = 0;
        while (i < this.getNumberOfOperators()) {
            container = this.getOperator(i).apply(container);
            ++i;
        }
        return container;
    }

    @Override
    public InnerOperatorCondition getInnerOperatorCondition() {
        return new LastInnerOperatorCondition(new Class[]{PerformanceVector.class});
    }

    @Override
    public int getMinNumberOfInnerOperators() {
        return 0;
    }

    @Override
    public int getMaxNumberOfInnerOperators() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[0];
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{PerformanceVector.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeInt type = new ParameterTypeInt(PARAMETER_ITERATIONS, "The number of iterations.", 1, Integer.MAX_VALUE, 10);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeBoolean(PARAMETER_AVERAGE_PERFORMANCES_ONLY, "Indicates if only performance vectors should be averaged or all types of averagable result vectors.", true));
        return types;
    }
}

