/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.outlier;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.preprocessing.outlier.AbstractOutlierDetection;
import com.rapidminer.operator.preprocessing.outlier.SearchObject;
import com.rapidminer.operator.preprocessing.outlier.SearchSpace;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeInt;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LOFOutlierOperator
extends AbstractOutlierDetection {
    public static final String PARAMETER_MINIMAL_POINTS_LOWER_BOUND = "minimal_points_lower_bound";
    public static final String PARAMETER_MINIMAL_POINTS_UPPER_BOUND = "minimal_points_upper_bound";
    public static final String PARAMETER_DISTANCE_FUNCTION = "distance_function";
    private static final String[] distanceFunctionList = new String[]{"euclidian distance", "squared distance", "cosine distance", "inverted cosine distance", "angle"};

    public LOFOutlierOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet apply(ExampleSet eSet) throws OperatorException {
        int minPtsLowerBound = 0;
        int minPtsUpperBound = 0;
        int minPtsLB = this.getParameterAsInt(PARAMETER_MINIMAL_POINTS_LOWER_BOUND);
        int minPtsUB = this.getParameterAsInt(PARAMETER_MINIMAL_POINTS_UPPER_BOUND);
        int kindOfDistance = this.getParameterAsInt(PARAMETER_DISTANCE_FUNCTION);
        if (minPtsLB <= minPtsUB) {
            minPtsLowerBound = minPtsLB;
            minPtsUpperBound = minPtsUB;
        } else {
            minPtsLowerBound = minPtsUB;
            minPtsUpperBound = minPtsLB;
        }
        Iterator reader = eSet.iterator();
        int searchSpaceDimension = eSet.getAttributes().size();
        SearchSpace sr = new SearchSpace(searchSpaceDimension, minPtsLowerBound, minPtsUpperBound + 1);
        int counter = 0;
        while (reader.hasNext()) {
            Example example = (Example)reader.next();
            SearchObject so = new SearchObject(searchSpaceDimension, "object" + counter, minPtsLowerBound, minPtsUpperBound);
            ++counter;
            int i = 0;
            for (Attribute attribute : eSet.getAttributes()) {
                so.setVektor(i++, example.getValue(attribute));
            }
            sr.addObject(so);
        }
        this.log("Searching d=" + sr.getDimensions() + " dimensions with" + " MinPts Interval [" + minPtsLowerBound + " ; " + minPtsUpperBound + "]");
        sr.resetOutlierStatus();
        sr.findAllKdContainers(kindOfDistance);
        sr.computeLOF(minPtsLowerBound, minPtsUpperBound);
        Attribute outlierAttribute = AttributeFactory.createAttribute("Outlier", 4);
        eSet.getExampleTable().addAttribute(outlierAttribute);
        eSet.getAttributes().setOutlier(outlierAttribute);
        counter = 0;
        for (Example example : eSet) {
            SearchObject sobj = sr.getSearchObjects().elementAt(counter);
            example.setValue(outlierAttribute, sobj.getOutlierFactor());
            ++counter;
        }
        return eSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeInt(PARAMETER_MINIMAL_POINTS_LOWER_BOUND, "The lower bound for MinPts for the Outlier test (default value is 10)", 0, Integer.MAX_VALUE, 10));
        types.add(new ParameterTypeInt(PARAMETER_MINIMAL_POINTS_UPPER_BOUND, "The upper bound for MinPts for the Outlier test (default value is 20)", 0, Integer.MAX_VALUE, 20));
        types.add(new ParameterTypeCategory(PARAMETER_DISTANCE_FUNCTION, "choose which distance function will be used for calculating the distance between two objects", distanceFunctionList, 0));
        return types;
    }
}

