/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.preprocessing.AbstractDataProcessing;
import com.rapidminer.operator.visualization.ExampleVisualizationOperator;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.tools.OperatorService;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdTagging
extends AbstractDataProcessing {
    public static final String PARAMETER_CREATE_NOMINAL_IDS = "create_nominal_ids";

    public IdTagging(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet apply(ExampleSet eSet) throws OperatorException {
        boolean nominalIds;
        Attribute idAttribute = eSet.getAttributes().getId();
        if (idAttribute != null) {
            this.logWarning("Overwriting old id attribute!");
        }
        idAttribute = Tools.createSpecialAttribute(eSet, "id", (nominalIds = this.getParameterAsBoolean(PARAMETER_CREATE_NOMINAL_IDS)) ? 1 : 3);
        int currentId = 1;
        for (Example example : eSet) {
            example.setValue(idAttribute, nominalIds ? idAttribute.getMapping().mapString("id_" + currentId) : currentId);
            ++currentId;
            this.checkForStop();
        }
        ExampleVisualizationOperator visualizer = null;
        try {
            visualizer = OperatorService.createOperator(ExampleVisualizationOperator.class);
        }
        catch (OperatorCreationException e) {
            this.logNote("Cannot initialize example visualizer, skipping...");
        }
        if (visualizer != null) {
            visualizer.apply(new IOContainer(eSet));
        }
        return eSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeBoolean type = new ParameterTypeBoolean(PARAMETER_CREATE_NOMINAL_IDS, "True if nominal ids (instead of integer ids) should be created", false);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

