/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.performance;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.performance.MeasuredPerformance;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.math.Averagable;

public abstract class SimpleCriterion
extends MeasuredPerformance {
    private static final long serialVersionUID = 242287213804685323L;
    private double sum = 0.0;
    private double squaresSum = 0.0;
    private double exampleCount = 0.0;
    private Attribute predictedAttribute;
    private Attribute labelAttribute;
    private Attribute weightAttribute;

    public SimpleCriterion() {
    }

    public SimpleCriterion(SimpleCriterion sc) {
        super(sc);
        this.sum = sc.sum;
        this.squaresSum = sc.squaresSum;
        this.exampleCount = sc.exampleCount;
        this.labelAttribute = (Attribute)sc.labelAttribute.clone();
        this.predictedAttribute = (Attribute)sc.predictedAttribute.clone();
        if (sc.weightAttribute != null) {
            this.weightAttribute = (Attribute)sc.weightAttribute.clone();
        }
    }

    public double getExampleCount() {
        return this.exampleCount;
    }

    public void countExample(Example example) {
        double plabel;
        double label = example.getValue(this.labelAttribute);
        double weight = 1.0;
        if (this.weightAttribute != null) {
            weight = example.getValue(this.weightAttribute);
        }
        if (!this.predictedAttribute.isNominal()) {
            plabel = example.getValue(this.predictedAttribute);
        } else {
            String labelS = example.getNominalValue(this.labelAttribute);
            plabel = example.getConfidence(labelS);
            label = 1.0;
        }
        double deviation = this.countExample(label, plabel);
        if (!Double.isNaN(deviation)) {
            this.countExampleWithWeight(deviation, weight);
        } else {
            LogService.getGlobal().log("SimpleCriterion: NaN was generated!", 5);
        }
    }

    protected abstract double countExample(double var1, double var3);

    protected double transform(double value) {
        return value;
    }

    protected void countExampleWithWeight(double deviation, double weight) {
        if (!Double.isNaN(deviation)) {
            this.sum += deviation * weight;
            this.squaresSum += deviation * deviation * weight * weight;
            this.exampleCount += weight;
        }
    }

    public double getMikroAverage() {
        return this.transform(this.sum / this.exampleCount);
    }

    public double getMikroVariance() {
        double mean = this.getMikroAverage();
        double meanSquares = this.transform(this.squaresSum) / this.exampleCount;
        return meanSquares - mean * mean;
    }

    public void startCounting(ExampleSet eset, boolean useExampleWeights) throws OperatorException {
        super.startCounting(eset, useExampleWeights);
        this.exampleCount = 0.0;
        this.squaresSum = 0.0;
        this.sum = 0.0;
        this.predictedAttribute = eset.getAttributes().getPredictedLabel();
        this.labelAttribute = eset.getAttributes().getLabel();
        if (useExampleWeights) {
            this.weightAttribute = eset.getAttributes().getWeight();
        }
    }

    public double getFitness() {
        return -1.0 * this.getAverage();
    }

    public double getMaxFitness() {
        return 0.0;
    }

    public void buildSingleAverage(Averagable performance) {
        SimpleCriterion other = (SimpleCriterion)performance;
        this.sum += other.sum;
        this.squaresSum += other.squaresSum;
        this.exampleCount += other.exampleCount;
    }
}

