/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.performance;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.performance.AbstractPerformanceEvaluator;
import com.rapidminer.operator.performance.AreaUnderCurve;
import com.rapidminer.operator.performance.BinaryClassificationPerformance;
import com.rapidminer.operator.performance.PerformanceCriterion;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.LogService;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinominalClassificationPerformanceEvaluator
extends AbstractPerformanceEvaluator {
    private static final Class[] SIMPLE_CRITERIA_CLASSES = new Class[]{AreaUnderCurve.class};

    public BinominalClassificationPerformanceEvaluator(OperatorDescription description) {
        super(description);
    }

    @Override
    protected void checkCompatibility(ExampleSet exampleSet) throws OperatorException {
        Tools.isLabelled(exampleSet);
        Tools.isNonEmpty(exampleSet);
        Attribute label = exampleSet.getAttributes().getLabel();
        if (!label.isNominal()) {
            throw new UserError((Operator)this, 101, "the calculation of performance criteria for binominal classification tasks", label.getName());
        }
        if (label.getMapping().size() != 2) {
            throw new UserError((Operator)this, 114, "the calculation of performance criteria for binominal classification tasks", label.getName());
        }
    }

    @Override
    protected double[] getClassWeights(Attribute label) throws UndefinedParameterError {
        return null;
    }

    @Override
    public List<PerformanceCriterion> getCriteria() {
        LinkedList<PerformanceCriterion> performanceCriteria = new LinkedList<PerformanceCriterion>();
        int i = 0;
        while (i < SIMPLE_CRITERIA_CLASSES.length) {
            try {
                performanceCriteria.add((PerformanceCriterion)SIMPLE_CRITERIA_CLASSES[i].newInstance());
            }
            catch (InstantiationException e) {
                LogService.getGlobal().logError("Cannot instantiate " + SIMPLE_CRITERIA_CLASSES[i] + ". Skipping...");
            }
            catch (IllegalAccessException e) {
                LogService.getGlobal().logError("Cannot instantiate " + SIMPLE_CRITERIA_CLASSES[i] + ". Skipping...");
            }
            ++i;
        }
        i = 0;
        while (i < BinaryClassificationPerformance.NAMES.length) {
            performanceCriteria.add(new BinaryClassificationPerformance(i));
            ++i;
        }
        return performanceCriteria;
    }
}

