/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions.neuralnet;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.AbstractLearner;
import com.rapidminer.operator.learner.LearnerCapability;
import com.rapidminer.operator.learner.functions.neuralnet.SimpleNeuralNetModel;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeNumber;
import com.rapidminer.tools.RandomGenerator;
import java.util.List;
import java.util.Random;
import org.encog.neural.activation.ActivationFunction;
import org.encog.neural.activation.ActivationSigmoid;
import org.encog.neural.data.NeuralDataSet;
import org.encog.neural.data.basic.BasicNeuralDataSet;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.Layer;
import org.encog.neural.networks.layers.FeedforwardLayer;
import org.encog.neural.networks.training.backpropagation.Backpropagation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleNeuralNetLearner
extends AbstractLearner {
    public static final String PARAMETER_DEFINE_DIFFERENT_HIDDEN_LAYERS = "define_different_hidden_layers";
    public static final String PARAMETER_HIDDEN_LAYER_SIZES = "hidden_layer_sizes";
    public static final String PARAMETER_DEFAULT_NUMBER_OF_HIDDEN_LAYERS = "default_number_of_hidden_layers";
    public static final String PARAMETER_DEFAULT_HIDDEN_LAYER_SIZE = "default_hidden_layer_size";
    public static final String PARAMETER_TRAINING_CYCLES = "training_cycles";
    public static final String PARAMETER_LEARNING_RATE = "learning_rate";
    public static final String PARAMETER_MOMENTUM = "momentum";
    public static final String PARAMETER_ERROR_EPSILON = "error_epsilon";
    public static final String PARAMETER_LOCAL_RANDOM_SEED = "local_random_seed";
    private double[] attributeMin;
    private double[] attributeMax;
    private double labelMin;
    private double labelMax;

    public SimpleNeuralNetLearner(OperatorDescription description) {
        super(description);
    }

    @Override
    public Model learn(ExampleSet exampleSet) throws OperatorException {
        BasicNetwork network = this.getNetwork(exampleSet);
        NeuralDataSet trainingSet = this.getTraining(exampleSet);
        network = this.trainNetwork(network, trainingSet, this.getParameterAsDouble(PARAMETER_LEARNING_RATE), this.getParameterAsDouble(PARAMETER_MOMENTUM), this.getParameterAsDouble(PARAMETER_ERROR_EPSILON), this.getParameterAsInt(PARAMETER_TRAINING_CYCLES));
        return new SimpleNeuralNetModel(exampleSet, network, this.attributeMin, this.attributeMax, this.labelMin, this.labelMax);
    }

    private BasicNetwork getNetwork(ExampleSet exampleSet) throws OperatorException {
        BasicNetwork network = new BasicNetwork();
        network.addLayer((Layer)new FeedforwardLayer(exampleSet.getAttributes().size()));
        this.log("No hidden layers defined. Using default hidden layers.");
        int layerSize = this.getParameterAsInt(PARAMETER_DEFAULT_HIDDEN_LAYER_SIZE);
        if (layerSize <= 0) {
            layerSize = this.getDefaultLayerSize(exampleSet);
        }
        int p = 0;
        while (p < this.getParameterAsInt(PARAMETER_DEFAULT_NUMBER_OF_HIDDEN_LAYERS)) {
            network.addLayer((Layer)new FeedforwardLayer(layerSize));
            ++p;
        }
        if (exampleSet.getAttributes().getLabel().isNominal()) {
            network.addLayer((Layer)new FeedforwardLayer((ActivationFunction)new ActivationSigmoid(), 1));
        } else {
            network.addLayer((Layer)new FeedforwardLayer((ActivationFunction)new ActivationSigmoid(), 1));
        }
        network.reset((Random)RandomGenerator.getRandomGenerator(this.getParameterAsInt(PARAMETER_LOCAL_RANDOM_SEED)));
        return network;
    }

    private int getDefaultLayerSize(ExampleSet exampleSet) {
        return (int)Math.round((double)exampleSet.getAttributes().size() / 2.0) + 1;
    }

    private NeuralDataSet getTraining(ExampleSet exampleSet) {
        double[][] data = new double[exampleSet.size()][exampleSet.getAttributes().size()];
        double[][] labels = new double[exampleSet.size()][1];
        int index = 0;
        Attribute label = exampleSet.getAttributes().getLabel();
        this.attributeMin = new double[exampleSet.getAttributes().size()];
        this.attributeMax = new double[this.attributeMin.length];
        exampleSet.recalculateAllAttributeStatistics();
        int a = 0;
        for (Attribute attribute : exampleSet.getAttributes()) {
            this.attributeMin[a] = exampleSet.getStatistics(attribute, "minimum");
            this.attributeMax[a] = exampleSet.getStatistics(attribute, "maximum");
            ++a;
        }
        this.labelMin = exampleSet.getStatistics(label, "minimum");
        this.labelMax = exampleSet.getStatistics(label, "maximum");
        for (Example example : exampleSet) {
            a = 0;
            for (Attribute attribute : exampleSet.getAttributes()) {
                data[index][a] = this.attributeMin[a] != this.attributeMax[a] ? (example.getValue(attribute) - this.attributeMin[a]) / (this.attributeMax[a] - this.attributeMin[a]) : example.getValue(attribute) - this.attributeMin[a];
                ++a;
            }
            labels[index][0] = label.isNominal() ? example.getValue(label) : (this.labelMax != this.labelMin ? (example.getValue(label) - this.labelMin) / (this.labelMax - this.labelMin) : example.getValue(label) - this.labelMin);
            ++index;
        }
        return new BasicNeuralDataSet(data, labels);
    }

    private BasicNetwork trainNetwork(BasicNetwork network, NeuralDataSet trainingSet, double learningRate, double momentum, double maxError, int maxIteration) {
        Backpropagation train = new Backpropagation(network, trainingSet, learningRate, momentum);
        int epoch = 1;
        do {
            train.iteration();
        } while (++epoch < maxIteration && train.getError() > maxError);
        return (BasicNetwork)train.getNetwork();
    }

    @Override
    public boolean supportsCapability(LearnerCapability lc) {
        if (lc == LearnerCapability.NUMERICAL_ATTRIBUTES) {
            return true;
        }
        if (lc == LearnerCapability.BINOMINAL_CLASS) {
            return true;
        }
        return lc == LearnerCapability.NUMERICAL_CLASS;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeNumber type = new ParameterTypeInt(PARAMETER_DEFAULT_NUMBER_OF_HIDDEN_LAYERS, "The number of hidden layers. Only used if no layers are defined by the list hidden_layer_types.", 1, Integer.MAX_VALUE, 1);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeInt(PARAMETER_DEFAULT_HIDDEN_LAYER_SIZE, "The default size  of hidden layers. Only used if no layers are defined by the list hidden_layer_types. -1 means size (number of attributes + number of classes) / 2", -1, Integer.MAX_VALUE, -1));
        type = new ParameterTypeInt(PARAMETER_TRAINING_CYCLES, "The number of training cycles used for the neural network training.", 1, Integer.MAX_VALUE, 500);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_LEARNING_RATE, "The learning rate determines by how much we change the weights at each step.", 0.0, 1.0, 0.3);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeDouble(PARAMETER_MOMENTUM, "The momentum simply adds a fraction of the previous weight update to the current one (prevent local maxima and smoothes optimization directions).", 0.0, 1.0, 0.2));
        types.add(new ParameterTypeDouble(PARAMETER_ERROR_EPSILON, "The optimization is stopped if the training error gets below this epsilon value.", 0.0, Double.POSITIVE_INFINITY, 0.01));
        type = new ParameterTypeInt(PARAMETER_LOCAL_RANDOM_SEED, "Use the given random seed instead of global random numbers (-1: use global)", -1, Integer.MAX_VALUE, -1);
        types.add(type);
        return types;
    }
}

