/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions.neuralnet;

import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.learner.functions.neuralnet.ImprovedNeuralNetModel;
import com.rapidminer.operator.learner.functions.neuralnet.InnerNode;
import com.rapidminer.operator.learner.functions.neuralnet.InputNode;
import com.rapidminer.operator.learner.functions.neuralnet.Node;
import com.rapidminer.report.Renderable;
import com.rapidminer.tools.Tools;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;

public class ImprovedNeuralNetVisualizer
extends JPanel
implements MouseListener,
Renderable {
    private static final long serialVersionUID = -26826681541601736L;
    private static final int ROW_HEIGHT = 36;
    private static final int LAYER_WIDTH = 150;
    private static final int MARGIN = 30;
    private static final int NODE_RADIUS = 24;
    private static final Font LABEL_FONT = new Font("SansSerif", 0, 11);
    private ImprovedNeuralNetModel neuralNet;
    private int selectedLayerIndex = -1;
    private int selectedRowIndex = -1;
    private double maxAbsoluteWeight = Double.NEGATIVE_INFINITY;
    private String key = null;
    private int keyX = -1;
    private int keyY = -1;
    private String[] attributeNames;
    private Map<Integer, List<Node>> layers = new LinkedHashMap<Integer, List<Node>>();

    public ImprovedNeuralNetVisualizer(ImprovedNeuralNetModel neuralNet, String[] attributeNames) {
        this.neuralNet = neuralNet;
        this.attributeNames = attributeNames;
        this.addMouseListener(this);
        this.maxAbsoluteWeight = Double.NEGATIVE_INFINITY;
        ArrayList<InputNode> inputNodes = new ArrayList<InputNode>();
        Node[] nodeArray = this.neuralNet.getInputNodes();
        int n = nodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            InputNode inputNode = nodeArray[n2];
            inputNodes.add(inputNode);
            ++n2;
        }
        this.layers.put(0, inputNodes);
        nodeArray = this.neuralNet.getInnerNodes();
        n = nodeArray.length;
        n2 = 0;
        while (n2 < n) {
            double[] weights;
            Node innerNode = nodeArray[n2];
            double[] dArray = weights = ((InnerNode)innerNode).getWeights();
            int n3 = weights.length;
            int n4 = 0;
            while (n4 < n3) {
                double w = dArray[n4];
                this.maxAbsoluteWeight = Math.max(this.maxAbsoluteWeight, Math.abs(w));
                ++n4;
            }
            int layerIndex = innerNode.getLayerIndex();
            if (layerIndex != -2) {
                List<Node> layer;
                if ((layer = this.layers.get(++layerIndex)) == null) {
                    layer = new ArrayList<Node>();
                    this.layers.put(layerIndex, layer);
                }
                layer.add(innerNode);
            }
            ++n2;
        }
        int trueLayerIndex = this.layers.size();
        ArrayList<InnerNode> outputNodes = new ArrayList<InnerNode>();
        InnerNode[] innerNodeArray = this.neuralNet.getInnerNodes();
        int n5 = innerNodeArray.length;
        int n6 = 0;
        while (n6 < n5) {
            InnerNode innerNode = innerNodeArray[n6];
            int layerIndex = innerNode.getLayerIndex();
            if (layerIndex == -2) {
                outputNodes.add(innerNode);
            }
            ++n6;
        }
        this.layers.put(trueLayerIndex, outputNodes);
    }

    public Dimension getPreferredSize() {
        int maxRows = -1;
        for (Map.Entry<Integer, List<Node>> entry : this.layers.entrySet()) {
            int layerIndex = entry.getKey();
            int nodes = entry.getValue().size();
            if (layerIndex != -2) {
                ++nodes;
            }
            maxRows = Math.max(maxRows, nodes);
        }
        return new Dimension(this.layers.size() * 150 + 60, maxRows * 36 + 60);
    }

    public void paint(Graphics graphics) {
        graphics.clearRect(0, 0, this.getWidth(), this.getHeight());
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        Dimension dim = this.getPreferredSize();
        int height = dim.height;
        Graphics2D g = (Graphics2D)graphics;
        Graphics2D translated = (Graphics2D)g.create();
        translated.translate(30, 30);
        translated.setFont(LABEL_FONT);
        Graphics2D synapsesG = (Graphics2D)translated.create();
        this.paintSynapses(synapsesG, height);
        synapsesG.dispose();
        Graphics2D nodeG = (Graphics2D)translated.create();
        this.paintNodes(nodeG, height);
        nodeG.dispose();
        translated.dispose();
        if (this.key != null) {
            this.key = Tools.transformAllLineSeparators(this.key);
            String[] lines = this.key.split("\n");
            double maxWidth = Double.NEGATIVE_INFINITY;
            double totalHeight = 0.0;
            String[] stringArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                Rectangle2D keyBounds = g.getFontMetrics().getStringBounds(line, g);
                maxWidth = Math.max(maxWidth, keyBounds.getWidth());
                totalHeight += keyBounds.getHeight();
                ++n2;
            }
            Rectangle frame = new Rectangle(this.keyX - 4, this.keyY, (int)maxWidth + 8, (int)(totalHeight += (double)((lines.length - 1) * 3)) + 6);
            g.setColor(SwingTools.LIGHTEST_YELLOW);
            g.fill(frame);
            g.setColor(SwingTools.DARK_YELLOW);
            g.draw(frame);
            g.setColor(Color.BLACK);
            int xPos = this.keyX;
            int yPos = this.keyY;
            String[] stringArray2 = lines;
            int n3 = lines.length;
            int n4 = 0;
            while (n4 < n3) {
                String line = stringArray2[n4];
                Rectangle2D keyBounds = g.getFontMetrics().getStringBounds(line, g);
                g.drawString(line, xPos, yPos += (int)keyBounds.getHeight());
                yPos += 3;
                ++n4;
            }
        }
    }

    private void paintSynapses(Graphics2D g, int height) {
        int i = 1;
        while (i < this.layers.size()) {
            int layerIndex = i;
            List<Node> layer = this.layers.get(layerIndex);
            int offset = layerIndex == this.layers.size() - 1 ? 0 : 1;
            int outputY = height / 2 - (layer.size() + offset) * 36 / 2;
            for (Node node : layer) {
                if (node instanceof InnerNode) {
                    Node[] inputNodes = node.getInputNodes();
                    double[] weights = ((InnerNode)node).getWeights();
                    int inputY = height / 2 - (inputNodes.length + 1) * 36 / 2;
                    int j = 0;
                    while (j < inputNodes.length) {
                        float weight = 1.0f - (float)(Math.abs(weights[j + 1]) / this.maxAbsoluteWeight);
                        Color color = new Color(weight, weight, weight);
                        g.setColor(color);
                        g.drawLine(12, inputY + 12, 162, outputY + 12);
                        inputY += 36;
                        ++j;
                    }
                    float weight = 1.0f - (float)(Math.abs(weights[0]) / this.maxAbsoluteWeight);
                    Color color = new Color(weight, weight, weight);
                    g.setColor(color);
                    g.drawLine(12, inputY + 12, 162, outputY + 12);
                }
                outputY += 36;
            }
            g.translate(150, 0);
            ++layerIndex;
            ++i;
        }
    }

    private void paintNodes(Graphics2D g, int height) {
        for (Map.Entry<Integer, List<Node>> entry : this.layers.entrySet()) {
            int layerIndex = entry.getKey();
            List<Node> layer = entry.getValue();
            int nodes = layer.size();
            if (layerIndex < this.layers.size() - 1) {
                ++nodes;
            }
            String layerName = null;
            layerName = layerIndex == 0 ? "Input" : (layerIndex == this.layers.size() - 1 ? "Output" : "Hidden " + layerIndex);
            Rectangle2D stringBounds = LABEL_FONT.getStringBounds(layerName, g.getFontRenderContext());
            g.setColor(Color.BLACK);
            g.drawString(layerName, (int)(-1.0 * stringBounds.getWidth() / 2.0 + 12.0), 0);
            int yPos = height / 2 - nodes * 36 / 2;
            int r = 0;
            while (r < nodes) {
                Ellipse2D.Double node = new Ellipse2D.Double(0.0, yPos, 24.0, 24.0);
                if (layerIndex == 0 || layerIndex == this.layers.size() - 1) {
                    if (r < nodes - 1 || layerIndex == this.layers.size() - 1) {
                        g.setPaint(SwingTools.makeYellowPaint(24.0, 24.0));
                    } else {
                        g.setPaint(new Color(233, 233, 233));
                    }
                } else if (r < nodes - 1) {
                    g.setPaint(SwingTools.makeBluePaint(24.0, 24.0));
                } else {
                    g.setPaint(new Color(233, 233, 233));
                }
                g.fill(node);
                if (layerIndex == this.selectedLayerIndex && r == this.selectedRowIndex) {
                    g.setColor(Color.RED);
                } else {
                    g.setColor(Color.BLACK);
                }
                g.draw(node);
                yPos += 36;
                ++r;
            }
            g.translate(150, 0);
            ++layerIndex;
        }
    }

    private void setKey(String key, int keyX, int keyY) {
        this.key = key;
        this.keyX = keyX;
        this.keyY = keyY;
        this.repaint();
    }

    private void setSelectedNode(int layerIndex, int rowIndex, int xPos, int yPos) {
        this.selectedLayerIndex = layerIndex;
        this.selectedRowIndex = rowIndex;
        if (this.selectedLayerIndex < 0 || this.selectedRowIndex < 0) {
            this.setKey(null, -1, -1);
            return;
        }
        if (layerIndex == 0) {
            if (rowIndex >= 0 && rowIndex < this.attributeNames.length) {
                this.setKey(this.attributeNames[rowIndex], xPos, yPos);
            } else if (rowIndex == this.attributeNames.length) {
                this.setKey("Threshold Node", xPos, yPos);
            } else {
                this.setKey(null, -1, -1);
            }
        } else {
            List<Node> currentLayer = this.layers.get(this.selectedLayerIndex);
            if (rowIndex >= 0 && rowIndex < currentLayer.size()) {
                StringBuffer toolTip = new StringBuffer("Weights:" + Tools.getLineSeparator());
                Node node = currentLayer.get(this.selectedRowIndex);
                if (node instanceof InnerNode) {
                    InnerNode innerNode = (InnerNode)node;
                    double[] weights = innerNode.getWeights();
                    int w = 1;
                    while (w < weights.length) {
                        toolTip.append(String.valueOf(Tools.formatNumber(weights[w])) + Tools.getLineSeparator());
                        ++w;
                    }
                    toolTip.append(String.valueOf(Tools.formatNumber(weights[0])) + " (Threshold)");
                }
                this.setKey(toolTip.toString(), xPos, yPos);
            } else {
                this.setKey("Threshold Node", xPos, yPos);
            }
        }
        this.repaint();
    }

    private void checkMousePos(int xPos, int yPos) {
        boolean layerHit;
        int x = xPos - 30;
        int y = yPos - 30;
        int layerIndex = x / 150;
        int layerMod = x % 150;
        boolean bl = layerHit = layerMod > 0 && layerMod < 24;
        if (layerHit && layerIndex >= 0 && layerIndex < this.layers.size()) {
            int yMargin;
            List<Node> layer = this.layers.get(layerIndex);
            int rows = layer.size();
            if (layerIndex < this.layers.size() - 1) {
                ++rows;
            }
            if (y > (yMargin = this.getPreferredSize().height / 2 - rows * 36 / 2)) {
                int i = 0;
                while (i < rows) {
                    if (y > yMargin && y < yMargin + 24) {
                        if (this.selectedLayerIndex == layerIndex && this.selectedRowIndex == i) {
                            this.setSelectedNode(-1, -1, -1, -1);
                        } else {
                            this.setSelectedNode(layerIndex, i, xPos, yPos);
                        }
                        return;
                    }
                    yMargin += 36;
                    ++i;
                }
            }
        }
        this.setSelectedNode(-1, -1, -1, -1);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        int xPos = e.getX();
        int yPos = e.getY();
        this.checkMousePos(xPos, yPos);
    }

    public void prepareRendering() {
    }

    public void finishRendering() {
    }

    public int getRenderHeight(int preferredHeight) {
        int height = this.getPreferredSize().height;
        if (height < 1) {
            height = preferredHeight;
        }
        if (preferredHeight > height) {
            height = preferredHeight;
        }
        return height;
    }

    public int getRenderWidth(int preferredWidth) {
        int width = this.getPreferredSize().width;
        if (width < 1) {
            width = preferredWidth;
        }
        if (preferredWidth > width) {
            width = preferredWidth;
        }
        return width;
    }

    public void render(Graphics graphics, int width, int height) {
        this.setSize(width, height);
        this.paint(graphics);
    }
}

