/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions.kernel.rvm;

import com.rapidminer.operator.learner.functions.kernel.rvm.kernel.KernelBasisFunction;
import com.rapidminer.tools.RandomGenerator;
import java.io.Serializable;

public class Model
implements Serializable {
    private static final long serialVersionUID = -8223343885533884477L;
    private KernelBasisFunction[] kernels;
    private double[] weights;
    private boolean bias;
    private boolean regression;

    public Model(double[] weights, KernelBasisFunction[] kernels, boolean bias, boolean regression) {
        this.kernels = kernels;
        this.weights = weights;
        this.bias = bias;
        this.regression = regression;
    }

    public int getNumberOfRelevanceVectors() {
        return this.weights.length;
    }

    public double getWeight(int index) {
        return this.weights[index];
    }

    public double applyToVector(double[] vector) {
        double prediction;
        int j;
        if (this.bias) {
            j = 1;
            prediction = this.weights[0];
        } else {
            j = 0;
            prediction = 0.0;
        }
        while (j < this.weights.length) {
            prediction += this.weights[j] * this.kernels[j].eval(vector);
            ++j;
        }
        return prediction;
    }

    public double[] apply(double[][] inputVectors) {
        double[] prediction = new double[inputVectors.length];
        int i = 0;
        while (i < inputVectors.length) {
            prediction[i] = this.applyToVector(inputVectors[i]);
            if (!this.regression) {
                prediction[i] = prediction[i] > 0.0 ? 1.0 : 0.0;
            }
            ++i;
        }
        return prediction;
    }

    public double norm_l2(double[] vector) {
        double result = 0.0;
        int i = 0;
        while (i < vector.length) {
            result += vector[i] * vector[i];
            ++i;
        }
        return Math.sqrt(result);
    }

    public double calculate(double[] att) {
        double noise = 0.1;
        double norm = this.norm_l2(att);
        return Math.sin(norm) / norm + noise * RandomGenerator.getRandomGenerator(0).nextDouble() - 0.5 * noise;
    }
}

