/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions.kernel;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.learner.functions.kernel.KernelModel;
import com.rapidminer.operator.learner.functions.kernel.SupportVector;
import com.rapidminer.tools.math.kernels.Kernel;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KernelLogisticRegressionModel
extends KernelModel {
    private static final long serialVersionUID = 2848059541066828127L;
    private Kernel kernel;
    private List<SupportVector> supportVectors;
    private double bias;

    public KernelLogisticRegressionModel(ExampleSet exampleSet, List<SupportVector> supportVectors, Kernel kernel, double bias) {
        super(exampleSet);
        this.supportVectors = supportVectors;
        if (supportVectors == null || supportVectors.size() == 0) {
            throw new IllegalArgumentException("Null or empty support vector collection: not possible to predict values!");
        }
        this.kernel = kernel;
        this.bias = bias;
    }

    @Override
    public String getName() {
        return "KLR Model";
    }

    @Override
    public boolean isClassificationModel() {
        return this.getLabel().isNominal();
    }

    @Override
    public double getAlpha(int index) {
        return this.supportVectors.get(index).getAlpha();
    }

    @Override
    public String getId(int index) {
        return null;
    }

    @Override
    public double getBias() {
        return this.bias;
    }

    @Override
    public SupportVector getSupportVector(int index) {
        return this.supportVectors.get(index);
    }

    @Override
    public int getNumberOfSupportVectors() {
        return this.supportVectors.size();
    }

    @Override
    public int getNumberOfAttributes() {
        return this.supportVectors.get(0).getX().length;
    }

    @Override
    public double getAttributeValue(int exampleIndex, int attributeIndex) {
        return this.supportVectors.get(exampleIndex).getX()[attributeIndex];
    }

    @Override
    public String getClassificationLabel(int index) {
        double y = this.getRegressionLabel(index);
        if (y < 0.0) {
            return this.getLabel().getMapping().getNegativeString();
        }
        return this.getLabel().getMapping().getPositiveString();
    }

    @Override
    public double getRegressionLabel(int index) {
        return this.supportVectors.get(index).getY();
    }

    @Override
    public double getFunctionValue(int index) {
        double[] values = this.supportVectors.get(index).getX();
        return this.bias + this.kernel.getSum(this.supportVectors, values);
    }

    @Override
    public ExampleSet performPrediction(ExampleSet exampleSet, Attribute predLabel) {
        if (exampleSet.getAttributes().size() != this.getNumberOfAttributes()) {
            throw new RuntimeException("Cannot apply model: incompatible numbers of attributes (" + exampleSet.getAttributes().size() + " != " + this.getNumberOfAttributes() + ")!");
        }
        for (Example current : exampleSet) {
            double[] currentX = new double[exampleSet.getAttributes().size()];
            int x = 0;
            for (Attribute attribute : exampleSet.getAttributes()) {
                currentX[x++] = current.getValue(attribute);
            }
            double sum = this.bias + this.kernel.getSum(this.supportVectors, currentX);
            if (this.getLabel().isNominal()) {
                double probPos = 1.0 / (1.0 + Math.exp(-sum));
                int index = probPos > 0.5 ? this.getLabel().getMapping().getPositiveIndex() : this.getLabel().getMapping().getNegativeIndex();
                current.setValue(predLabel, index);
                current.setConfidence(predLabel.getMapping().getPositiveString(), probPos);
                current.setConfidence(predLabel.getMapping().getNegativeString(), 1.0 - probPos);
                continue;
            }
            current.setValue(predLabel, sum);
        }
        return exampleSet;
    }
}

