/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner;

import com.rapidminer.RapidMiner;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.InputDescription;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ResultObject;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.learner.CapabilityCheck;
import com.rapidminer.operator.learner.Learner;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.tools.Tools;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLearner
extends Operator
implements Learner {
    public static final String PROPERTY_RAPIDMINER_GENERAL_CAPABILITIES_WARN = "rapidminer.general.capabilities.warn";

    static {
        RapidMiner.registerRapidMinerProperty(new ParameterTypeBoolean(PROPERTY_RAPIDMINER_GENERAL_CAPABILITIES_WARN, "Indicates if only a warning should be made if learning capabilities are not fulfilled (instead of breaking the process).", false));
    }

    public AbstractLearner(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        PerformanceVector optimizationPerformance;
        AttributeWeights weights;
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        if (exampleSet.getAttributes().getLabel() == null) {
            throw new UserError(this, 105);
        }
        if (exampleSet.getAttributes().size() == 0) {
            throw new UserError(this, 106);
        }
        if (exampleSet.size() == 0) {
            throw new UserError(this, 117);
        }
        CapabilityCheck check = new CapabilityCheck(this, Tools.booleanValue(System.getProperty(PROPERTY_RAPIDMINER_GENERAL_CAPABILITIES_WARN), true) || this.onlyWarnForNonSufficientCapabilities());
        check.checkLearnerCapabilities(this, exampleSet);
        LinkedList<ResultObject> results = new LinkedList<ResultObject>();
        Model model = this.learn(exampleSet);
        results.add(model);
        if (this.shouldCalculateWeights() && (weights = this.getWeights(exampleSet)) != null) {
            results.add(weights);
        }
        PerformanceVector perfVector = null;
        if (this.shouldEstimatePerformance()) {
            perfVector = this.getEstimatedPerformance();
        }
        if (this.shouldDeliverOptimizationPerformance() && (optimizationPerformance = this.getOptimizationPerformance()) != null && perfVector == null) {
            perfVector = optimizationPerformance;
        }
        if (perfVector != null) {
            results.add(perfVector);
        }
        IOObject[] resultArray = new IOObject[results.size()];
        results.toArray(resultArray);
        return resultArray;
    }

    @Override
    public boolean shouldEstimatePerformance() {
        return false;
    }

    @Override
    public boolean shouldCalculateWeights() {
        return false;
    }

    public boolean shouldDeliverOptimizationPerformance() {
        return false;
    }

    @Override
    public PerformanceVector getEstimatedPerformance() throws OperatorException {
        throw new UserError((Operator)this, 912, this.getName(), "estimation of performance not supported.");
    }

    public PerformanceVector getOptimizationPerformance() throws OperatorException {
        throw new UserError((Operator)this, 912, this.getName(), "delivering the original optimization performance is not supported.");
    }

    @Override
    public AttributeWeights getWeights(ExampleSet exampleSet) throws OperatorException {
        throw new UserError((Operator)this, 916, this.getName(), "calculation of weights not supported.");
    }

    public InputDescription getInputDescription(Class cls) {
        if (ExampleSet.class.isAssignableFrom(cls)) {
            return new InputDescription(cls, false, true);
        }
        return super.getInputDescription(cls);
    }

    public boolean onlyWarnForNonSufficientCapabilities() {
        return false;
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        LinkedList<Class<AttributeWeights>> classList = new LinkedList<Class<AttributeWeights>>();
        classList.add(Model.class);
        if (this.shouldEstimatePerformance()) {
            classList.add(PerformanceVector.class);
        }
        if (this.shouldCalculateWeights()) {
            classList.add(AttributeWeights.class);
        }
        Class[] result = new Class[classList.size()];
        classList.toArray(result);
        return result;
    }
}

