/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.construction;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.AttributeValueFilter;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.features.construction.AbstractFeatureConstruction;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.tools.Ontology;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConditionedFeatureGeneration
extends AbstractFeatureConstruction {
    public static final String PARAMETER_ATTRIBUTE_NAME = "attribute_name";
    public static final String PARAMETER_VALUE_TYPE = "value_type";
    public static final String PARAMETER_VALUES = "values";
    public static final String PARAMETER_CONDITIONS = "conditions";
    public static final String PARAMETER_DEFAULT_VALUE = "default_value";

    public ConditionedFeatureGeneration(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        Attribute attribute = AttributeFactory.createAttribute(this.getParameterAsString(PARAMETER_ATTRIBUTE_NAME), this.getParameterAsInt(PARAMETER_VALUE_TYPE) + 1);
        double mappedDefaultValue = Double.NaN;
        String defaultValue = this.getParameterAsString(PARAMETER_DEFAULT_VALUE);
        if (!defaultValue.equals("?")) {
            if (attribute.isNominal()) {
                mappedDefaultValue = attribute.getMapping().mapString(defaultValue);
            } else {
                try {
                    mappedDefaultValue = Double.parseDouble(defaultValue);
                }
                catch (NumberFormatException e) {
                    this.logError("default value has to be ? or numerical for numerical attributes: no feature is generated");
                    return exampleSet;
                }
            }
        }
        List<String[]> valueConditionList = this.getParameterList(PARAMETER_VALUES);
        int numberOfValueConditions = valueConditionList.size();
        String[] values = new String[numberOfValueConditions];
        double[] mappedValues = new double[numberOfValueConditions];
        AttributeValueFilter[] filters = new AttributeValueFilter[numberOfValueConditions];
        Iterator<String[]> iterator = valueConditionList.iterator();
        int j = 0;
        while (iterator.hasNext()) {
            String[] pair = iterator.next();
            values[j] = pair[0];
            if (values[j].equals("?")) {
                mappedValues[j] = Double.NaN;
            } else if (attribute.isNominal()) {
                mappedValues[j] = attribute.getMapping().mapString(values[j]);
            } else {
                try {
                    mappedValues[j] = Double.parseDouble(values[j]);
                }
                catch (NumberFormatException e) {
                    this.logError("values have to be numerical for numerical attributes: no feature is generated");
                    return exampleSet;
                }
            }
            filters[j] = new AttributeValueFilter(exampleSet, pair[1]);
            ++j;
        }
        exampleSet.getExampleTable().addAttribute(attribute);
        exampleSet.getAttributes().addRegular(attribute);
        block5: for (Example example : exampleSet) {
            example.setValue(attribute, mappedDefaultValue);
            int i = 0;
            while (i < numberOfValueConditions) {
                AttributeValueFilter filter = filters[i];
                if (filter.conditionOk(example)) {
                    example.setValue(attribute, mappedValues[i]);
                    continue block5;
                }
                ++i;
            }
        }
        exampleSet.recalculateAllAttributeStatistics();
        return exampleSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterType type = new ParameterTypeString(PARAMETER_ATTRIBUTE_NAME, "Attribute name.", false);
        type.setExpert(false);
        types.add(type);
        String[] valueTypes = new String[Ontology.VALUE_TYPE_NAMES.length - 1];
        int i = 1;
        while (i < Ontology.VALUE_TYPE_NAMES.length) {
            valueTypes[i - 1] = Ontology.VALUE_TYPE_NAMES[i];
            ++i;
        }
        type = new ParameterTypeCategory(PARAMETER_VALUE_TYPE, "Attribute value type.", valueTypes, 0);
        type.setExpert(false);
        types.add(type);
        ParameterTypeString valueCondition = new ParameterTypeString(PARAMETER_CONDITIONS, "Value condition.", false);
        type = new ParameterTypeList(PARAMETER_VALUES, "Values and conditions.", valueCondition);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeString(PARAMETER_DEFAULT_VALUE, "Default value.", "?");
        type.setExpert(true);
        types.add(type);
        return types;
    }
}

