/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.AbstractIOObject;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.ResultObject;
import com.rapidminer.operator.Saveable;
import com.rapidminer.tools.LoggingHandler;
import com.rapidminer.tools.Tools;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import javax.swing.JLabel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResultObjectAdapter
extends AbstractIOObject
implements ResultObject,
LoggingHandler,
Saveable {
    private static final long serialVersionUID = -8621885253590411373L;
    private transient List<Action> actions;

    private void initActions() {
        this.actions = new LinkedList<Action>();
        if (this.isSavable()) {
            this.addAction(new AbstractAction("Save..."){
                private static final long serialVersionUID = -5888181920926434464L;
                {
                    this.putValue("ShortDescription", "Save this " + Tools.classNameWOPackage(ResultObjectAdapter.this.getClass()) + " to disk.");
                }

                public void actionPerformed(ActionEvent e) {
                    File file = SwingTools.chooseFile(null, null, false, ResultObjectAdapter.this.getExtension(), ResultObjectAdapter.this.getFileDescription());
                    try {
                        if (file != null) {
                            ResultObjectAdapter.this.save(file);
                        }
                    }
                    catch (Exception ex) {
                        SwingTools.showSimpleErrorMessage("Cannot write to file '" + file + "'", ex);
                    }
                }
            });
        }
    }

    @Override
    public String getName() {
        return Tools.classNameWOPackage(this.getClass());
    }

    @Override
    public boolean isSavable() {
        return true;
    }

    @Override
    public void save(File file) throws IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            this.write(fos);
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }

    protected void addAction(Action a) {
        this.actions.add(a);
    }

    @Override
    public List<Action> getActions() {
        if (this.actions == null) {
            this.initActions();
        }
        return this.actions;
    }

    @Override
    public String toResultString() {
        return this.toString();
    }

    @Override
    public Icon getResultIcon() {
        return null;
    }

    @Override
    public Component getVisualizationComponent(IOContainer container) {
        String str = ResultObjectAdapter.toHTML(this.toResultString());
        JEditorPane resultText = new JEditorPane();
        resultText.setContentType("text/html");
        resultText.setText("<html><h1>" + this.getName() + "</h1><pre>" + str + "</pre></html>");
        resultText.setBorder(BorderFactory.createEmptyBorder(11, 11, 11, 11));
        resultText.setEditable(false);
        resultText.setBackground(new JLabel().getBackground());
        return new ExtendedJScrollPane(resultText);
    }

    public static String toHTML(String string) {
        String str = string;
        str = str.replaceAll(">", "&gt;");
        str = str.replaceAll("<", "&lt;");
        str = str.replaceAll(Tools.getLineSeparator(), "<br>");
        return str;
    }

    @Override
    public void log(String message) {
        this.getLog().log(String.valueOf(this.getName()) + ": " + message);
    }

    @Override
    public void logNote(String message) {
        this.getLog().logNote(String.valueOf(this.getName()) + ": " + message);
    }

    @Override
    public void logWarning(String message) {
        this.getLog().logWarning(String.valueOf(this.getName()) + ": " + message);
    }

    @Override
    public void logError(String message) {
        this.getLog().logError(String.valueOf(this.getName()) + ": " + message);
    }
}

