/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.viewer;

import com.rapidminer.datatable.SimpleDataTable;
import com.rapidminer.datatable.SimpleDataTableRow;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.gui.graphs.GraphViewer;
import com.rapidminer.gui.graphs.SimilarityGraphCreator;
import com.rapidminer.gui.plotter.charts.HistogramChart;
import com.rapidminer.gui.viewer.SimilarityKDistanceVisualization;
import com.rapidminer.gui.viewer.SimilarityTable;
import com.rapidminer.operator.similarity.SimilarityMeasure;
import com.rapidminer.tools.math.similarity.DistanceMeasure;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Random;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class SimilarityVisualization
extends JPanel {
    private static final long serialVersionUID = 1976956148942768107L;

    public SimilarityVisualization(SimilarityMeasure sim, ExampleSet exampleSet) {
        this.setLayout(new BorderLayout());
        DistanceMeasure measure = sim.getDistanceMeasure();
        ButtonGroup group = new ButtonGroup();
        JPanel togglePanel = new JPanel(new FlowLayout(0));
        final SimilarityTable tableView = new SimilarityTable(measure, exampleSet);
        final JRadioButton tableButton = new JRadioButton("Table View", true);
        tableButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (tableButton.isSelected()) {
                    SimilarityVisualization.this.remove(1);
                    SimilarityVisualization.this.add((Component)tableView, "Center");
                    SimilarityVisualization.this.repaint();
                }
            }
        });
        group.add(tableButton);
        togglePanel.add(tableButton);
        final GraphViewer<String, String> graphView = new GraphViewer<String, String>(new SimilarityGraphCreator(measure, exampleSet));
        final JRadioButton graphButton = new JRadioButton("Graph View", false);
        graphButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (graphButton.isSelected()) {
                    SimilarityVisualization.this.remove(1);
                    SimilarityVisualization.this.add((Component)graphView, "Center");
                    SimilarityVisualization.this.repaint();
                }
            }
        });
        group.add(graphButton);
        togglePanel.add(graphButton);
        SimpleDataTable dataTable = new SimpleDataTable("Histogram", new String[]{"Histogram"});
        double sampleRatio = Math.min(1.0, 500.0 / (double)exampleSet.size());
        Random random = new Random();
        int i = 0;
        for (Example example : exampleSet) {
            int j = 0;
            for (Example compExample : exampleSet) {
                if (i != j && random.nextDouble() < sampleRatio) {
                    double simValue = measure.calculateSimilarity(example, compExample);
                    dataTable.add(new SimpleDataTableRow(new double[]{simValue}));
                }
                ++j;
            }
            ++i;
        }
        final HistogramChart histogramView = new HistogramChart();
        histogramView.setDataTable(dataTable);
        histogramView.setPlotColumn(0, true);
        histogramView.setBinNumber(100);
        final JRadioButton histogramButton = new JRadioButton("Histogram View", false);
        histogramButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (histogramButton.isSelected()) {
                    SimilarityVisualization.this.remove(1);
                    SimilarityVisualization.this.add((Component)histogramView, "Center");
                    SimilarityVisualization.this.repaint();
                }
            }
        });
        group.add(histogramButton);
        togglePanel.add(histogramButton);
        final SimilarityKDistanceVisualization kDistancePlotter = new SimilarityKDistanceVisualization(measure, exampleSet);
        final JRadioButton kdistanceButton = new JRadioButton("k-Distance View", false);
        kdistanceButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (kdistanceButton.isSelected()) {
                    SimilarityVisualization.this.remove(1);
                    SimilarityVisualization.this.add((Component)kDistancePlotter, "Center");
                    SimilarityVisualization.this.repaint();
                }
            }
        });
        group.add(kdistanceButton);
        togglePanel.add(kdistanceButton);
        this.add((Component)togglePanel, "North");
        this.add((Component)tableView, "Center");
    }
}

