/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.properties;

import com.rapidminer.gui.properties.MatrixPropertyDialog;
import com.rapidminer.gui.properties.PropertyValueCellEditor;
import com.rapidminer.operator.Operator;
import com.rapidminer.parameter.ParameterTypeMatrix;
import com.rapidminer.tools.math.StringToMatrixConverter;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JTable;

public class MatrixValueCellEditor
extends AbstractCellEditor
implements PropertyValueCellEditor {
    private static final long serialVersionUID = 0L;
    private ParameterTypeMatrix type;
    private JButton button = new JButton("Edit Matrix...");
    private double[][] matrix;

    public MatrixValueCellEditor(ParameterTypeMatrix type) {
        this.type = type;
        this.button.setMargin(new Insets(0, 0, 0, 0));
        this.button.setToolTipText(type.getDescription());
        this.setButtonText();
    }

    public void setOperator(final Operator operator) {
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MatrixPropertyDialog dialog = new MatrixPropertyDialog(MatrixValueCellEditor.this.type, MatrixValueCellEditor.this.matrix, operator);
                dialog.setVisible(true);
                if (dialog.isOk()) {
                    MatrixValueCellEditor.this.matrix = dialog.getMatrix();
                    MatrixValueCellEditor.this.fireEditingStopped();
                    MatrixValueCellEditor.this.setButtonText();
                } else {
                    MatrixValueCellEditor.this.fireEditingCanceled();
                }
            }
        });
    }

    public Object getCellEditorValue() {
        return StringToMatrixConverter.createMatlabString(this.matrix);
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
        try {
            this.matrix = StringToMatrixConverter.parseMatlabString((String)value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setButtonText();
        return this.button;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    public boolean useEditorAsRenderer() {
        return true;
    }

    private void setButtonText() {
        if (this.matrix != null) {
            this.button.setText("Edit Matrix (" + this.matrix.length + " x " + this.matrix[0].length + ")...");
        } else {
            this.button.setText("Edit Matrix...");
        }
    }
}

