/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.processeditor;

import com.rapidminer.Process;
import com.rapidminer.gui.MainFrame;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.processeditor.ProcessEditor;
import com.rapidminer.gui.tools.syntax.JEditTextArea;
import com.rapidminer.operator.Operator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JPanel;

public class XMLEditor
extends JPanel
implements ProcessEditor,
FocusListener {
    private static final long serialVersionUID = 4172143138689034659L;
    private JEditTextArea editor;
    private MainFrame mainFrame;

    public XMLEditor(MainFrame mainFrame) {
        super(new BorderLayout());
        this.mainFrame = mainFrame;
        this.editor = new com.rapidminer.gui.tools.XMLEditor();
        this.editor.addFocusListener(this);
        this.add((Component)this.editor, "Center");
    }

    public void setText(String text) {
        this.editor.setText(text);
    }

    public void processChanged(Operator op) {
        this.setText(op.getXML("", true));
    }

    public void setCurrentOperator(Operator currentOperator) {
        if (currentOperator != null) {
            this.editor.requestFocus();
            this.editor.setCaretPosition(0);
            String name = currentOperator.getName();
            String text = this.editor.getText();
            int result = text.indexOf("\"" + name + "\"");
            if (result >= 0) {
                this.editor.select(result + 1, result + name.length() + 1);
            }
        }
    }

    public synchronized void validateProcess() throws Exception {
        Process newExp = new Process(this.editor.getText());
        if (!newExp.getRootOperator().getXML("", true).equals(RapidMinerGUI.getMainFrame().getProcess().getRootOperator().getXML("", true))) {
            newExp.setProcessFile(RapidMinerGUI.getMainFrame().getProcess().getProcessFile());
            RapidMinerGUI.getMainFrame().setProcess(newExp, true);
            this.mainFrame.processChanged();
        }
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        try {
            this.validateProcess();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

