/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.plotter;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.gui.plotter.ColorQuartilePlotter;
import com.rapidminer.gui.plotter.Quartile;
import com.rapidminer.tools.math.MathFunctions;
import javax.swing.Icon;

public class QuartilePlotter
extends ColorQuartilePlotter {
    private static final long serialVersionUID = -5115095967846809152L;
    private boolean[] columns = null;

    public QuartilePlotter() {
    }

    public QuartilePlotter(DataTable dataTable) {
        super(dataTable);
    }

    public void setDataTable(DataTable dataTable) {
        this.columns = new boolean[dataTable.getNumberOfColumns()];
        super.setDataTable(dataTable);
    }

    public int getNumberOfAxes() {
        return 0;
    }

    public String getPlotName() {
        return "Dimensions";
    }

    public int getValuePlotSelectionType() {
        return 1;
    }

    public void setPlotColumn(int index, boolean plot) {
        this.columns[index] = plot;
        this.repaint();
    }

    public boolean getPlotColumn(int index) {
        return this.columns[index];
    }

    public Icon getIcon(int index) {
        return null;
    }

    protected void prepareData() {
        this.allQuartiles.clear();
        this.globalMin = Double.POSITIVE_INFINITY;
        this.globalMax = Double.NEGATIVE_INFINITY;
        if (this.columns != null) {
            int totalCount = 0;
            int i = 0;
            while (i < this.dataTable.getNumberOfColumns()) {
                if (this.columns[i]) {
                    ++totalCount;
                }
                ++i;
            }
            i = 0;
            while (i < this.dataTable.getNumberOfColumns()) {
                if (this.columns[i]) {
                    Quartile quartile = Quartile.calculateQuartile(this.dataTable, i);
                    quartile.setColor(this.getColorProvider().getPointColor((double)i / (double)totalCount));
                    this.allQuartiles.add(quartile);
                    this.globalMin = MathFunctions.robustMin(this.globalMin, quartile.getMin());
                    this.globalMax = MathFunctions.robustMax(this.globalMax, quartile.getMax());
                }
                ++i;
            }
        }
    }
}

