/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.plotter;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.gui.plotter.ColorProvider;
import com.rapidminer.gui.plotter.PlotterPoint;
import com.rapidminer.gui.plotter.RadVizPlotter;
import com.rapidminer.gui.plotter.conditions.ColumnsPlotterCondition;
import com.rapidminer.gui.plotter.conditions.PlotterCondition;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;

public class GridVizPlotter
extends RadVizPlotter {
    private static final long serialVersionUID = 9178351977037267613L;
    private static final int MAX_NUMBER_OF_COLUMNS = 10000;

    public GridVizPlotter() {
    }

    public GridVizPlotter(DataTable dataTable) {
        this.setDataTable(dataTable);
    }

    public PlotterCondition getPlotterCondition() {
        return new ColumnsPlotterCondition(10000);
    }

    protected void calculateAttributeVectors(int totalSize, int gridSize, int gridDelta) {
        int dim = this.dataTable.getNumberOfColumns();
        this.anchorVectorX = new double[dim];
        this.anchorVectorY = new double[dim];
        int gridX = 0;
        int gridY = totalSize;
        int counter = 0;
        int i = 0;
        while (i < this.dataTable.getNumberOfColumns()) {
            if (i != this.colorColumn && !this.shouldIgnoreColumn(i)) {
                if (counter % gridSize == 0) {
                    gridX = 0;
                    gridY -= gridDelta;
                }
                this.anchorVectorX[i] = gridX;
                this.anchorVectorY[i] = gridY;
                gridX += gridDelta;
                ++counter;
            }
            ++i;
        }
    }

    protected void paintPlotter(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics.create();
        int width = this.getWidth();
        int height = this.getHeight();
        g.setColor(Color.BLACK);
        int totalSize = Math.min(width, height) - 40;
        int numberOfColumns = this.dataTable.getNumberOfColumns();
        if (this.colorColumn >= 0) {
            --numberOfColumns;
        }
        if ((numberOfColumns -= this.ignoreList.getSelectedIndices().length) == 0) {
            return;
        }
        int gridSize = (int)Math.ceil(Math.sqrt(numberOfColumns));
        int gridDelta = totalSize / gridSize;
        this.calculateAttributeVectors(totalSize, gridSize, gridDelta);
        g.setFont(LABEL_FONT);
        int i = 0;
        while (i < this.dataTable.getNumberOfColumns()) {
            if (i != this.colorColumn && !this.shouldIgnoreColumn(i)) {
                int x = (int)(20.0 + this.anchorVectorX[i]);
                int y = (int)((double)(20 + totalSize) - this.anchorVectorY[i]);
                if (this.dataTable.isSupportingColumnWeights()) {
                    g.setColor(GridVizPlotter.getWeightColor(this.dataTable.getColumnWeight(this.columnMapping[i]), this.maxWeight));
                    Rectangle2D.Double weightRect = new Rectangle2D.Double(x, y - gridDelta, gridDelta, gridDelta);
                    g.fill(weightRect);
                }
                g.setColor(GRID_COLOR);
                g.drawLine(x, y, x + gridDelta, y);
                g.drawLine(x, y, x, y - gridDelta);
                g.drawString(this.dataTable.getColumnName(this.columnMapping[i]), x + 5, y - 5);
            }
            ++i;
        }
        this.calculateSamplePoints();
        int centerPoint = totalSize / 2 + 20;
        Iterator i2 = this.plotterPoints.iterator();
        ColorProvider colorProvider = this.getColorProvider();
        while (i2.hasNext()) {
            this.drawPoint(g, (PlotterPoint)i2.next(), colorProvider, centerPoint, centerPoint, 1.0);
        }
        if (this.colorColumn != -1 && this.plotterPoints.size() > 0) {
            this.drawLegend(g, this.dataTable, this.colorColumn);
        }
    }
}

