/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.dialog;

import com.rapidminer.gui.properties.PropertyValueCellEditor;
import com.rapidminer.operator.Operator;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;

public class AttributeWeightCellEditor
extends AbstractCellEditor
implements PropertyValueCellEditor {
    private static final long serialVersionUID = 4648838759294286088L;
    private JPanel panel = new JPanel();
    private JTextField textField = new JTextField(12);
    private GridBagLayout gridBagLayout = new GridBagLayout();

    public AttributeWeightCellEditor(double oldValue) {
        this.panel.setLayout(this.gridBagLayout);
        this.panel.setToolTipText("The weight for this attribute.");
        this.textField.setToolTipText("The weight for this attribute.");
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        this.gridBagLayout.setConstraints(this.textField, c);
        this.panel.add(this.textField);
        c.weightx = 0.0;
        this.addButton(this.createValueButton("Zero", "0.0"), 1);
        this.addButton(this.createValueButton("One", "1.0"), -1);
        this.addButton(this.createValueButton("Reset", String.valueOf(oldValue)), 0);
    }

    public void setOperator(Operator operator) {
    }

    protected JButton createValueButton(String name, final String newValue) {
        JButton button = new JButton(name);
        button.setMargin(new Insets(0, 0, 0, 0));
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AttributeWeightCellEditor.this.textField.setText(newValue);
                AttributeWeightCellEditor.this.fireEditingStopped();
            }
        });
        button.setToolTipText("Sets the weight of this attribute to " + newValue + ".");
        return button;
    }

    protected void addButton(JButton button, int gridwidth) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = gridwidth;
        c.weightx = 0.0;
        c.fill = 1;
        this.gridBagLayout.setConstraints(button, c);
        this.panel.add(button);
    }

    public Object getCellEditorValue() {
        return this.textField.getText().trim().length() == 0 ? null : this.textField.getText().trim();
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
        this.textField.setText(value == null ? "" : value.toString());
        return this.panel;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    public boolean useEditorAsRenderer() {
        return true;
    }
}

