/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui;

import com.rapidminer.BreakpointListener;
import com.rapidminer.Process;
import com.rapidminer.RapidMiner;
import com.rapidminer.gui.ConditionalAction;
import com.rapidminer.gui.ProcessThread;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.actions.AnovaCalculatorAction;
import com.rapidminer.gui.actions.AttributeDescriptionFileWizardAction;
import com.rapidminer.gui.actions.AttributeEditorAction;
import com.rapidminer.gui.actions.BoxViewerAction;
import com.rapidminer.gui.actions.CheckForJDBCDriversAction;
import com.rapidminer.gui.actions.CheckForUpdatesAction;
import com.rapidminer.gui.actions.EditModeAction;
import com.rapidminer.gui.actions.ExitAction;
import com.rapidminer.gui.actions.ExportViewAction;
import com.rapidminer.gui.actions.ManageBuildingBlocksAction;
import com.rapidminer.gui.actions.ManageTemplatesAction;
import com.rapidminer.gui.actions.NewAction;
import com.rapidminer.gui.actions.OpenAction;
import com.rapidminer.gui.actions.PageSetupAction;
import com.rapidminer.gui.actions.PrintAction;
import com.rapidminer.gui.actions.PrintPreviewAction;
import com.rapidminer.gui.actions.RedoAction;
import com.rapidminer.gui.actions.ResultHistoryAction;
import com.rapidminer.gui.actions.ResultsModeAction;
import com.rapidminer.gui.actions.RunResumeAction;
import com.rapidminer.gui.actions.SaveAction;
import com.rapidminer.gui.actions.SaveAsAction;
import com.rapidminer.gui.actions.SaveAsTemplateAction;
import com.rapidminer.gui.actions.SettingsAction;
import com.rapidminer.gui.actions.StopAction;
import com.rapidminer.gui.actions.SwitchWorkspaceAction;
import com.rapidminer.gui.actions.ToggleExpertModeAction;
import com.rapidminer.gui.actions.ToggleLoggingViewerItem;
import com.rapidminer.gui.actions.ToggleSystemMonitorItem;
import com.rapidminer.gui.actions.TutorialAction;
import com.rapidminer.gui.actions.UndoAction;
import com.rapidminer.gui.actions.ValidateProcessAction;
import com.rapidminer.gui.actions.WizardAction;
import com.rapidminer.gui.dialog.Browser;
import com.rapidminer.gui.dialog.ProcessInfoScreen;
import com.rapidminer.gui.dialog.RequestSaveDialog;
import com.rapidminer.gui.dialog.Tutorial;
import com.rapidminer.gui.dialog.UnknownParametersInfoDialog;
import com.rapidminer.gui.operatortree.OperatorTree;
import com.rapidminer.gui.processeditor.MainProcessEditor;
import com.rapidminer.gui.processeditor.ResultDisplay;
import com.rapidminer.gui.properties.OperatorPropertyTable;
import com.rapidminer.gui.templates.SaveAsTemplateDialog;
import com.rapidminer.gui.templates.Template;
import com.rapidminer.gui.tools.AboutBox;
import com.rapidminer.gui.tools.ComponentPrinter;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ExtendedJToolBar;
import com.rapidminer.gui.tools.IconSize;
import com.rapidminer.gui.tools.LoggingViewer;
import com.rapidminer.gui.tools.StatusBar;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.SystemMonitor;
import com.rapidminer.gui.tools.WelcomeScreen;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.ProcessRootOperator;
import com.rapidminer.operator.UnknownParameterInformation;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeColor;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ParameterService;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.XMLException;
import com.rapidminer.tools.plugin.Plugin;
import de.java.print.PreviewDialog;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.freehep.util.export.ExportDialog;

public class MainFrame
extends JFrame
implements WindowListener {
    public static final String PROPERTY_RAPIDMINER_GUI_PLOTTER_MATRIXPLOT_SIZE = "rapidminer.gui.plotter.matrixplot.size";
    public static final String PROPERTY_RAPIDMINER_GUI_PLOTTER_ROWS_MAXIMUM = "rapidminer.gui.plotter.rows.maximum";
    public static final String PROPERTY_RAPIDMINER_GUI_PLOTTER_LEGEND_CLASSLIMIT = "rapidminer.gui.plotter.legend.classlimit";
    public static final String PROPERTY_RAPIDMINER_GUI_PLOTTER_LEGEND_MINCOLOR = "rapidminer.gui.plotter.legend.mincolor";
    public static final String PROPERTY_RAPIDMINER_GUI_PLOTTER_LEGEND_MAXCOLOR = "rapidminer.gui.plotter.legend.maxcolor";
    public static final String PROPERTY_RAPIDMINER_GUI_PLOTTER_COLORS_CLASSLIMIT = "rapidminer.gui.plotter.colors.classlimit";
    public static final String PROPERTY_RAPIDMINER_GUI_UNDOLIST_SIZE = "rapidminer.gui.undolist.size";
    public static final String PROPERTY_RAPIDMINER_GUI_ATTRIBUTEEDITOR_ROWLIMIT = "rapidminer.gui.attributeeditor.rowlimit";
    public static final String PROPERTY_RAPIDMINER_GUI_BEEP_SUCCESS = "rapidminer.gui.beep.success";
    public static final String PROPERTY_RAPIDMINER_GUI_BEEP_ERROR = "rapidminer.gui.beep.error";
    public static final String PROPERTY_RAPIDMINER_GUI_BEEP_BREAKPOINT = "rapidminer.gui.beep.breakpoint";
    public static final String PROPERTY_RAPIDMINER_GUI_MESSAGEVIEWER_ROWLIMIT = "rapidminer.gui.messageviewer.rowlimit";
    public static final String PROPERTY_RAPIDMINER_GUI_MESSAGEVIEWER_HIGHLIGHT_NOTES = "rapidminer.gui.messageviewer.highlight.notes";
    public static final String PROPERTY_RAPIDMINER_GUI_MESSAGEVIEWER_HIGHLIGHT_WARNINGS = "rapidminer.gui.messageviewer.highlight.warnings";
    public static final String PROPERTY_RAPIDMINER_GUI_MESSAGEVIEWER_HIGHLIGHT_ERRORS = "rapidminer.gui.messageviewer.highlight.errors";
    public static final String PROPERTY_RAPIDMINER_GUI_MESSAGEVIEWER_HIGHLIGHT_LOGSERVICE = "rapidminer.gui.messageviewer.highlight.logservice";
    public static final String PROPERTY_RAPIDMINER_GUI_PROCESSINFO_SHOW = "rapidminer.gui.processinfo.show";
    public static final String PROPERTY_RAPIDMINER_GUI_SAVEDIALOG = "rapidminer.gui.savedialog";
    private static final long serialVersionUID = -1602076945350148969L;
    private static final String NEWS_TEXT = "Try out the new and improved Na\u00efveBayes operator!" + Tools.getLineSeparator() + Tools.getLineSeparator() + "Send an e-Mail upon process completion:" + Tools.getLineSeparator() + "check out the Preferences dialog." + Tools.getLineSeparator() + Tools.getLineSeparator() + "Many input operators can now read data from URLs." + Tools.getLineSeparator() + Tools.getLineSeparator() + "Are you interested in support, consulting, or other" + Tools.getLineSeparator() + "professional services?   Visit: http://rapid-i.com/";
    private static final String HISTORY_ICON_NAME = "24/history2.png";
    private static final String ABOUT_ICON_NAME = "24/about.png";
    private static final String HELP_ICON_NAME = "24/help2.png";
    private static final String SUPPORT_ICON_NAME = "24/lifebelt.png";
    private static final String PLUGINS_ICON_NAME = "24/plug.png";
    private static final String RAPID_MINER_LOGO_NAME = "rapidminer_logo.png";
    private static Icon historyIcon = null;
    private static Icon aboutIcon = null;
    private static Icon helpIcon = null;
    private static Icon supportIcon = null;
    private static Icon pluginsIcon = null;
    private static Image rapidMinerLogo = null;
    public static final String TITLE = "RapidMiner";
    public static final int EDIT_MODE = 0;
    public static final int RESULTS_MODE = 1;
    public static final int WELCOME_MODE = 2;
    public static final String EDIT_MODE_NAME = "edit";
    public static final String RESULTS_MODE_NAME = "results";
    public static final String WELCOME_MODE_NAME = "welcome";
    public final transient Action NEW_ACTION_24 = new NewAction(this, IconSize.SMALL);
    public final transient Action NEW_ACTION_32 = new NewAction(this, IconSize.MIDDLE);
    public final transient Action OPEN_ACTION_24 = new OpenAction(this, IconSize.SMALL);
    public final transient Action OPEN_ACTION_32 = new OpenAction(this, IconSize.MIDDLE);
    public final transient Action SAVE_ACTION_24 = new SaveAction(this, IconSize.SMALL);
    public final transient Action SAVE_ACTION_32 = new SaveAction(this, IconSize.MIDDLE);
    public final transient Action SAVE_AS_ACTION_24 = new SaveAsAction(this, IconSize.SMALL);
    public final transient Action SAVE_AS_ACTION_32 = new SaveAsAction(this, IconSize.MIDDLE);
    public final transient Action SAVE_AS_TEMPLATE_ACTION_24 = new SaveAsTemplateAction(this, IconSize.SMALL);
    public final transient Action SAVE_AS_TEMPLATE_ACTION_32 = new SaveAsTemplateAction(this, IconSize.MIDDLE);
    public final transient Action MANAGE_TEMPLATES_ACTION_24 = new ManageTemplatesAction(this, IconSize.SMALL);
    public final transient Action MANAGE_TEMPLATES_ACTION_32 = new ManageTemplatesAction(this, IconSize.MIDDLE);
    public final transient Action MANAGE_BUILDING_BLOCKS_ACTION_24 = new ManageBuildingBlocksAction(this, IconSize.SMALL);
    public final transient Action MANAGE_BUILDING_BLOCKS_ACTION_32 = new ManageBuildingBlocksAction(this, IconSize.MIDDLE);
    public final transient Action PRINT_ACTION_24 = new PrintAction(this, IconSize.SMALL);
    public final transient Action PRINT_ACTION_32 = new PrintAction(this, IconSize.MIDDLE);
    public final transient Action PRINT_PREVIEW_ACTION_24 = new PrintPreviewAction(this, IconSize.SMALL);
    public final transient Action PRINT_PREVIEW_ACTION_32 = new PrintPreviewAction(this, IconSize.MIDDLE);
    public final transient Action PAGE_SETUP_ACTION_24 = new PageSetupAction(this, IconSize.SMALL);
    public final transient Action PAGE_SETUP_ACTION_32 = new PageSetupAction(this, IconSize.MIDDLE);
    public final transient Action EXPORT_ACTION_24 = new ExportViewAction(this, IconSize.SMALL);
    public final transient Action EXPORT_ACTION_32 = new ExportViewAction(this, IconSize.MIDDLE);
    public final transient Action EXIT_ACTION_24 = new ExitAction(this, IconSize.SMALL);
    public final transient Action EXIT_ACTION_32 = new ExitAction(this, IconSize.MIDDLE);
    public final transient RunResumeAction RUN_RESUME_ACTION_24 = new RunResumeAction(this, IconSize.SMALL);
    public final transient RunResumeAction RUN_RESUME_ACTION_32 = new RunResumeAction(this, IconSize.MIDDLE);
    public final transient Action STOP_ACTION_24 = new StopAction(this, IconSize.SMALL);
    public final transient Action STOP_ACTION_32 = new StopAction(this, IconSize.MIDDLE);
    public final transient Action VALIDATE_ACTION_24 = new ValidateProcessAction(this, IconSize.SMALL);
    public final transient Action VALIDATE_ACTION_32 = new ValidateProcessAction(this, IconSize.MIDDLE);
    public final transient Action WIZARD_ACTION_24 = new WizardAction(this, IconSize.SMALL);
    public final transient Action WIZARD_ACTION_32 = new WizardAction(this, IconSize.MIDDLE);
    public final transient Action SETTINGS_ACTION_24 = new SettingsAction(this, IconSize.SMALL);
    public final transient Action SETTINGS_ACTION_32 = new SettingsAction(this, IconSize.MIDDLE);
    public final transient Action TOGGLE_EXPERT_MODE_ACTION_24 = new ToggleExpertModeAction(this, IconSize.SMALL);
    public final transient Action TOGGLE_EXPERT_MODE_ACTION_32 = new ToggleExpertModeAction(this, IconSize.MIDDLE);
    public final transient Action TUTORIAL_ACTION_24 = new TutorialAction(this, IconSize.SMALL);
    public final transient Action TUTORIAL_ACTION_32 = new TutorialAction(this, IconSize.MIDDLE);
    public final transient Action UNDO_ACTION_24 = new UndoAction(this, IconSize.SMALL);
    public final transient Action UNDO_ACTION_32 = new UndoAction(this, IconSize.MIDDLE);
    public final transient Action REDO_ACTION_24 = new RedoAction(this, IconSize.SMALL);
    public final transient Action REDO_ACTION_32 = new RedoAction(this, IconSize.MIDDLE);
    public final transient Action ATTRIBUTE_EDITOR_ACTION_24 = new AttributeEditorAction(this, IconSize.SMALL);
    public final transient Action ATTRIBUTE_EDITOR_ACTION_32 = new AttributeEditorAction(this, IconSize.MIDDLE);
    public final transient Action ANOVA_CALCULATOR_ACTION_24 = new AnovaCalculatorAction(this, IconSize.SMALL);
    public final transient Action ANOVA_CALCULATOR_ACTION_32 = new AnovaCalculatorAction(this, IconSize.MIDDLE);
    public final transient Action CHECK_FOR_UPDATES_ACTION_24 = new CheckForUpdatesAction(IconSize.SMALL);
    public final transient Action CHECK_FOR_UPDATES_ACTION_32 = new CheckForUpdatesAction(IconSize.MIDDLE);
    public final transient Action CHECK_FOR_JDBC_DRIVERS_ACTION_24 = new CheckForJDBCDriversAction(this, IconSize.SMALL);
    public final transient Action CHECK_FOR_JDBC_DRIVERS_ACTION_32 = new CheckForJDBCDriversAction(this, IconSize.MIDDLE);
    public final transient Action EDIT_MODE_24 = new EditModeAction(this, IconSize.SMALL);
    public final transient Action EDIT_MODE_32 = new EditModeAction(this, IconSize.MIDDLE);
    public final transient Action RESULTS_MODE_24 = new ResultsModeAction(this, IconSize.SMALL);
    public final transient Action RESULTS_MODE_32 = new ResultsModeAction(this, IconSize.MIDDLE);
    public final transient Action BOX_VIEW_24 = new BoxViewerAction(this, IconSize.SMALL);
    public final transient Action BOX_VIEW_32 = new BoxViewerAction(this, IconSize.MIDDLE);
    public final transient Action RESULT_HISTORY_24 = new ResultHistoryAction(this, IconSize.SMALL);
    public final transient Action RESULT_HISTORY_32 = new ResultHistoryAction(this, IconSize.MIDDLE);
    public final transient Action ATTRIBUTE_DESCRIPTION_FILE_WIZARD_24 = new AttributeDescriptionFileWizardAction(IconSize.SMALL);
    public final transient Action ATTRIBUTE_DESCRIPTION_FILE_WIZARD_32 = new AttributeDescriptionFileWizardAction(IconSize.MIDDLE);
    public final transient Action SWITCH_WORKSPACE_24 = new SwitchWorkspaceAction(IconSize.SMALL);
    public final transient Action SWITCH_WORKSPACE_32 = new SwitchWorkspaceAction(IconSize.MIDDLE);
    public final JCheckBoxMenuItem TOGGLE_LOGGING_VIEWER = new ToggleLoggingViewerItem(this, IconSize.SMALL);
    public final JCheckBoxMenuItem TOGGLE_SYSTEM_MONITOR = new ToggleSystemMonitorItem(this, IconSize.SMALL);
    private CardLayout mainCardLayout = new CardLayout();
    private JPanel mainPanel = new JPanel(this.mainCardLayout);
    private WelcomeScreen welcomeScreen = null;
    private ResultDisplay resultDisplay = new ResultDisplay();
    private LoggingViewer messageViewer = new LoggingViewer();
    private SystemMonitor systemMonitor = new SystemMonitor();
    private StatusBar statusBar = new StatusBar();
    private MainProcessEditor mainEditor = new MainProcessEditor(this);
    private JToolBar toolBar = new ExtendedJToolBar();
    private JSplitPane splitPaneV;
    private JSplitPane loggingSplitPaneH;
    private int lastLoggingDividerLocation = -1;
    private int lastMonitorDividerLocation = -1;
    private int currentMode = 2;
    private JMenu recentFilesMenu = new JMenu("Recent Files");
    private transient PrinterJob printerJob = PrinterJob.getPrinterJob();
    private transient PageFormat pageFormat = this.printerJob.defaultPage();
    private boolean changed = false;
    private boolean tutorialMode = false;
    private LinkedList<String> undoList = new LinkedList();
    private int undoIndex;
    private boolean noActualChange = false;
    private String hostname = null;
    private transient Process process = null;
    private transient ProcessThread processThread;
    private JMenuBar menuBar;
    private final BreakpointListener breakpointListener = new BreakpointListener(){

        public void breakpointReached(Process process, Operator operator, IOContainer ioContainer, int location) {
            if (process.equals(MainFrame.this.process)) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        MainFrame.this.changeMode(1);
                    }
                });
                ProcessThread.beep("breakpoint");
                MainFrame.this.enableActions();
                MainFrame.this.resultDisplay.setData(ioContainer, "Results in application " + operator.getApplyCount() + " of " + operator.getName() + ":");
            }
        }

        public void resume() {
        }
    };

    static {
        historyIcon = SwingTools.createIcon(HISTORY_ICON_NAME);
        aboutIcon = SwingTools.createIcon(ABOUT_ICON_NAME);
        helpIcon = SwingTools.createIcon(HELP_ICON_NAME);
        supportIcon = SwingTools.createIcon(SUPPORT_ICON_NAME);
        pluginsIcon = SwingTools.createIcon(PLUGINS_ICON_NAME);
        URL url = Tools.getResource(RAPID_MINER_LOGO_NAME);
        if (url != null) {
            try {
                rapidMinerLogo = ImageIO.read(url);
            }
            catch (IOException e) {
                rapidMinerLogo = null;
            }
        } else {
            rapidMinerLogo = null;
        }
        RapidMiner.registerRapidMinerProperty(new ParameterTypeInt(PROPERTY_RAPIDMINER_GUI_PLOTTER_MATRIXPLOT_SIZE, "The pixel size of each plot in matrix plots.", 1, Integer.MAX_VALUE, 200));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeInt(PROPERTY_RAPIDMINER_GUI_PLOTTER_ROWS_MAXIMUM, "The maximum number of rows used for a plotter, using only a sample of this size if more rows are available.", 1, Integer.MAX_VALUE, 5000));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeInt(PROPERTY_RAPIDMINER_GUI_PLOTTER_LEGEND_CLASSLIMIT, "Limit number of displayed classes plotter legends. -1 for no limit.", -1, Integer.MAX_VALUE, 10));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeColor(PROPERTY_RAPIDMINER_GUI_PLOTTER_LEGEND_MINCOLOR, "The color for minimum values of the plotter legend.", Color.blue));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeColor(PROPERTY_RAPIDMINER_GUI_PLOTTER_LEGEND_MAXCOLOR, "The color for maximum values of the plotter legend.", Color.red));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeInt(PROPERTY_RAPIDMINER_GUI_PLOTTER_COLORS_CLASSLIMIT, "Limit number of displayed classes for colorized plots. -1 for no limit.", -1, Integer.MAX_VALUE, 10));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeInt(PROPERTY_RAPIDMINER_GUI_UNDOLIST_SIZE, "Maximum number of states in the undo list.", 1, Integer.MAX_VALUE, 10));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeInt(PROPERTY_RAPIDMINER_GUI_ATTRIBUTEEDITOR_ROWLIMIT, "Maximum number of examples to use for the attribute editor. -1 for no limit.", -1, Integer.MAX_VALUE, 50));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeBoolean(PROPERTY_RAPIDMINER_GUI_BEEP_SUCCESS, "Beep on process success?", false));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeBoolean(PROPERTY_RAPIDMINER_GUI_BEEP_ERROR, "Beep on error?", false));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeBoolean(PROPERTY_RAPIDMINER_GUI_BEEP_BREAKPOINT, "Beep when breakpoint reached?", false));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeInt(PROPERTY_RAPIDMINER_GUI_MESSAGEVIEWER_ROWLIMIT, "Limit number of displayed rows in the message viewer. -1 for no limit.", -1, Integer.MAX_VALUE, 1000));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeColor(PROPERTY_RAPIDMINER_GUI_MESSAGEVIEWER_HIGHLIGHT_NOTES, "The color for notes in the message viewer.", new Color(51, 151, 51)));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeColor(PROPERTY_RAPIDMINER_GUI_MESSAGEVIEWER_HIGHLIGHT_WARNINGS, "The color for warnings in the message viewer.", new Color(51, 51, 255)));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeColor(PROPERTY_RAPIDMINER_GUI_MESSAGEVIEWER_HIGHLIGHT_ERRORS, "The color for errors in the message viewer.", new Color(255, 51, 204)));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeColor(PROPERTY_RAPIDMINER_GUI_MESSAGEVIEWER_HIGHLIGHT_LOGSERVICE, "The color for the logging service indicator in the message viewer.", new Color(184, 184, 184)));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeBoolean(PROPERTY_RAPIDMINER_GUI_PROCESSINFO_SHOW, "Shows process info screen after loading?", true));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeBoolean(PROPERTY_RAPIDMINER_GUI_SAVEDIALOG, "Shows a dialog asking for saving the current process before the process is started?", true));
    }

    public MainFrame() {
        super(TITLE);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
        SwingTools.setFrameIcon(this);
        this.setProcess(new Process(), true);
        this.welcomeScreen = new WelcomeScreen(this, NEWS_TEXT);
        this.mainPanel.setBorder(null);
        this.mainPanel.add((Component)this.mainEditor, EDIT_MODE_NAME);
        this.mainPanel.add((Component)this.resultDisplay, RESULTS_MODE_NAME);
        this.mainPanel.add((Component)new ExtendedJScrollPane(this.welcomeScreen), WELCOME_MODE_NAME);
        this.mainEditor.setBorder(null);
        this.resultDisplay.setBorder(null);
        this.systemMonitor.setBorder(BorderFactory.createEtchedBorder());
        this.loggingSplitPaneH = new JSplitPane(1, this.messageViewer, this.systemMonitor);
        this.loggingSplitPaneH.setBorder(null);
        this.loggingSplitPaneH.setResizeWeight(1.0);
        this.systemMonitor.startMonitorThread();
        this.splitPaneV = new JSplitPane(0, this.mainPanel, this.loggingSplitPaneH);
        this.splitPaneV.setBorder(null);
        this.splitPaneV.setResizeWeight(1.0);
        this.splitPaneV.setBorder(null);
        this.getContentPane().add((Component)this.splitPaneV, "Center");
        this.menuBar = new JMenuBar();
        this.setJMenuBar(this.menuBar);
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        fileMenu.add(this.NEW_ACTION_24);
        fileMenu.add(this.WIZARD_ACTION_24);
        fileMenu.add(this.OPEN_ACTION_24);
        this.updateRecentFileList();
        this.recentFilesMenu.setIcon(historyIcon);
        fileMenu.add(this.recentFilesMenu);
        fileMenu.addSeparator();
        fileMenu.add(this.SAVE_ACTION_24);
        fileMenu.add(this.SAVE_AS_ACTION_24);
        fileMenu.add(this.SAVE_AS_TEMPLATE_ACTION_24);
        fileMenu.addSeparator();
        fileMenu.add(this.PRINT_ACTION_24);
        fileMenu.add(this.PRINT_PREVIEW_ACTION_24);
        fileMenu.add(this.PAGE_SETUP_ACTION_24);
        fileMenu.add(this.EXPORT_ACTION_24);
        fileMenu.addSeparator();
        fileMenu.add(this.SWITCH_WORKSPACE_24);
        fileMenu.addSeparator();
        fileMenu.add(this.EXIT_ACTION_24);
        this.menuBar.add(fileMenu);
        JMenu editMenu = new JMenu("Edit");
        editMenu.setMnemonic(69);
        editMenu.add(this.UNDO_ACTION_24);
        editMenu.add(this.REDO_ACTION_24);
        editMenu.addSeparator();
        editMenu.add(this.mainEditor.getOperatorTree().NEW_OPERATOR_ACTION_24);
        editMenu.add(this.mainEditor.getOperatorTree().NEW_BUILDING_BLOCK_ACTION_24);
        editMenu.addSeparator();
        this.mainEditor.getOperatorTree().addOperatorMenuItems(editMenu);
        this.menuBar.add(editMenu);
        JMenu viewMenu = new JMenu("View");
        viewMenu.setMnemonic(86);
        viewMenu.add(this.EDIT_MODE_24);
        viewMenu.add(this.RESULTS_MODE_24);
        viewMenu.addSeparator();
        viewMenu.add(this.TOGGLE_EXPERT_MODE_ACTION_24);
        viewMenu.addSeparator();
        viewMenu.add(this.BOX_VIEW_24);
        viewMenu.add(this.RESULT_HISTORY_24);
        viewMenu.addSeparator();
        viewMenu.add(this.TOGGLE_LOGGING_VIEWER);
        viewMenu.add(this.TOGGLE_SYSTEM_MONITOR);
        this.menuBar.add(viewMenu);
        JMenu expMenu = new JMenu("Process");
        expMenu.setMnemonic(80);
        expMenu.add(this.RUN_RESUME_ACTION_24);
        expMenu.add(this.STOP_ACTION_24);
        this.menuBar.add(expMenu);
        JMenu toolsMenu = new JMenu("Tools");
        toolsMenu.setMnemonic(84);
        toolsMenu.add(this.VALIDATE_ACTION_24);
        toolsMenu.add(this.mainEditor.getOperatorTree().INFO_OPERATOR_ACTION_24);
        toolsMenu.addSeparator();
        toolsMenu.add(this.ATTRIBUTE_DESCRIPTION_FILE_WIZARD_24);
        toolsMenu.add(this.ATTRIBUTE_EDITOR_ACTION_24);
        toolsMenu.add(this.ANOVA_CALCULATOR_ACTION_24);
        toolsMenu.add(this.messageViewer.CLEAR_MESSAGE_VIEWER_ACTION_24);
        toolsMenu.addSeparator();
        toolsMenu.add(this.MANAGE_TEMPLATES_ACTION_24);
        toolsMenu.add(this.MANAGE_BUILDING_BLOCKS_ACTION_24);
        toolsMenu.addSeparator();
        toolsMenu.add(this.CHECK_FOR_UPDATES_ACTION_24);
        toolsMenu.addSeparator();
        toolsMenu.add(this.CHECK_FOR_JDBC_DRIVERS_ACTION_24);
        toolsMenu.add(this.SETTINGS_ACTION_24);
        this.menuBar.add(toolsMenu);
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setMnemonic(72);
        JMenuItem aboutItem = new JMenuItem("About RapidMiner...", aboutIcon);
        aboutItem.setMnemonic(65);
        aboutItem.setToolTipText("Display information about RapidMiner");
        aboutItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new AboutBox((Frame)MainFrame.this, RapidMiner.getLongVersion(), rapidMinerLogo).setVisible(true);
            }
        });
        helpMenu.add(aboutItem);
        helpMenu.add(this.TUTORIAL_ACTION_24);
        JMenuItem contents = new JMenuItem("RapidMiner GUI Manual...", helpIcon);
        contents.setMnemonic(71);
        contents.setToolTipText("Browse the RapidMiner GUI Manual.");
        contents.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                URL manualResource = Tools.getResource("manual/RapidMinerGUIManual.html");
                if (manualResource != null) {
                    Browser.showDialog(manualResource);
                } else {
                    SwingTools.showVerySimpleErrorMessage("Cannot load GUI manual: file not found.");
                }
            }
        });
        helpMenu.add(contents);
        JMenuItem needSupport = new JMenuItem("Need Support?", supportIcon);
        needSupport.setMnemonic(83);
        needSupport.setToolTipText("Learn more about the possibilities of getting professional support for RapidMiner.");
        needSupport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String message = "Do you need professional support? Do you want" + Tools.getLineSeparator() + "to optimize the achieved results? Do you need" + Tools.getLineSeparator() + "professional training which enables you to find" + Tools.getLineSeparator() + "better data mining solutions in shorter times?" + Tools.getLineSeparators(2) + "Check out the offers on" + Tools.getLineSeparators(2) + "                      http://rapid-i.com" + Tools.getLineSeparators(2) + " including" + Tools.getLineSeparators(2) + "      - improved software versions, e.g. the Enterprise Edition of RapidMiner," + Tools.getLineSeparator() + "      - professional support and other services," + Tools.getLineSeparator() + "      - courses for data mining with RapidMiner," + Tools.getLineSeparator() + "      - and individual solutions and extensions." + Tools.getLineSeparators(2);
                JOptionPane.showMessageDialog(MainFrame.this, message, "Need Support?", 1);
            }
        });
        helpMenu.add(needSupport);
        List<Plugin> allPlugins = Plugin.getAllPlugins();
        boolean addedSeparator = false;
        if (allPlugins.size() > 0) {
            for (final Plugin plugin : allPlugins) {
                if (!plugin.showAboutBox()) continue;
                if (!addedSeparator) {
                    addedSeparator = true;
                    helpMenu.addSeparator();
                }
                JMenuItem aboutPluginItem = new JMenuItem("About " + plugin.getName() + "...", pluginsIcon);
                aboutPluginItem.setToolTipText("Display information about " + plugin.getName());
                aboutPluginItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        plugin.createAboutBox(MainFrame.this, rapidMinerLogo).setVisible(true);
                    }
                });
                helpMenu.add(aboutPluginItem);
            }
        }
        this.menuBar.add(helpMenu);
        this.toolBar.add(this.NEW_ACTION_24);
        this.toolBar.add(this.OPEN_ACTION_24);
        this.toolBar.add(this.SAVE_ACTION_24);
        this.toolBar.add(this.SAVE_AS_ACTION_24);
        this.toolBar.add(this.PRINT_ACTION_24);
        this.toolBar.addSeparator();
        this.toolBar.addSeparator();
        this.toolBar.add(this.UNDO_ACTION_24);
        this.toolBar.add(this.REDO_ACTION_24);
        this.toolBar.addSeparator();
        this.toolBar.addSeparator();
        this.toolBar.add(this.mainEditor.getOperatorTree().NEW_OPERATOR_ACTION_24);
        this.toolBar.add(this.mainEditor.getOperatorTree().DELETE_OPERATOR_ACTION_24);
        this.toolBar.add(this.mainEditor.getOperatorTree().NEW_BUILDING_BLOCK_ACTION_24);
        this.toolBar.addSeparator();
        this.toolBar.addSeparator();
        this.toolBar.add(this.RUN_RESUME_ACTION_24);
        this.toolBar.add(this.STOP_ACTION_24);
        this.toolBar.addSeparator();
        this.toolBar.addSeparator();
        this.toolBar.add(this.VALIDATE_ACTION_24);
        this.toolBar.addSeparator();
        this.toolBar.addSeparator();
        this.toolBar.add(this.TOGGLE_EXPERT_MODE_ACTION_24);
        this.toolBar.addSeparator();
        this.toolBar.addSeparator();
        this.toolBar.add(Box.createHorizontalGlue());
        this.toolBar.add(this.EDIT_MODE_24);
        this.toolBar.add(this.RESULTS_MODE_24);
        this.getContentPane().add((Component)this.toolBar, "North");
        this.getContentPane().add((Component)this.statusBar, "South");
        this.statusBar.startClockThread();
        this.addToUndoList();
        this.enableActions();
        this.pack();
        this.changeMode(2);
    }

    protected Object readResolve() {
        this.printerJob = PrinterJob.getPrinterJob();
        this.pageFormat = this.printerJob.defaultPage();
        return this;
    }

    public void changeMode(int mode) {
        this.currentMode = mode;
        switch (this.currentMode) {
            case 0: {
                this.mainCardLayout.show(this.mainPanel, EDIT_MODE_NAME);
                this.EDIT_MODE_24.setEnabled(false);
                this.EDIT_MODE_32.setEnabled(false);
                this.RESULTS_MODE_24.setEnabled(true);
                this.RESULTS_MODE_32.setEnabled(true);
                break;
            }
            case 1: {
                this.mainCardLayout.show(this.mainPanel, RESULTS_MODE_NAME);
                this.EDIT_MODE_24.setEnabled(true);
                this.EDIT_MODE_32.setEnabled(true);
                this.RESULTS_MODE_24.setEnabled(false);
                this.RESULTS_MODE_32.setEnabled(false);
                break;
            }
            case 2: {
                this.mainCardLayout.show(this.mainPanel, WELCOME_MODE_NAME);
                this.EDIT_MODE_24.setEnabled(true);
                this.EDIT_MODE_32.setEnabled(true);
                this.RESULTS_MODE_24.setEnabled(false);
                this.RESULTS_MODE_32.setEnabled(false);
            }
        }
    }

    public void startTutorial() {
        if (this.close()) {
            new Tutorial(this).setVisible(true);
        }
    }

    public void setTutorialMode(boolean mode) {
        this.tutorialMode = mode;
        if (this.tutorialMode) {
            this.SAVE_ACTION_24.setEnabled(false);
            this.SAVE_ACTION_32.setEnabled(false);
            this.SAVE_AS_ACTION_24.setEnabled(false);
            this.SAVE_AS_ACTION_32.setEnabled(false);
        } else {
            this.SAVE_ACTION_24.setEnabled(false);
            this.SAVE_ACTION_32.setEnabled(false);
            this.SAVE_AS_ACTION_24.setEnabled(true);
            this.SAVE_AS_ACTION_32.setEnabled(true);
        }
    }

    public boolean isTutorialMode() {
        return this.tutorialMode;
    }

    public void setSystemMonitor(SystemMonitor newSystemMonitor) {
        this.loggingSplitPaneH.remove(this.systemMonitor);
        this.systemMonitor = newSystemMonitor;
        this.systemMonitor.setBorder(BorderFactory.createEtchedBorder());
        this.loggingSplitPaneH.add(newSystemMonitor);
    }

    public void print() {
        switch (this.currentMode) {
            case 0: {
                this.printerJob.setPrintable(new ComponentPrinter(this.mainEditor));
                break;
            }
            case 1: {
                this.printerJob.setPrintable(new ComponentPrinter(this.resultDisplay.getCurrentlyDisplayedComponent()));
            }
        }
        if (this.printerJob.printDialog()) {
            try {
                this.printerJob.print();
            }
            catch (PrinterException pe) {
                SwingTools.showSimpleErrorMessage("Printer error", pe);
            }
        }
    }

    public void printPreview() {
        Component[] dialogComponents;
        ComponentPrinter printer = null;
        switch (this.currentMode) {
            case 0: {
                printer = new ComponentPrinter(this.mainEditor);
                break;
            }
            case 1: {
                printer = new ComponentPrinter(this.resultDisplay.getCurrentlyDisplayedComponent());
            }
        }
        PreviewDialog dialog = new PreviewDialog("Print Preview", (JFrame)this, (Printable)printer, this.pageFormat, 1);
        Component[] componentArray = dialogComponents = dialog.getContentPane().getComponents();
        int n = dialogComponents.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (c instanceof JToolBar) {
                ((JToolBar)c).setFloatable(false);
            }
            ++n2;
        }
        dialog.pack();
        dialog.setLocationRelativeTo((Component)this);
        dialog.setVisible(true);
    }

    public void pageSetup() {
        this.pageFormat = this.printerJob.pageDialog(this.pageFormat);
    }

    public void export() {
        ExportDialog exportDialog = new ExportDialog(TITLE);
        switch (this.currentMode) {
            case 0: {
                exportDialog.showExportDialog((Component)this, "Export", (Component)this.getOperatorTree(), this.getBaseName());
                break;
            }
            case 1: {
                exportDialog.showExportDialog((Component)this, "Export", (Component)this.resultDisplay, this.getBaseName());
            }
        }
    }

    public int getEditorDividerLocation() {
        return this.mainEditor.getDividerLocation();
    }

    public int getGroupSelectionDividerLocation() {
        return this.mainEditor.getGroupSelectionDivider();
    }

    public int getMainDividerLocation() {
        if (this.lastLoggingDividerLocation >= 0) {
            return this.splitPaneV.getHeight() - this.lastLoggingDividerLocation;
        }
        return this.splitPaneV.getDividerLocation();
    }

    public int getLoggingDividerLocation() {
        if (this.lastMonitorDividerLocation >= 0) {
            return this.loggingSplitPaneH.getWidth() - this.lastMonitorDividerLocation;
        }
        return this.loggingSplitPaneH.getDividerLocation();
    }

    public void setDividerLocations(int mainH, int editorV, int loggingV, int groupSelectionV) {
        this.mainEditor.setDividerLocation(editorV);
        this.mainEditor.setGroupSelectionDivider(groupSelectionV);
        this.splitPaneV.setDividerLocation(mainH);
        this.loggingSplitPaneH.setDividerLocation(loggingV);
    }

    public void toggleLoggingViewer(boolean show) {
        if (show) {
            this.splitPaneV.add(this.loggingSplitPaneH);
            this.splitPaneV.setDividerLocation(this.splitPaneV.getHeight() - this.lastLoggingDividerLocation);
            this.lastLoggingDividerLocation = -1;
        } else {
            this.lastLoggingDividerLocation = this.splitPaneV.getHeight() - this.splitPaneV.getDividerLocation();
            this.splitPaneV.remove(this.loggingSplitPaneH);
        }
    }

    public void toggleSystemMonitor(boolean show) {
        if (show) {
            this.loggingSplitPaneH.add(this.systemMonitor);
            this.loggingSplitPaneH.setDividerLocation(this.loggingSplitPaneH.getWidth() - this.lastMonitorDividerLocation);
            this.lastMonitorDividerLocation = -1;
        } else {
            this.lastMonitorDividerLocation = this.loggingSplitPaneH.getWidth() - this.loggingSplitPaneH.getDividerLocation();
            this.loggingSplitPaneH.remove(this.systemMonitor);
        }
    }

    public void toggleExpertMode() {
        this.getPropertyTable().toggleExpertMode();
        this.updateToggleExpertModeIcon();
    }

    protected void updateToggleExpertModeIcon() {
        ((ToggleExpertModeAction)this.TOGGLE_EXPERT_MODE_ACTION_24).updateIcon();
        ((ToggleExpertModeAction)this.TOGGLE_EXPERT_MODE_ACTION_32).updateIcon();
    }

    public OperatorPropertyTable getPropertyTable() {
        return this.mainEditor.getPropertyTable();
    }

    public LoggingViewer getMessageViewer() {
        return this.messageViewer;
    }

    public OperatorTree getOperatorTree() {
        return this.mainEditor.getOperatorTree();
    }

    public MainProcessEditor getMainProcessEditor() {
        return this.mainEditor;
    }

    public ResultDisplay getResultDisplay() {
        return this.resultDisplay;
    }

    public int getProcessState() {
        if (this.process == null) {
            return -1;
        }
        return this.process.getProcessState();
    }

    @Deprecated
    public final Process getExperiment() {
        return this.getProcess();
    }

    public final Process getProcess() {
        return this.process;
    }

    public void newProcess() {
        if (this.close()) {
            this.stopProcess();
            this.resultDisplay.clear();
            this.setProcess(new Process(), true);
            this.addToUndoList();
            this.changeMode(0);
        }
    }

    public void runProcess() {
        if (this.getProcessState() == 0) {
            block12: {
                if ((this.isChanged() || this.getProcess().getProcessFile() == null) && !this.isTutorialMode()) {
                    String saveDialogProperty = System.getProperty(PROPERTY_RAPIDMINER_GUI_SAVEDIALOG);
                    boolean showSaveDialog = true;
                    if (saveDialogProperty != null) {
                        showSaveDialog = Tools.booleanValue(saveDialogProperty, true);
                    }
                    if (showSaveDialog) {
                        RequestSaveDialog saveDialog = new RequestSaveDialog("Save Process?", "Save process before start?");
                        saveDialog.setVisible(true);
                        if (saveDialog.shouldNotAskAgain()) {
                            System.setProperty(PROPERTY_RAPIDMINER_GUI_SAVEDIALOG, "false");
                            ParameterService.writePropertyIntoMainUserConfigFile(PROPERTY_RAPIDMINER_GUI_SAVEDIALOG, "false");
                        }
                        if (saveDialog.isOk()) {
                            this.save();
                        }
                    }
                }
                this.process.getRootOperator().clearListeners();
                this.processThread = new ProcessThread(this.process);
                this.process.getRootOperator().addProcessListener(this.statusBar);
                this.enableActions();
                try {
                    try {
                        this.resultDisplay.clear();
                        this.process.removeLoggingListener(this.resultDisplay.getLoggingListener());
                        this.process.addLoggingListener(this.resultDisplay.getLoggingListener());
                        this.processThread.start();
                    }
                    catch (Exception t) {
                        SwingTools.showSimpleErrorMessage("Cannot start process!", t);
                        this.getOperatorTree().refresh();
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    this.getOperatorTree().refresh();
                    throw throwable;
                }
                this.getOperatorTree().refresh();
            }
            this.enableActions();
        } else {
            this.process.resume();
            this.enableActions();
        }
    }

    public void stopProcess() {
        if (this.getProcessState() != 0) {
            this.getProcess().getLog().log("Process stopped. Completing current operator...", 3);
            this.statusBar.setSpecialText("Process stopped. Completing current operator...");
            if (this.processThread != null) {
                if (this.processThread.isAlive()) {
                    this.processThread.setPriority(1);
                    this.processThread.stopProcess();
                }
                this.statusBar.processEnded(this.process);
                this.setProcess((Process)this.process.clone(), false);
                this.enableActions();
            }
        }
    }

    void processEnded(Process process, IOContainer results) {
        if (process.equals(this.process) && results != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MainFrame.this.changeMode(1);
                }
            });
        }
        this.statusBar.processEnded(process);
        process.getRootOperator().clearListeners();
        if (process.equals(this.process)) {
            this.enableActions();
        }
        if (process.equals(this.process) && results != null) {
            this.resultDisplay.setData(results, "Process results:");
            File file = this.process.getProcessFile();
            String resultName = file != null ? file.getName() : "unnamed";
            RapidMinerGUI.getResultHistory().addResults(resultName, this.process.getRootOperator(), results);
        }
    }

    @Deprecated
    public void setExperiment(Process process) {
        this.setProcess(process, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProcess(Process process, boolean newProcess) {
        if (this.getProcessState() != 0 && this.processThread != null) {
            this.processThread.stopProcess();
        }
        Process process2 = process;
        synchronized (process2) {
            this.process = process;
            this.process.getRootOperator().clearListeners();
            this.processThread = new ProcessThread(this.process);
            this.process.addBreakpointListener(this.breakpointListener);
            this.process.addBreakpointListener(this.statusBar);
            this.process.getRootOperator().addProcessListener(this.statusBar);
            if (!newProcess) {
                this.noActualChange = true;
            }
            this.setOperator(this.process.getRootOperator(), newProcess);
            this.noActualChange = false;
            this.enableActions();
        }
        this.setTitle();
    }

    private void setOperator(Operator root, boolean newProcess) {
        this.mainEditor.processChanged(root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processChanged() {
        if (!this.noActualChange) {
            boolean oldValue = this.changed;
            this.changed = true;
            this.addToUndoList();
            if (!oldValue) {
                this.setTitle();
            }
            Process process = this.process;
            synchronized (process) {
                if (this.process.getProcessFile() != null && !this.tutorialMode) {
                    this.SAVE_ACTION_24.setEnabled(true);
                    this.SAVE_ACTION_32.setEnabled(true);
                }
                this.mainEditor.getXMLEditor().processChanged(this.process.getRootOperator());
            }
        }
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void notifyEditorsOfChange(Operator currentlySelected) {
        this.mainEditor.setCurrentOperator(currentlySelected);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToUndoList() {
        String lastStateXML = this.undoList.size() != 0 ? this.undoList.get(this.undoList.size() - 1) : null;
        String currentStateXML = null;
        Process process = this.process;
        synchronized (process) {
            currentStateXML = this.process.getRootOperator().getXML("", true);
        }
        if (!(currentStateXML == null || lastStateXML != null && lastStateXML.equals(currentStateXML))) {
            if (this.undoIndex < this.undoList.size() - 1) {
                while (this.undoList.size() > this.undoIndex + 1) {
                    this.undoList.removeLast();
                }
            }
            this.undoList.add(currentStateXML);
            String maxSizeProperty = System.getProperty(PROPERTY_RAPIDMINER_GUI_UNDOLIST_SIZE);
            int maxSize = 20;
            try {
                if (maxSizeProperty != null) {
                    maxSize = Integer.parseInt(maxSizeProperty);
                }
            }
            catch (NumberFormatException e) {
                LogService.getGlobal().log("Bad integer format for property 'rapidminer.gui.undolist.size', using default size of 20.", 5);
            }
            while (this.undoList.size() > maxSize) {
                this.undoList.removeFirst();
            }
            this.undoIndex = this.undoList.size() - 1;
            this.enableUndoAction();
        }
    }

    public void undo() {
        if (this.undoIndex > 0) {
            --this.undoIndex;
            this.setProcessIntoStateAt(this.undoIndex);
        }
        this.enableUndoAction();
    }

    public void redo() {
        if (this.undoIndex < this.undoList.size()) {
            ++this.undoIndex;
            this.setProcessIntoStateAt(this.undoIndex);
        }
        this.enableUndoAction();
    }

    private void enableUndoAction() {
        if (this.undoIndex > 0) {
            this.UNDO_ACTION_24.setEnabled(true);
            this.UNDO_ACTION_32.setEnabled(true);
        } else {
            this.UNDO_ACTION_24.setEnabled(false);
            this.UNDO_ACTION_32.setEnabled(false);
        }
        if (this.undoIndex < this.undoList.size() - 1) {
            this.REDO_ACTION_24.setEnabled(true);
            this.REDO_ACTION_32.setEnabled(true);
        } else {
            this.REDO_ACTION_24.setEnabled(false);
            this.REDO_ACTION_32.setEnabled(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setProcessIntoStateAt(int undoIndex) {
        String stateXML = this.undoList.get(undoIndex);
        try {
            Process process = this.process;
            synchronized (process) {
                this.process.setupFromXML(stateXML);
                this.setProcess(this.process, true);
                this.changed = true;
                this.setTitle();
                if (this.process.getProcessFile() != null && !this.tutorialMode) {
                    this.SAVE_ACTION_24.setEnabled(true);
                    this.SAVE_ACTION_32.setEnabled(true);
                }
            }
        }
        catch (Exception e) {
            SwingTools.showSimpleErrorMessage("While changing process:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTitle() {
        if (this.hostname == null) {
            try {
                this.hostname = "@" + InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                this.hostname = "";
            }
        }
        File file = null;
        if (this.process != null) {
            Process process = this.process;
            synchronized (process) {
                file = this.process.getProcessFile();
            }
        }
        if (file != null) {
            this.setTitle(TITLE + this.hostname + " (" + file.getName() + (this.changed ? "*" : "") + ")");
        } else {
            this.setTitle(TITLE + this.hostname);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBaseName() {
        if (this.process != null) {
            File file = null;
            Process process = this.process;
            synchronized (process) {
                file = this.process.getProcessFile();
            }
            if (file != null) {
                String base = file.getName();
                int dot = base.lastIndexOf(".");
                if (dot == -1) {
                    return base;
                }
                return base.substring(0, dot);
            }
            return "unnamed";
        }
        return "unnamed";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean close() {
        if (this.changed) {
            File file = null;
            Process process = this.process;
            synchronized (process) {
                file = this.process.getProcessFile();
            }
            if (file == null) {
                file = new File("unnamed.xml");
            }
            int choice = JOptionPane.showConfirmDialog(this, "Save changes to '" + file + "'?", "Save changes", 1);
            switch (choice) {
                case 0: {
                    this.save();
                    return true;
                }
                case 1: {
                    if (this.getProcessState() != 0) {
                        ProcessThread processThread = this.processThread;
                        synchronized (processThread) {
                            this.processThread.stopProcess();
                        }
                    }
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public void open() {
        if (this.close()) {
            File file = SwingTools.chooseFile((Component)this, null, true, "xml", "process file");
            if (file == null) {
                return;
            }
            this.open(file);
        }
    }

    public void open(File file) {
        this.open(file, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(File file, boolean showInfo) {
        this.stopProcess();
        try {
            Process process = RapidMiner.readProcessFile(file);
            this.setProcess(process, true);
            this.changeMode(0);
        }
        catch (XMLException ex) {
            SwingTools.showSimpleErrorMessage("While loading '" + file + "'", ex);
            Process process = new Process();
            process.setProcessFile(file);
            this.setProcess(process, true);
            this.changeMode(0);
            this.mainEditor.changeToXMLEditor();
            try {
                this.mainEditor.getXMLEditor().setText(Tools.readOutput(new BufferedReader(new FileReader(file))));
            }
            catch (FileNotFoundException e) {
                SwingTools.showSimpleErrorMessage("While loading '" + file + "'", e);
                return;
            }
            catch (IOException e) {
                SwingTools.showSimpleErrorMessage("While loading '" + file + "'", e);
                return;
            }
        }
        catch (InstantiationException e) {
            SwingTools.showSimpleErrorMessage("While loading '" + file + "'", e);
            return;
        }
        catch (IllegalAccessException e) {
            SwingTools.showSimpleErrorMessage("While loading '" + file + "'", e);
            return;
        }
        catch (IOException e) {
            SwingTools.showSimpleErrorMessage("While loading '" + file + "'", e);
            return;
        }
        this.resultDisplay.clear();
        this.SAVE_ACTION_24.setEnabled(false);
        this.SAVE_ACTION_32.setEnabled(false);
        this.changed = false;
        Process process = this.process;
        synchronized (process) {
            String text;
            RapidMinerGUI.useProcessFile(this.process);
            this.updateRecentFileList();
            this.addToUndoList();
            this.setTitle();
            List<UnknownParameterInformation> unknownParameters = this.process.getUnknownParameters();
            if (unknownParameters.size() > 0) {
                new UnknownParametersInfoDialog((Frame)this, unknownParameters).setVisible(true);
            } else if (showInfo && Tools.booleanValue(System.getProperty(PROPERTY_RAPIDMINER_GUI_PROCESSINFO_SHOW), true) && (text = this.process.getRootOperator().getUserDescription()) != null && text.length() != 0) {
                ProcessInfoScreen infoScreen = new ProcessInfoScreen((Frame)this, file.getName(), text);
                infoScreen.setVisible(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        try {
            Process process = this.process;
            synchronized (process) {
                File file = this.process.getProcessFile();
                if (file == null) {
                    file = SwingTools.chooseFile((Component)this, new File("."), false, "xml", "process file");
                    if (file == null) {
                        return;
                    }
                    this.process.setProcessFile(file);
                }
                this.process.save();
                this.SAVE_ACTION_24.setEnabled(false);
                this.SAVE_ACTION_32.setEnabled(false);
                this.changed = false;
                this.setTitle();
                RapidMinerGUI.useProcessFile(this.process);
                this.updateRecentFileList();
            }
        }
        catch (IOException ex) {
            SwingTools.showSimpleErrorMessage("Cannot save process file!", ex);
        }
    }

    public void saveAs() {
        File file = SwingTools.chooseFile((Component)this, null, false, "xml", "process file");
        if (file != null) {
            this.getProcess().setProcessFile(file);
            this.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAsTemplate() {
        Process process = this.process;
        synchronized (process) {
            ProcessRootOperator rootOperator = this.process.getRootOperator();
            SaveAsTemplateDialog dialog = new SaveAsTemplateDialog(this, rootOperator);
            dialog.setVisible(true);
            if (dialog.isOk()) {
                Template template = dialog.getTemplate(rootOperator);
                String name = template.getName();
                try {
                    File templateFile = ParameterService.getUserConfigFile(String.valueOf(name) + ".template");
                    template.save(templateFile);
                    File templateXmlFile = ParameterService.getUserConfigFile(String.valueOf(name) + ".xml");
                    this.process.save(templateXmlFile);
                }
                catch (IOException ioe) {
                    SwingTools.showSimpleErrorMessage("Cannot write template files:", ioe);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit() {
        block11: {
            block10: {
                if (!this.changed) break block10;
                File file = null;
                Process process = this.process;
                synchronized (process) {
                    file = this.process.getProcessFile();
                }
                if (file == null) {
                    file = new File("unnamed.xml");
                }
                switch (JOptionPane.showConfirmDialog(this, "Save changes to '" + file + "'?", "Save changes", 1)) {
                    case 0: {
                        this.save();
                        if (this.changed) {
                            return;
                        }
                        break block11;
                    }
                    case 1: {
                        break block11;
                    }
                    default: {
                        return;
                    }
                }
            }
            if (JOptionPane.showConfirmDialog(this, "Really exit?", "Exit RapidMiner", 0) != 0) {
                return;
            }
        }
        this.stopProcess();
        this.dispose();
        RapidMinerGUI.quit(0);
    }

    public void updateRecentFileList() {
        this.recentFilesMenu.removeAll();
        List<File> recentFiles = RapidMinerGUI.getRecentFiles();
        Iterator<File> i = recentFiles.iterator();
        int j = 1;
        while (i.hasNext()) {
            final File recentFile = i.next();
            JMenuItem menuItem = new JMenuItem(String.valueOf(j) + " " + recentFile.getPath());
            menuItem.setMnemonic(48 + j);
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.open(recentFile);
                }
            });
            this.recentFilesMenu.add(menuItem);
            ++j;
        }
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.exit();
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void enableActions() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.enableActionsNow();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MainFrame.this.enableActionsNow();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableActionsNow() {
        Process process = this.process;
        synchronized (process) {
            this.RUN_RESUME_ACTION_24.updateState();
            this.RUN_RESUME_ACTION_32.updateState();
            boolean[] currentStates = new boolean[10];
            Operator op = this.mainEditor.getOperatorTree().getSelectedOperator();
            if (op != null) {
                currentStates[0] = true;
                if (op instanceof OperatorChain) {
                    currentStates[1] = true;
                }
                if (op.getParent() == null) {
                    currentStates[2] = true;
                } else if (op.getParent().getNumberOfOperators() > 1) {
                    currentStates[3] = true;
                }
            }
            currentStates[5] = this.getProcessState() == 0;
            currentStates[6] = this.getProcessState() == 1;
            currentStates[7] = this.getProcessState() == 2 || this.getProcessState() == 1;
            currentStates[4] = this.mainEditor.getOperatorTree().getClipBoard() != null;
            currentStates[8] = this.mainEditor.isXMLViewActive();
            currentStates[9] = this.mainEditor.isDescriptionViewActive();
            ConditionalAction.updateAll(currentStates);
        }
    }

    public void removeMenu(int index) {
        this.menuBar.remove(this.menuBar.getMenu(index));
    }

    public void removeMenuItem(int menuIndex, int itemIndex) {
        this.menuBar.getMenu(menuIndex).remove(itemIndex);
    }

    public void addMenuItem(int menuIndex, int itemIndex, JMenuItem item) {
        this.menuBar.getMenu(menuIndex).add((Component)item, itemIndex);
    }

    public void addMenu(int menuIndex, JMenu menu) {
        this.menuBar.add((Component)menu, menuIndex);
    }

    public void addMenuSeparator(int menuIndex) {
        this.menuBar.getMenu(menuIndex).addSeparator();
    }
}

