/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.ExampleTable;
import com.rapidminer.generator.FeatureGenerator;
import com.rapidminer.generator.GenerationException;
import com.rapidminer.tools.LoggingHandler;
import com.rapidminer.tools.math.function.ExpressionParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeParser {
    public void generateAll(LoggingHandler logging, ExampleSet exampleSet, InputStream in) throws IOException, GenerationException {
        Document document = null;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(in);
        }
        catch (SAXException e1) {
            throw new IOException(e1.getMessage());
        }
        catch (ParserConfigurationException e1) {
            throw new IOException(e1.getMessage());
        }
        Element constructionsElement = document.getDocumentElement();
        if (!constructionsElement.getTagName().equals("constructions")) {
            throw new IOException("Outer tag of attribute constructions file must be <constructions>");
        }
        NodeList constructions = constructionsElement.getChildNodes();
        int i = 0;
        while (i < constructions.getLength()) {
            Node node = constructions.item(i);
            if (node instanceof Element) {
                Element constructionTag = (Element)node;
                String tagName = constructionTag.getTagName();
                if (!tagName.equals("attribute")) {
                    throw new IOException("Only tags <attribute> are allowed, was " + tagName);
                }
                String attributeName = constructionTag.getAttribute("name");
                String attributeString = constructionTag.getAttribute("construction");
                try {
                    Attribute att = this.generateAttribute(logging, attributeString, exampleSet.getExampleTable());
                    if (att != null) {
                        if (attributeName != null) {
                            att.setName(attributeName);
                        }
                        exampleSet.getAttributes().addRegular(att);
                    }
                }
                catch (Exception e) {
                    ExpressionParser parser = new ExpressionParser(true);
                    parser.addAttribute(exampleSet, attributeName, attributeString);
                }
            }
            ++i;
        }
    }

    public Attribute generateAttribute(LoggingHandler logging, String constructionDescription, ExampleTable table) throws GenerationException {
        LinkedList<Construction> toConstruct = new LinkedList<Construction>();
        this.parseAttributes(constructionDescription, toConstruct);
        return this.generate(logging, toConstruct, table);
    }

    private static int getClosingBracketIndex(String string, int startIndex) throws GenerationException {
        int nextClosing;
        int openCount = 1;
        do {
            int nextOpen = string.indexOf("(", startIndex + 1);
            nextClosing = string.indexOf(")", startIndex + 1);
            if (nextClosing == -1) {
                throw new GenerationException("Malformed attribute description: mismatched parantheses");
            }
            if (nextOpen != -1 && nextOpen < nextClosing) {
                ++openCount;
                startIndex = nextOpen;
                continue;
            }
            --openCount;
            startIndex = nextClosing;
        } while (openCount != 0);
        return nextClosing;
    }

    private List<Construction> parseAttributes(String constructionString, Queue<Construction> toConstruct) throws GenerationException {
        int start = 0;
        LinkedList<Construction> constructedList = new LinkedList<Construction>();
        while (start < constructionString.length()) {
            String name;
            int end;
            int leftBr = constructionString.indexOf("(", start);
            int comma = constructionString.indexOf(",", start);
            if (comma == -1 && leftBr == -1) {
                end = constructionString.length();
                name = constructionString.substring(start, end).trim();
                if (name.startsWith("const")) {
                    throw new GenerationException("The function name 'const' must be used with empty arguments, for example 'const[5]()'!");
                }
                toConstruct.add(new Construction(name));
                constructedList.add(toConstruct.peek());
                start = constructionString.length();
                continue;
            }
            if (leftBr == -1 || comma < leftBr && comma != -1) {
                end = comma;
                name = constructionString.substring(start, end).trim();
                if (name.startsWith("const")) {
                    throw new GenerationException("The function name 'const' must be used with empty arguments, for example 'const[5]()'!");
                }
                toConstruct.add(new Construction(name));
                constructedList.add(toConstruct.peek());
                start = end + 1;
                continue;
            }
            int rightBr = AttributeParser.getClosingBracketIndex(constructionString, leftBr);
            String functionName = constructionString.substring(start, leftBr).trim();
            List<Construction> argumentList = this.parseAttributes(constructionString.substring(leftBr + 1, rightBr).trim(), toConstruct);
            Construction[] argumentDescriptions = new Construction[argumentList.size()];
            int i = 0;
            while (i < argumentDescriptions.length) {
                argumentDescriptions[i] = argumentList.get(i);
                ++i;
            }
            Construction generated = new Construction(functionName, argumentDescriptions);
            toConstruct.add(generated);
            constructedList.add(generated);
            start = constructionString.indexOf(",", rightBr) + 1;
            if (start > 0) continue;
            start = constructionString.length();
        }
        return constructedList;
    }

    private Attribute findInTable(String constructionDescription, ExampleTable table) {
        int i = 0;
        while (i < table.getNumberOfAttributes()) {
            Attribute a = table.getAttribute(i);
            if (a != null && a.getConstruction().equals(constructionDescription)) {
                return a;
            }
            ++i;
        }
        return null;
    }

    private Attribute generate(LoggingHandler logging, Queue<Construction> toConstruct, ExampleTable table) throws GenerationException {
        LinkedList<Attribute> allGeneratedAttributes = new LinkedList<Attribute>();
        Attribute currentAttribute = null;
        Stack<Attribute> resultStack = new Stack<Attribute>();
        while (toConstruct.size() > 0) {
            Construction construction = toConstruct.remove();
            if (construction.getNumberOfArguments() == 0) {
                FeatureGenerator generator = FeatureGenerator.createGeneratorForFunction(construction.getFunction());
                if (generator == null) {
                    Attribute attribute = this.findInTable(construction.getFunction(), table);
                    if (attribute == null) {
                        throw new GenerationException("No such attribute: " + construction.getFunction());
                    }
                    resultStack.push(attribute);
                    continue;
                }
                LinkedList<FeatureGenerator> generatorList = new LinkedList<FeatureGenerator>();
                generatorList.add(generator);
                List<Attribute> currentResultList = FeatureGenerator.generateAll(table, generatorList);
                currentAttribute = currentResultList.get(0);
                resultStack.push(currentAttribute);
                if (toConstruct.size() <= 0) continue;
                allGeneratedAttributes.add(currentAttribute);
                continue;
            }
            int numberOfArguments = construction.getNumberOfArguments();
            Attribute[] inputAttributes = new Attribute[numberOfArguments];
            int i = 0;
            while (i < numberOfArguments) {
                inputAttributes[inputAttributes.length - 1 - i] = (Attribute)resultStack.pop();
                ++i;
            }
            FeatureGenerator generator = FeatureGenerator.createGeneratorForFunction(construction.getFunction());
            generator.setArguments(inputAttributes);
            LinkedList<FeatureGenerator> generatorList = new LinkedList<FeatureGenerator>();
            generatorList.add(generator);
            List<Attribute> currentResultList = FeatureGenerator.generateAll(table, generatorList);
            currentAttribute = currentResultList.get(0);
            resultStack.push(currentAttribute);
            if (toConstruct.size() <= 0) continue;
            allGeneratedAttributes.add(currentAttribute);
        }
        for (Attribute attribute : allGeneratedAttributes) {
            table.removeAttribute(attribute);
        }
        return currentAttribute;
    }

    private static class Construction {
        String function;
        Construction[] arguments;

        public Construction(String function) {
            this.function = function;
        }

        public Construction(String function, Construction[] arguments) {
            this.function = function;
            this.arguments = arguments;
        }

        public int getNumberOfArguments() {
            if (this.arguments == null) {
                return 0;
            }
            return this.arguments.length;
        }

        public Construction getArgument(int i) {
            return this.arguments[i];
        }

        public String getFunction() {
            return this.function;
        }

        public String toString() {
            if (this.arguments == null) {
                return this.function;
            }
            StringBuffer result = new StringBuffer(String.valueOf(this.function) + "(");
            boolean first = true;
            Construction[] constructionArray = this.arguments;
            int n = this.arguments.length;
            int n2 = 0;
            while (n2 < n) {
                Construction construction = constructionArray[n2];
                if (!first) {
                    result.append(", ");
                }
                result.append(construction.toString());
                first = false;
                ++n2;
            }
            result.append(")");
            return result.toString();
        }
    }
}

