/*
 * Decompiled with CFR 0.152.
 */
package marytts.unitselection.select.viterbi;

import marytts.unitselection.data.Unit;
import marytts.unitselection.select.Target;
import marytts.unitselection.select.TargetCostFunction;
import marytts.unitselection.select.viterbi.ViterbiPath;

public class ViterbiCandidate
implements Comparable<ViterbiCandidate> {
    final Target target;
    final Unit unit;
    final double targetCost;
    ViterbiPath bestPath = null;
    ViterbiCandidate next = null;

    public ViterbiCandidate(Target target, Unit unit, TargetCostFunction tcf) {
        this.target = target;
        this.unit = unit;
        this.targetCost = tcf.cost(target, unit);
    }

    public double getTargetCost() {
        return this.targetCost;
    }

    public ViterbiCandidate getNext() {
        return this.next;
    }

    public void setNext(ViterbiCandidate next) {
        this.next = next;
    }

    public Target getTarget() {
        return this.target;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setBestPath(ViterbiPath bestPath) {
        this.bestPath = bestPath;
    }

    public ViterbiPath getBestPath() {
        return this.bestPath;
    }

    public String toString() {
        return "ViterbiCandidate: target " + this.target + ", unit " + this.unit + (this.bestPath != null ? ", best path score " + this.bestPath.score : ", no best path");
    }

    @Override
    public int compareTo(ViterbiCandidate o) {
        if (this.targetCost < o.targetCost) {
            return -1;
        }
        if (this.targetCost > o.targetCost) {
            return 1;
        }
        return 0;
    }
}

