/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.analysis.distance;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import marytts.signalproc.adaptation.BaselineAdaptationItem;
import marytts.signalproc.adaptation.BaselineAdaptationSet;
import marytts.signalproc.analysis.Labels;
import marytts.signalproc.analysis.distance.BaselineDistortionComputer;
import marytts.signalproc.analysis.distance.ComparativeStatisticsItem;
import marytts.util.data.AlignLabelsUtils;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.math.MathUtils;
import marytts.util.signal.SignalProcUtils;
import marytts.util.string.StringUtils;

public class BaselineLPSpectralEnvelopeDistortionComputer
extends BaselineDistortionComputer {
    public static final double DEFAULT_WINDOWSIZE = 0.02;
    public static final double DEFAULT_SKIPSIZE = 0.01;
    public static final int DEFAULT_FFTSIZE = -1;
    public static final int DEFAULT_LPORDER = -1;

    public double[] getDistances(String folder1, String folder2) throws IOException {
        return this.getDistances(folder1, folder2, 0.02);
    }

    public double[] getDistances(String folder1, String folder2, double winSizeInSeconds) throws IOException {
        return this.getDistances(folder1, folder2, winSizeInSeconds, 0.01);
    }

    public double[] getDistances(String folder1, String folder2, double winSizeInSeconds, double skipSizeInSeconds) throws IOException {
        return this.getDistances(folder1, folder2, winSizeInSeconds, skipSizeInSeconds, -1);
    }

    public double[] getDistances(String folder1, String folder2, double winSizeInSeconds, double skipSizeInSeconds, int fftSize) throws IOException {
        return this.getDistances(folder1, folder2, winSizeInSeconds, skipSizeInSeconds, fftSize, -1);
    }

    public double[] getDistances(String folder1, String folder2, double winSizeInSeconds, double skipSizeInSeconds, int fftSize, int lpOrder) throws IOException {
        folder1 = StringUtils.checkLastSlash(folder1);
        folder2 = StringUtils.checkLastSlash(folder2);
        BaselineAdaptationSet set1 = new BaselineAdaptationSet(folder1, ".wav");
        BaselineAdaptationSet set2 = new BaselineAdaptationSet(folder2, ".wav");
        return this.getDistances(set1, set2, winSizeInSeconds, skipSizeInSeconds, fftSize, lpOrder);
    }

    public double[] getDistances(BaselineAdaptationSet set1, BaselineAdaptationSet set2) throws IOException {
        return this.getDistances(set1, set2, 0.02);
    }

    public double[] getDistances(BaselineAdaptationSet set1, BaselineAdaptationSet set2, double winSizeInSeconds) throws IOException {
        return this.getDistances(set1, set2, winSizeInSeconds, 0.01);
    }

    public double[] getDistances(BaselineAdaptationSet set1, BaselineAdaptationSet set2, double winSizeInSeconds, double skipSizeInSeconds) throws IOException {
        return this.getDistances(set1, set2, winSizeInSeconds, skipSizeInSeconds, -1);
    }

    public double[] getDistances(BaselineAdaptationSet set1, BaselineAdaptationSet set2, double winSizeInSeconds, double skipSizeInSeconds, int fftSize) throws IOException {
        return this.getDistances(set1, set2, winSizeInSeconds, skipSizeInSeconds, fftSize, -1);
    }

    public double[] getDistances(BaselineAdaptationSet set1, BaselineAdaptationSet set2, double winSizeInSeconds, double skipSizeInSeconds, int fftSize, int lpOrder) throws IOException {
        int[] map = new int[Math.min(set1.items.length, set2.items.length)];
        for (int i = 0; i < map.length; ++i) {
            map[i] = i;
        }
        return this.getDistances(set1, set2, winSizeInSeconds, skipSizeInSeconds, fftSize, lpOrder, map);
    }

    public double[] getDistances(BaselineAdaptationSet set1, BaselineAdaptationSet set2, double winSizeInSeconds, double skipSizeInSeconds, int fftSize, int lpOrder, int[] map) throws IOException {
        double[] distances = null;
        double[] tmpDistances = null;
        for (int i = 0; i < map.length; ++i) {
            double[] itemDistances = this.getItemDistances(set1.items[i], set2.items[map[i]], winSizeInSeconds, skipSizeInSeconds, fftSize, lpOrder);
            if (distances != null && itemDistances != null) {
                tmpDistances = new double[distances.length];
                System.arraycopy(distances, 0, tmpDistances, 0, distances.length);
                distances = new double[tmpDistances.length + itemDistances.length];
                System.arraycopy(tmpDistances, 0, distances, 0, tmpDistances.length);
                System.arraycopy(itemDistances, 0, distances, tmpDistances.length, itemDistances.length);
                continue;
            }
            distances = new double[itemDistances.length];
            System.arraycopy(itemDistances, 0, distances, 0, itemDistances.length);
        }
        return distances;
    }

    public double[] getItemDistances(BaselineAdaptationItem item1, BaselineAdaptationItem item2, double winSizeInSeconds, double skipSizeInSeconds) throws IOException {
        return this.getItemDistances(item1, item2, winSizeInSeconds, skipSizeInSeconds, -1);
    }

    public double[] getItemDistances(BaselineAdaptationItem item1, BaselineAdaptationItem item2, double winSizeInSeconds, double skipSizeInSeconds, int fftSize) throws IOException {
        return this.getItemDistances(item1, item2, winSizeInSeconds, skipSizeInSeconds, fftSize, -1);
    }

    public double[] getItemDistances(BaselineAdaptationItem item1, BaselineAdaptationItem item2, double winSizeInSeconds, double skipSizeInSeconds, int fftSize, int lpOrder) throws IOException {
        int[][] labelMap;
        int i;
        AudioInputStream inputAudio2;
        AudioInputStream inputAudio1;
        double[] frameDistances = null;
        try {
            inputAudio1 = AudioSystem.getAudioInputStream(new File(item1.audioFile));
            inputAudio2 = AudioSystem.getAudioInputStream(new File(item2.audioFile));
        }
        catch (UnsupportedAudioFileException e) {
            throw new IOException("Cannot open audio file", e);
        }
        int samplingRate1 = (int)inputAudio1.getFormat().getSampleRate();
        int ws1 = (int)Math.floor(winSizeInSeconds * (double)samplingRate1 + 0.5);
        int ss1 = (int)Math.floor(skipSizeInSeconds * (double)samplingRate1 + 0.5);
        AudioDoubleDataSource signal1 = new AudioDoubleDataSource(inputAudio1);
        double[] x1 = signal1.getAllData();
        double[] frm1 = new double[ws1];
        int numfrm1 = (int)Math.floor((double)(x1.length - ws1) / (double)ss1 + 0.5);
        double max1 = MathUtils.absMax(x1);
        for (i = 0; i < x1.length; ++i) {
            x1[i] = x1[i] / max1 * 20000.0;
        }
        int samplingRate2 = (int)inputAudio2.getFormat().getSampleRate();
        int ws2 = (int)Math.floor(winSizeInSeconds * (double)samplingRate2 + 0.5);
        int ss2 = (int)Math.floor(skipSizeInSeconds * (double)samplingRate2 + 0.5);
        AudioDoubleDataSource signal2 = new AudioDoubleDataSource(inputAudio2);
        double[] x2 = signal2.getAllData();
        double[] frm2 = new double[ws2];
        int numfrm2 = (int)Math.floor((double)(x2.length - ws2) / (double)ss2 + 0.5);
        double max2 = MathUtils.absMax(x2);
        for (i = 0; i < x2.length; ++i) {
            x2[i] = x2[i] / max2 * 20000.0;
        }
        if (fftSize < 0) {
            for (fftSize = Math.max(SignalProcUtils.getDFTSize(samplingRate1), SignalProcUtils.getDFTSize(samplingRate2)); fftSize < ws1; fftSize *= 2) {
            }
            while (fftSize < ws2) {
                fftSize *= 2;
            }
        }
        if (lpOrder < 0) {
            lpOrder = Math.max(SignalProcUtils.getLPOrder(samplingRate1), SignalProcUtils.getLPOrder(samplingRate2));
        }
        Labels labs1 = new Labels(item1.labelFile);
        Labels labs2 = new Labels(item2.labelFile);
        int count = 0;
        if (labs1.items != null && labs2.items != null && (labelMap = AlignLabelsUtils.alignLabels(labs1.items, labs2.items)) != null) {
            Object tmpLsfs1 = null;
            Object tmpLsfs2 = null;
            int labInd1 = 0;
            frameDistances = new double[numfrm1];
            for (int j = 0; j < numfrm1; ++j) {
                int labInd2;
                double time1 = SignalProcUtils.frameIndex2Time(j, winSizeInSeconds, skipSizeInSeconds);
                while (time1 > labs1.items[labInd1].time) {
                    if (++labInd1 <= labs1.items.length - 1) continue;
                    labInd1 = labs1.items.length - 1;
                    break;
                }
                if (labInd1 > 0 && labInd1 < labs1.items.length - 1 && (labInd2 = StringUtils.findInMap(labelMap, labInd1)) >= 0 && labs1.items[labInd1].phn.compareTo(labs2.items[labInd2].phn) == 0) {
                    double endTime2;
                    double startTime2;
                    double endTime1;
                    double startTime1 = labInd1 > 0 ? labs1.items[labInd1 - 1].time : 0.0;
                    double time2 = MathUtils.linearMap(time1, startTime1, endTime1 = labs1.items[labInd1].time, startTime2 = labInd2 > 0 ? labs2.items[labInd2 - 1].time : 0.0, endTime2 = labs2.items[labInd2].time);
                    int frmInd2 = SignalProcUtils.time2frameIndex(time2, winSizeInSeconds, skipSizeInSeconds);
                    if (frmInd2 < 0) {
                        frmInd2 = 0;
                    }
                    if (frmInd2 > numfrm2 - 1) {
                        frmInd2 = numfrm2 - 1;
                    }
                    int x1Start = (int)Math.floor((double)(j * ss1) + 0.5 * (double)ws1 + 0.5);
                    int x2Start = (int)Math.floor((double)(frmInd2 * ss2) + 0.5 * (double)ws2 + 0.5);
                    if (x1Start + ws1 < x1.length) {
                        System.arraycopy(x1, x1Start, frm1, 0, ws1);
                    } else {
                        Arrays.fill(frm1, 0.0);
                        System.arraycopy(x1, x1Start, frm1, 0, x1.length - x1Start);
                    }
                    if (x2Start + ws2 < x2.length) {
                        System.arraycopy(x2, x2Start, frm2, 0, ws2);
                    } else {
                        Arrays.fill(frm2, 0.0);
                        System.arraycopy(x2, x2Start, frm2, 0, x2.length - x2Start);
                    }
                    SignalProcUtils.addWhiteNoise(frm1, 1.0E-10);
                    SignalProcUtils.addWhiteNoise(frm2, 1.0E-10);
                    frameDistances[count] = this.frameDistance(frm1, frm2, fftSize, lpOrder);
                    ++count;
                }
                if (count >= frameDistances.length) break;
            }
        }
        if (count > 0) {
            double[] tmpFrameDistances = new double[count];
            System.arraycopy(frameDistances, 0, tmpFrameDistances, 0, count);
            frameDistances = new double[count];
            System.arraycopy(tmpFrameDistances, 0, frameDistances, 0, count);
        }
        return frameDistances;
    }

    public double frameDistance(double[] frm1, double[] frm2, int fftSize, int lpOrder) {
        return 1.0;
    }

    public void mainParametric(String srcFolder, String tgtFolder, String tfmFolder, String outputFile, String infoString) throws IOException {
        double[] distances1 = this.getDistances(tgtFolder, srcFolder);
        double[] distances2 = this.getDistances(tgtFolder, tfmFolder);
        ComparativeStatisticsItem stats = new ComparativeStatisticsItem(distances1, distances2);
        stats.writeToTextFile(outputFile);
        System.out.println(infoString + " reference-method1: MeanDist=" + String.valueOf(stats.referenceVsMethod1.mean) + " " + "StdDist=" + String.valueOf(stats.referenceVsMethod1.std));
        System.out.println(infoString + " reference-method2: MeanDist=" + String.valueOf(stats.referenceVsMethod2.mean) + " " + "StdDist=" + String.valueOf(stats.referenceVsMethod2.std));
        System.out.println(infoString + " distance reduction=" + String.valueOf(stats.referenceVsMethod1.mean - stats.referenceVsMethod2.mean));
    }
}

