/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.analysis;

import java.util.Arrays;
import marytts.signalproc.analysis.FrameBasedAnalyser;
import marytts.signalproc.window.Window;
import marytts.util.data.DoubleDataSource;
import marytts.util.math.FFT;
import marytts.util.math.MathUtils;

public class ShortTermSpectrumAnalyser
extends FrameBasedAnalyser<double[]> {
    protected double[] real;

    public ShortTermSpectrumAnalyser(DoubleDataSource signal, int fftSize, Window window, int frameShift, int samplingRate) {
        super(signal, window, frameShift, samplingRate);
        if (window.getLength() > fftSize) {
            throw new IllegalArgumentException("Window must not be longer than fftSize");
        }
        if (!MathUtils.isPowerOfTwo(fftSize)) {
            throw new IllegalArgumentException("fftSize must be a power of two!");
        }
        this.real = new double[fftSize];
        assert (this.real.length >= this.frame.length);
    }

    @Override
    public double[] analyse(double[] frame) {
        if (frame.length != this.getFrameLengthSamples()) {
            throw new IllegalArgumentException("Expected frame of length " + this.getFrameLengthSamples() + ", got " + frame.length);
        }
        System.arraycopy(frame, 0, this.real, 0, frame.length);
        if (this.real.length > frame.length) {
            Arrays.fill(this.real, frame.length, this.real.length, 0.0);
        }
        FFT.realTransform(this.real, false);
        return FFT.computePowerSpectrum_FD(this.real);
    }

    public double getFrequencyResolution() {
        return (double)this.samplingRate / (double)this.real.length;
    }

    public int getFFTWindowLength() {
        return this.real.length;
    }
}

