/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.analysis;

import java.util.Arrays;
import marytts.signalproc.analysis.FrameBasedAnalyser;
import marytts.signalproc.window.Window;
import marytts.util.data.DoubleDataSource;
import marytts.util.math.FFT;
import marytts.util.math.MathUtils;

public class ShortTermCepstrumAnalyser
extends FrameBasedAnalyser<double[]> {
    int fftSize;
    int invFftSize;
    double frequencyResolution;
    double quefrencyResolution;

    public ShortTermCepstrumAnalyser(DoubleDataSource signal, int fftSize, int invFftSize, Window window, int frameShift, int samplingRate) {
        super(signal, window, frameShift, samplingRate);
        if (window.getLength() > fftSize) {
            throw new IllegalArgumentException("Window must not be longer than fftSize");
        }
        if (!MathUtils.isPowerOfTwo(fftSize)) {
            throw new IllegalArgumentException("fftSize must be a power of two!");
        }
        if (!MathUtils.isPowerOfTwo(invFftSize)) {
            throw new IllegalArgumentException("invFftSize must be a power of two!");
        }
        this.fftSize = fftSize;
        this.invFftSize = invFftSize;
        assert (fftSize >= this.frame.length);
        this.frequencyResolution = (double)samplingRate / (double)fftSize;
        this.quefrencyResolution = (double)fftSize / ((double)samplingRate * (double)invFftSize);
    }

    @Override
    public double[] analyse(double[] aFrame) {
        int i;
        double[] invImag;
        double[] invReal;
        if (aFrame.length != this.frameLength) {
            throw new IllegalArgumentException("Expected frame of length " + this.frameLength + ", got " + aFrame.length);
        }
        double[] real = new double[this.fftSize];
        double[] imag = new double[this.fftSize];
        System.arraycopy(aFrame, 0, real, 0, aFrame.length);
        FFT.transform(real, imag, false);
        MathUtils.toPolarCoordinates(real, imag);
        real = MathUtils.log(real);
        Arrays.fill(imag, 0.0);
        double b = 5000.0;
        int bIndex = (int)(b / this.frequencyResolution);
        if (this.invFftSize == this.fftSize) {
            invReal = real;
            invImag = imag;
        } else {
            invReal = new double[this.invFftSize];
            System.arraycopy(real, 0, invReal, 0, bIndex + 1);
            invImag = new double[this.invFftSize];
        }
        for (i = bIndex + 1; i < this.invFftSize / 2; ++i) {
            invReal[i] = invReal[bIndex];
        }
        for (i = 0; i < this.invFftSize / 2; ++i) {
            invReal[this.invFftSize - i - 1] = invReal[i];
        }
        FFT.transform(invReal, invImag, true);
        return invReal;
    }

    public double getQuefrencyResolution() {
        return this.quefrencyResolution;
    }

    public int getFFTWindowLength() {
        return this.fftSize;
    }

    public int getInverseFFTWindowLength() {
        return this.invFftSize;
    }
}

