/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.analysis;

import java.io.IOException;
import marytts.util.io.MaryRandomAccessFile;

public class EnergyFileHeader {
    public int samplingRate;
    public double windowSizeInSeconds;
    public double skipSizeInSeconds;
    public int totalFrames;
    public static final double DEFAULT_WINDOW_SIZE = 0.02;
    public static final double DEFAULT_SKIP_SIZE = 0.01;

    public EnergyFileHeader(EnergyFileHeader existing) {
        this.samplingRate = existing.samplingRate;
        this.windowSizeInSeconds = existing.windowSizeInSeconds;
        this.skipSizeInSeconds = existing.skipSizeInSeconds;
        this.totalFrames = existing.totalFrames;
    }

    public EnergyFileHeader() {
        this(0);
    }

    public EnergyFileHeader(int samplingRateIn) {
        this(samplingRateIn, 0.02);
    }

    public EnergyFileHeader(int samplingRateIn, double windowSizeInSecondsIn) {
        this(samplingRateIn, windowSizeInSecondsIn, 0.01);
    }

    public EnergyFileHeader(int samplingRateIn, double windowSizeInSecondsIn, double skipSizeInSecondsIn) {
        this(samplingRateIn, windowSizeInSecondsIn, skipSizeInSecondsIn, 0);
    }

    public EnergyFileHeader(int samplingRateIn, double windowSizeInSecondsIn, double skipSizeInSecondsIn, int totalFramesIn) {
        this.samplingRate = samplingRateIn;
        this.windowSizeInSeconds = windowSizeInSecondsIn;
        this.skipSizeInSeconds = skipSizeInSecondsIn;
        this.totalFrames = totalFramesIn;
    }

    public void write(MaryRandomAccessFile ler) throws IOException {
        ler.writeInt(this.samplingRate);
        ler.writeDouble(this.windowSizeInSeconds);
        ler.writeDouble(this.skipSizeInSeconds);
        ler.writeInt(this.totalFrames);
    }

    public void read(MaryRandomAccessFile ler) throws IOException {
        this.read(ler, false);
    }

    public void read(MaryRandomAccessFile ler, boolean bLeaveOpen) throws IOException {
        this.samplingRate = ler.readInt();
        this.windowSizeInSeconds = ler.readDouble();
        this.skipSizeInSeconds = ler.readDouble();
        this.totalFrames = ler.readInt();
        if (!bLeaveOpen) {
            ler.close();
        }
    }
}

