/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.analysis;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import marytts.signalproc.analysis.EnergyFileHeader;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.io.MaryRandomAccessFile;
import marytts.util.signal.SignalProcUtils;

public class EnergyContourRms {
    public EnergyFileHeader header = new EnergyFileHeader();
    public double[] contour;

    public EnergyContourRms() throws IOException {
        this(null);
    }

    public EnergyContourRms(String wavFile) throws IOException {
        this(wavFile, null);
    }

    public EnergyContourRms(String wavFile, String energyFile) throws IOException {
        this(wavFile, energyFile, 0.02, 0.01);
    }

    public EnergyContourRms(String wavFileIn, double windowSizeInSecondsIn, double skipSizeInSecondsIn) throws IOException {
        this(wavFileIn, null, windowSizeInSecondsIn, skipSizeInSecondsIn);
    }

    public EnergyContourRms(String wavFileIn, String energyFileOut, double windowSizeInSecondsIn, double skipSizeInSecondsIn) throws IOException {
        this.header.windowSizeInSeconds = windowSizeInSecondsIn;
        this.header.skipSizeInSeconds = skipSizeInSecondsIn;
        if (wavFileIn != null) {
            AudioInputStream inputAudio = null;
            try {
                inputAudio = AudioSystem.getAudioInputStream(new File(wavFileIn));
            }
            catch (UnsupportedAudioFileException e) {
                throw new IOException("Unsupported audio file: " + wavFileIn);
            }
            if (inputAudio != null) {
                this.header.samplingRate = (int)inputAudio.getFormat().getSampleRate();
                AudioDoubleDataSource signal = new AudioDoubleDataSource(inputAudio);
                this.contour = SignalProcUtils.getEnergyContourRms(signal.getAllData(), this.header.windowSizeInSeconds, this.header.skipSizeInSeconds, this.header.samplingRate);
                this.header.totalFrames = this.contour.length;
                if (energyFileOut != null && energyFileOut != null) {
                    EnergyContourRms.WriteEnergyFile(this, energyFileOut);
                }
            }
        }
    }

    public static void WriteEnergyFile(EnergyContourRms en, String energyFile) throws IOException {
        if (en.contour != null) {
            en.header.totalFrames = en.contour.length;
            MaryRandomAccessFile ler = null;
            try {
                ler = new MaryRandomAccessFile(energyFile, "rw");
            }
            catch (FileNotFoundException e) {
                throw new IOException("File not found: " + energyFile);
            }
            en.header.write(ler);
            ler.writeDouble(en.contour);
            ler.close();
        }
    }

    public static EnergyContourRms ReadEnergyFile(String energyFile) throws IOException {
        EnergyContourRms en = null;
        MaryRandomAccessFile ler = null;
        try {
            ler = new MaryRandomAccessFile(energyFile, "r");
        }
        catch (FileNotFoundException e) {
            throw new IOException("File not found: " + energyFile);
        }
        en = new EnergyContourRms();
        en.header.read(ler, true);
        en.contour = ler.readDouble(en.header.totalFrames);
        ler.close();
        return en;
    }
}

