/*
 * Decompiled with CFR 0.152.
 */
package marytts.modules.acoustic;

import java.io.IOException;
import java.io.InputStream;
import marytts.cart.DirectedGraph;
import marytts.cart.io.DirectedGraphReader;
import marytts.exceptions.MaryConfigurationException;
import marytts.features.FeatureProcessorManager;
import marytts.modules.acoustic.Model;
import marytts.unitselection.select.Target;

public class CARTModel
extends Model {
    private DirectedGraph cart;

    public CARTModel(FeatureProcessorManager featureManager, String voiceName, InputStream dataStream, String targetAttributeName, String targetAttributeFormat, String featureName, String predictFrom, String applyTo) throws MaryConfigurationException {
        super(featureManager, voiceName, dataStream, targetAttributeName, targetAttributeFormat, featureName, predictFrom, applyTo);
        this.load();
    }

    @Override
    protected void loadData() throws IOException, MaryConfigurationException {
        this.cart = new DirectedGraphReader().load(this.dataStream);
        try {
            this.predictionFeatureNames = this.cart.getFeatureDefinition().getFeatureNames();
        }
        catch (NullPointerException e) {
            throw new IOException("Could not get FeatureDefinition from CART", e);
        }
        if (this.predictionFeatureNames.length() == 0) {
            throw new IOException("Could not get prediction feature names");
        }
    }

    @Override
    protected float evaluate(Target target) throws Exception {
        assert (target != null);
        float[] result = null;
        try {
            result = (float[])this.cart.interpret(target);
        }
        catch (IllegalArgumentException e) {
            throw new Exception("Could not interpret target '" + target + "'", e);
        }
        float value = 0.0f;
        try {
            value = result[1];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new Exception("Could not handle predicted value: '" + value + "'", e);
        }
        return value;
    }
}

