/*
 * Decompiled with CFR 0.152.
 */
package marytts.features;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import marytts.features.FeatureProcessorManager;
import marytts.features.TargetFeatureComputer;
import marytts.modules.synthesis.Voice;
import org.apache.commons.collections.map.MultiKeyMap;

public class FeatureRegistry {
    private static Map<Locale, FeatureProcessorManager> managersByLocale = new HashMap<Locale, FeatureProcessorManager>();
    private static Map<Voice, FeatureProcessorManager> managersByVoice = new HashMap<Voice, FeatureProcessorManager>();
    private static FeatureProcessorManager fallbackManager = null;
    private static MultiKeyMap computers = new MultiKeyMap();

    private FeatureRegistry() {
    }

    public static void setFeatureProcessorManager(Locale locale, FeatureProcessorManager mgr) {
        managersByLocale.put(locale, mgr);
    }

    public static void setFallbackFeatureProcessorManager(FeatureProcessorManager mgr) {
        fallbackManager = mgr;
    }

    public static void setFeatureProcessorManager(Voice voice, FeatureProcessorManager mgr) {
        managersByVoice.put(voice, mgr);
    }

    public static FeatureProcessorManager getFeatureProcessorManager(Voice voice) {
        return managersByVoice.get(voice);
    }

    public static FeatureProcessorManager getFeatureProcessorManager(Locale locale) {
        FeatureProcessorManager m = managersByLocale.get(locale);
        if (m != null) {
            return m;
        }
        Locale lang = new Locale(locale.getLanguage());
        return managersByLocale.get(lang);
    }

    public static FeatureProcessorManager getFallbackFeatureProcessorManager() {
        return fallbackManager;
    }

    public static FeatureProcessorManager determineBestFeatureProcessorManager(Voice voice) {
        FeatureProcessorManager mgr = FeatureRegistry.getFeatureProcessorManager(voice);
        if (mgr == null) {
            mgr = FeatureRegistry.determineBestFeatureProcessorManager(voice.getLocale());
        }
        return mgr;
    }

    public static FeatureProcessorManager determineBestFeatureProcessorManager(Locale locale) {
        FeatureProcessorManager mgr = FeatureRegistry.getFeatureProcessorManager(locale);
        if (mgr == null) {
            Locale lang = new Locale(locale.getLanguage());
            mgr = FeatureRegistry.getFeatureProcessorManager(lang);
        }
        if (mgr == null) {
            mgr = FeatureRegistry.getFallbackFeatureProcessorManager();
        }
        assert (mgr != null);
        return mgr;
    }

    public static Collection<Locale> getSupportedLocales() {
        TreeSet<Locale> locales = new TreeSet<Locale>(new Comparator<Locale>(){

            @Override
            public int compare(Locale o1, Locale o2) {
                if (o1 == null) {
                    if (o2 == null) {
                        return 0;
                    }
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                return o1.toString().compareTo(o2.toString());
            }
        });
        locales.addAll(managersByLocale.keySet());
        return locales;
    }

    public static TargetFeatureComputer getTargetFeatureComputer(FeatureProcessorManager mgr, String features) {
        if (features == null) {
            features = mgr.listFeatureProcessorNames();
        } else {
            StringTokenizer st = new StringTokenizer(features);
            while (st.hasMoreTokens()) {
                String feature = st.nextToken();
                if (mgr.getFeatureProcessor(feature) != null) continue;
                throw new IllegalArgumentException("Feature processor manager '" + mgr.getClass().toString() + "' does not know the feature '" + feature + "'");
            }
        }
        TargetFeatureComputer tfc = (TargetFeatureComputer)computers.get(mgr, features);
        if (tfc == null) {
            tfc = new TargetFeatureComputer(mgr, features);
        }
        return tfc;
    }

    public static TargetFeatureComputer getTargetFeatureComputer(Locale locale, String features) {
        FeatureProcessorManager mgr = FeatureRegistry.determineBestFeatureProcessorManager(locale);
        return FeatureRegistry.getTargetFeatureComputer(mgr, features);
    }

    public static TargetFeatureComputer getTargetFeatureComputer(Voice voice, String features) {
        FeatureProcessorManager mgr = FeatureRegistry.determineBestFeatureProcessorManager(voice);
        return FeatureRegistry.getTargetFeatureComputer(mgr, features);
    }
}

