/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.engine.synthesis;

import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import javax.speech.synthesis.JSMLException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JSMLParser {
    Document document;

    public JSMLParser(String jsmlText, boolean validate) throws JSMLException {
        if (!jsmlText.substring(0, 2).equals("<?")) {
            jsmlText = "<jsml>\n" + jsmlText + "</jsml>\n";
        }
        try {
            this.document = this.parse(new InputSource(new StringReader(jsmlText)), validate);
        }
        catch (IOException e) {
            throw new JSMLException("JSMLParser: " + e.getMessage());
        }
    }

    public JSMLParser(URL jsmlSource, boolean validate) throws JSMLException, IOException {
        this.document = this.parse(new InputSource(jsmlSource.openStream()), validate);
    }

    public Document getDocument() {
        return this.document;
    }

    protected Document parse(InputSource source, boolean validate) throws JSMLException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = null;
        Document doc = null;
        dbf.setValidating(validate);
        dbf.setIgnoringComments(true);
        dbf.setIgnoringElementContentWhitespace(false);
        dbf.setCoalescing(true);
        dbf.setExpandEntityReferences(true);
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new JSMLException("JSMLParser: " + e.getMessage());
        }
        try {
            doc = db.parse(source);
        }
        catch (SAXException e) {
            throw new JSMLException("JSMLParser: " + e.getMessage());
        }
        return doc;
    }
}

