/*
 * Decompiled with CFR 0.152.
 */
package Jampack;

import Jampack.JampackException;

public class Z {
    public static final Z ONE = new Z(1.0, 0.0);
    public static final Z ZERO = new Z(0.0, 0.0);
    public static final Z I = new Z(0.0, 1.0);
    public double re;
    public double im;

    public Z() {
        this.re = 0.0;
        this.im = 0.0;
    }

    public Z(double x, double y) {
        this.re = x;
        this.im = y;
    }

    public Z(double x) {
        this.re = x;
        this.im = 0.0;
    }

    public Z(Z a) {
        this.re = a.re;
        this.im = a.im;
    }

    public boolean IsEqual(Z z1, Z z2) {
        return z1.re == z2.re && z1.im == z2.im;
    }

    public Z Eq(Z a) {
        this.re = a.re;
        this.im = a.im;
        return this;
    }

    public Z Eq(double a, double b) {
        this.re = a;
        this.im = b;
        return this;
    }

    public Z Exch(Z a) {
        double t = this.re;
        this.re = a.re;
        a.re = t;
        t = this.im;
        this.im = a.im;
        a.im = t;
        return this;
    }

    public static double abs1(Z z) {
        return Math.abs(z.re) + Math.abs(z.im);
    }

    public static double abs(Z z) {
        double aim;
        double are = Math.abs(z.re);
        if (are + (aim = Math.abs(z.im)) == 0.0) {
            return 0.0;
        }
        if (are >= aim) {
            double rho = aim / are;
            return are * Math.sqrt(1.0 + rho * rho);
        }
        double rho = are / aim;
        return aim * Math.sqrt(1.0 + rho * rho);
    }

    public Z Conj(Z a) {
        this.re = a.re;
        this.im = -a.im;
        return this;
    }

    public Z Minus(Z a) {
        this.re = -a.re;
        this.im = -a.im;
        return this;
    }

    public Z Plus(Z a, Z b) {
        this.re = a.re + b.re;
        this.im = a.im + b.im;
        return this;
    }

    public Z Minus(Z a, Z b) {
        this.re = a.re - b.re;
        this.im = a.im - b.im;
        return this;
    }

    public Z Times(Z a, Z b) {
        double tre = a.re * b.re - a.im * b.im;
        this.im = a.im * b.re + a.re * b.im;
        this.re = tre;
        return this;
    }

    public Z Times(double a, Z b) {
        this.re = a * b.re;
        this.im = a * b.im;
        return this;
    }

    public Z Div(Z a, Z b) throws JampackException {
        double avi = Z.abs(b);
        if (avi == 0.0) {
            throw new JampackException("Divide by zero.");
        }
        avi = 1.0 / avi;
        double tre = b.re * avi;
        double tim = -b.im * avi;
        double t = (a.re * tre - a.im * tim) * avi;
        this.im = (a.im * tre + a.re * tim) * avi;
        this.re = t;
        return this;
    }

    public Z Div(Z a, double b) throws JampackException {
        if (b == 0.0) {
            throw new JampackException("Divide by zero.");
        }
        this.re = a.re / b;
        this.im = a.im / b;
        return this;
    }

    public Z Sqrt(Z a) {
        double tim;
        double tre;
        double t = Z.abs(a);
        if (Math.abs(a.re) <= Math.abs(a.im)) {
            tre = Math.sqrt(0.5 * (t + a.re));
            tim = Math.sqrt(0.5 * (t - a.re));
        } else if (a.re > 0.0) {
            tre = t + a.re;
            tim = Math.abs(a.im) * Math.sqrt(0.5 / tre);
            tre = Math.sqrt(0.5 * tre);
        } else {
            tim = t - a.re;
            tre = Math.abs(a.im) * Math.sqrt(0.5 / tim);
            tim = Math.sqrt(0.5 * tim);
        }
        if (a.im < 0.0) {
            tim = -tim;
        }
        this.re = tre;
        this.im = tim;
        return this;
    }
}

