/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm.apps.cli;

import be.ac.ulg.montefiore.run.jahmm.Hmm;
import be.ac.ulg.montefiore.run.jahmm.Observation;
import be.ac.ulg.montefiore.run.jahmm.Opdf;
import be.ac.ulg.montefiore.run.jahmm.OpdfFactory;
import be.ac.ulg.montefiore.run.jahmm.apps.cli.AbnormalTerminationException;
import be.ac.ulg.montefiore.run.jahmm.apps.cli.ActionHandler;
import be.ac.ulg.montefiore.run.jahmm.apps.cli.CommandLineArguments;
import be.ac.ulg.montefiore.run.jahmm.apps.cli.RelatedObjs;
import be.ac.ulg.montefiore.run.jahmm.apps.cli.Types;
import be.ac.ulg.montefiore.run.jahmm.io.HmmWriter;
import be.ac.ulg.montefiore.run.jahmm.io.OpdfWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.EnumSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CreateActionHandler
extends ActionHandler {
    CreateActionHandler() {
    }

    @Override
    public void act() throws FileNotFoundException, IOException, AbnormalTerminationException {
        EnumSet<CommandLineArguments.Arguments> args = EnumSet.of(CommandLineArguments.Arguments.OPDF, CommandLineArguments.Arguments.NB_STATES, CommandLineArguments.Arguments.OUT_HMM);
        CommandLineArguments.checkArgs(args);
        int nbStates = CommandLineArguments.Arguments.NB_STATES.getAsInt();
        OutputStream outStream = CommandLineArguments.Arguments.OUT_HMM.getAsOutputStream();
        OutputStreamWriter outWriter = new OutputStreamWriter(outStream);
        this.write(outWriter, nbStates, Types.relatedObjs());
        ((Writer)outWriter).flush();
    }

    private <O extends Observation> void write(Writer outWriter, int nbStates, RelatedObjs<O> relatedObjs) throws IOException {
        OpdfFactory<Opdf<O>> opdfFactory = relatedObjs.opdfFactory();
        OpdfWriter<Opdf<O>> opdfWriter = relatedObjs.opdfWriter();
        Hmm<O> hmm = new Hmm<O>(nbStates, opdfFactory);
        HmmWriter.write(outWriter, opdfWriter, hmm);
    }
}

