/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm.apps.cli;

import be.ac.ulg.montefiore.run.jahmm.apps.cli.ActionHandler;
import be.ac.ulg.montefiore.run.jahmm.apps.cli.WrongArgumentsException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.EnumSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CommandLineArguments {
    CommandLineArguments() {
    }

    static void parse(String[] args) throws WrongArgumentsException {
        int i = 1;
        while (i < args.length) {
            block7: {
                Arguments[] argumentsArray = Arguments.values();
                int n = 0;
                int n2 = argumentsArray.length;
                while (n < n2) {
                    Arguments arg = argumentsArray[n];
                    if (arg.argString.equals(args[i])) {
                        if (arg.getIsSet()) {
                            throw new WrongArgumentsException("Argument '" + args[i] + "' given twice");
                        }
                        arg.setIsSet(true);
                        if (arg.hasAllowedValues()) {
                            if (i == args.length - 1) {
                                throw new WrongArgumentsException("Argument '" + args[i] + "' calls for an option");
                            }
                            String subArg = args[++i];
                            if (!arg.allowedValues[0].equals("") && !Arrays.asList(arg.allowedValues).contains(subArg)) {
                                throw new WrongArgumentsException("Invalid option '" + subArg + "'");
                            }
                            arg.set(subArg);
                        }
                        break block7;
                    }
                    ++n;
                }
                throw new WrongArgumentsException("Unknown argument '" + args[i] + "'");
            }
            ++i;
        }
    }

    static void checkArgs(EnumSet<Arguments> args) throws WrongArgumentsException {
        if (args.contains((Object)Arguments.OPDF)) {
            String opdf = Arguments.OPDF.get();
            if (opdf.equals("integer")) {
                args.add(Arguments.INTEGER_RANGE);
            } else if (opdf.equals("multi_gaussian")) {
                args.add(Arguments.VECTOR_DIMENSION);
            } else if (!opdf.equals("gaussian")) {
                if (opdf.equals("gaussian_mixture")) {
                    args.add(Arguments.NB_GAUSSIANS);
                } else {
                    new AssertionError((Object)("Unknown observation type '" + opdf + "'"));
                }
            }
        }
        for (Arguments arg : args) {
            if (arg.getIsSet() || arg.hasDefaultValue()) continue;
            throw new WrongArgumentsException("Argument '" + arg.argString + "' expected");
        }
        for (Arguments arg : EnumSet.complementOf(args)) {
            if (!arg.getIsSet()) continue;
            throw new WrongArgumentsException("Argument '" + arg.argString + "' not expected");
        }
    }

    static ActionHandler.Actions parseAction(String[] args) {
        if (args.length == 0) {
            return null;
        }
        ActionHandler.Actions mainAction = null;
        ActionHandler.Actions[] actionsArray = ActionHandler.Actions.values();
        int n = 0;
        int n2 = actionsArray.length;
        while (n < n2) {
            ActionHandler.Actions action = actionsArray[n];
            if (action.toString().equals(args[0])) {
                mainAction = action;
            }
            ++n;
        }
        return mainAction;
    }

    static void reset() {
        Arguments[] argumentsArray = Arguments.values();
        int n = 0;
        int n2 = argumentsArray.length;
        while (n < n2) {
            Arguments arg = argumentsArray[n];
            arg.setIsSet(false);
            ++n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Arguments {
        IN_HMM("-i", "-"),
        IN_KL_HMM("-ikl", ""),
        OUT_HMM("-o", "-"),
        IN_SEQ("-is", ""),
        OUT_SEQS("-os", "-"),
        OPDF("-opdf", "integer", "gaussian", "gaussian_mixture", "multi_gaussian"),
        INTEGER_RANGE("-r", ""),
        NB_GAUSSIANS("-ng", ""),
        VECTOR_DIMENSION("-d", ""),
        NB_ITERATIONS("-ni", "10"),
        NB_STATES("-n", "");

        final String argString;
        final String[] allowedValues;
        private String value;
        private String defaultValue;
        private boolean isSet = false;

        private Arguments(String argString, String ... allowedValues) {
            this.argString = argString;
            if (allowedValues.length == 1 && !allowedValues[0].equals("")) {
                this.defaultValue = allowedValues[0];
                this.allowedValues = new String[]{""};
            } else {
                this.defaultValue = null;
                this.allowedValues = allowedValues;
            }
        }

        boolean hasAllowedValues() {
            return this.allowedValues.length != 0;
        }

        void set(String o) {
            this.value = o;
        }

        boolean getIsSet() {
            return this.isSet;
        }

        void setIsSet(boolean isSet) {
            this.isSet = isSet;
        }

        boolean hasDefaultValue() {
            return this.defaultValue != null;
        }

        String get() throws WrongArgumentsException {
            if (!this.isSet) {
                if (this.hasDefaultValue()) {
                    return this.defaultValue;
                }
                throw new WrongArgumentsException("Argument '" + this.argString + "' expected");
            }
            return this.value;
        }

        String getDefault() {
            if (!this.hasDefaultValue()) {
                throw new UnsupportedOperationException("No default value");
            }
            return this.defaultValue;
        }

        int getAsInt() throws WrongArgumentsException {
            int i = -1;
            try {
                i = Integer.parseInt(this.get());
            }
            catch (NumberFormatException e) {
                throw new WrongArgumentsException("'" + this.get() + "' is not a number; number expected");
            }
            return i;
        }

        InputStream getAsInputStream() throws FileNotFoundException, WrongArgumentsException {
            if (this.get().equals("-")) {
                return System.in;
            }
            return new FileInputStream(this.get());
        }

        OutputStream getAsOutputStream() throws FileNotFoundException, WrongArgumentsException {
            if (this.get().equals("-")) {
                return System.out;
            }
            return new FileOutputStream(this.get());
        }
    }
}

