/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.parser;

import java.io.File;
import java.io.IOException;
import opennlp.tools.cmdline.BasicTrainingParameters;
import opennlp.tools.cmdline.CmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.parser.ParserModelLoader;
import opennlp.tools.cmdline.parser.ParserTrainerTool;
import opennlp.tools.parser.Parse;
import opennlp.tools.parser.ParserModel;
import opennlp.tools.util.ObjectStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ModelUpdaterTool
implements CmdLineTool {
    ModelUpdaterTool() {
    }

    protected abstract ParserModel trainAndUpdate(ParserModel var1, ObjectStream<Parse> var2, BasicTrainingParameters var3) throws IOException;

    @Override
    public String getHelp() {
        return "Usage: opennlp " + this.getName() + " -data training.file -model parser.model";
    }

    @Override
    public final void run(String[] args) {
        ParserModel updatedParserModel;
        if (args.length < 8) {
            System.out.println(this.getHelp());
            throw new TerminateToolException(1);
        }
        BasicTrainingParameters parameters = new BasicTrainingParameters(args);
        File modelFile = new File(CmdLineUtil.getParameter("-model", args));
        ParserModel originalParserModel = (ParserModel)new ParserModelLoader().load(modelFile);
        ObjectStream<Parse> parseSamples = ParserTrainerTool.openTrainingData(new File(CmdLineUtil.getParameter("-data", args)), parameters.getEncoding());
        try {
            updatedParserModel = this.trainAndUpdate(originalParserModel, parseSamples, parameters);
        }
        catch (IOException e) {
            CmdLineUtil.printTrainingIoError(e);
            throw new TerminateToolException(-1);
        }
        finally {
            try {
                parseSamples.close();
            }
            catch (IOException e) {}
        }
        CmdLineUtil.writeModel("parser", modelFile, updatedParserModel);
    }
}

